/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.HeadlessException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeService;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreePanels;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.FavouriteSelectBox;
import nl.mpi.arbil.ui.ImportExportDialog;
import nl.mpi.arbil.ui.fieldeditors.ArbilLongFieldEditor;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import nl.mpi.arbil.util.XsdChecker;
import nl.mpi.flap.plugin.PluginDialogHandler;

public class ArbilTreeController {
    private final SessionStorage sessionStorage;
    private final TreeHelper treeHelper;
    private final WindowManager windowManager;
    private final MessageDialogHandler dialogHandler;
    private final DataNodeLoader dataNodeLoader;

    public ArbilTreeController(SessionStorage sessionStorage, TreeHelper treeHelper, WindowManager windowManager, MessageDialogHandler dialogHandler, DataNodeLoader dataNodeLoader) {
        this.sessionStorage = sessionStorage;
        this.treeHelper = treeHelper;
        this.windowManager = windowManager;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
    }

    public void reImportBranch(ArbilDataNode leadSelectedTreeNode, ArbilTreePanels treePanels) {
        try {
            URI remoteDataFile = this.sessionStorage.getOriginatingUri(leadSelectedTreeNode.getURI());
            if (remoteDataFile != null) {
                ArbilDataNode originatingNode = this.dataNodeLoader.getArbilDataNodeWithoutLoading(remoteDataFile);
                if (originatingNode.isLocal() && !originatingNode.getFile().exists()) {
                    this.dialogHandler.addMessageDialogToQueue("The origional file location cannot be found", "Re Import Branch");
                } else if (originatingNode.isMetaDataNode()) {
                    ImportExportDialog importExportDialog = new ImportExportDialog(treePanels.localCorpusTree);
                    importExportDialog.setDestinationNode(leadSelectedTreeNode);
                    importExportDialog.copyToCache(new ArbilDataNode[]{originatingNode});
                } else {
                    this.dialogHandler.addMessageDialogToQueue("Could not determine the origional node type", "Re Import Branch");
                }
            } else {
                this.dialogHandler.addMessageDialogToQueue("Could not determine the origional location", "Re Import Branch");
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void setManualResourceLocation(ArbilDataNode leadSelectedTreeNode) throws HeadlessException {
        String initialValue = leadSelectedTreeNode.hasLocalResource() ? leadSelectedTreeNode.resourceUrlField.getFieldValue() : "";
        String manualLocation = (String)JOptionPane.showInputDialog(this.windowManager.getMainFrame(), "Enter the resource URI:", "Manual resource location", -1, null, null, initialValue);
        if (manualLocation != null) {
            try {
                URI locationURI = new URI(manualLocation);
                if (this.checkResourceLocation(locationURI)) {
                    leadSelectedTreeNode.insertResourceLocation(locationURI);
                }
            }
            catch (URISyntaxException ex) {
                this.dialogHandler.addMessageDialogToQueue("The URI entered as a resource location is invalid. Please check the location and try again.", "Invalid URI");
            }
            catch (ArbilMetadataException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
                this.dialogHandler.addMessageDialogToQueue("Could not add resource to the metadata. Check the error log for details.", "Error adding resource");
            }
        }
    }

    private boolean checkResourceLocation(URI locationURI) {
        if (locationURI.isAbsolute()) {
            try {
                File file = ArbilDataNode.getFile(locationURI);
                if (file != null && !file.exists()) {
                    this.dialogHandler.addMessageDialogToQueue("Warning: no file exists at the specified location!", "Manual resource location");
                }
                return true;
            }
            catch (IllegalArgumentException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
                this.dialogHandler.addMessageDialogToQueue("Illegal file name. Check the error log for details.", "Error adding resource");
                return false;
            }
        }
        this.dialogHandler.addMessageDialogToQueue("Location should be an absolute URI. This means it should start with a scheme, for example \"http://\" or \"file://\".", "Error adding resource");
        return false;
    }

    public void addRemoteCorpus() {
        String addableLocation = JOptionPane.showInputDialog(this.windowManager.getMainFrame(), "Enter the URL", "Add Location", -1);
        this.addRemoteCorpus(addableLocation);
    }

    public void addRemoteCorpus(String addableLocation) {
        if (addableLocation != null && addableLocation.length() > 0) {
            try {
                this.treeHelper.addLocationInteractive(ArbilDataNodeService.conformStringToUrl(addableLocation));
            }
            catch (URISyntaxException ex) {
                this.dialogHandler.addMessageDialogToQueue("Failed to add location to remote corpus. See error log for details.", "Error");
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
    }

    public void searchSubnodes(ArbilTreePanels treePanels) {
        this.windowManager.openSearchTable(treePanels.localCorpusTree.getAllSelectedNodes(), "Search");
    }

    public void searchRemoteSubnodes(ArbilTreePanels treePanels) {
        this.windowManager.openSearchTable(treePanels.remoteCorpusTree.getSelectedNodes(), "Search Remote Corpus");
    }

    public void validateNodes(ArbilDataNode[] selectedTreeNodes) {
        for (ArbilDataNode currentNode : selectedTreeNodes) {
            if (currentNode.getNeedsSaveToDisk(false) && 0 == this.dialogHandler.showDialogBox("Validation will be against the file on disk. Save changes first?", "Validation", 0, 2)) {
                currentNode.saveChangesToCache(true);
                currentNode.reloadNode();
            }
            XsdChecker xsdChecker = new XsdChecker();
            ((ArbilWindowManager)this.windowManager).createWindow("XsdChecker", xsdChecker);
            xsdChecker.checkXML(currentNode);
            xsdChecker.setDividerLocation(0.5);
        }
    }

    public void addFromFavourite(ArbilDataNode leadSelectedTreeNode, String favouriteUrlString, String displayName) {
        try {
            ArbilDataNode templateDataNode = this.dataNodeLoader.getArbilDataNode(null, ArbilDataNodeService.conformStringToUrl(favouriteUrlString));
            if (leadSelectedTreeNode != null) {
                new MetadataBuilder().requestAddNode(leadSelectedTreeNode, displayName, templateDataNode);
            } else {
                new MetadataBuilder().requestAddRootNode(templateDataNode, displayName);
            }
        }
        catch (Exception ex) {
            this.dialogHandler.addMessageDialogToQueue("Failed to add from favourites, see error log for details.", "Error");
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void viewSelectedNodes(ArbilTree tree) {
        try {
            ArrayList<ArbilDataNode> filteredNodes = new ArrayList<ArbilDataNode>();
            for (ArbilDataNode currentItem : tree.getSelectedNodes()) {
                if (currentItem.isMetaDataNode() || currentItem.getFields().size() > 0) {
                    filteredNodes.add(currentItem);
                    continue;
                }
                try {
                    this.windowManager.openUrlWindowOnce(currentItem.toString(), currentItem.getURI().toURL());
                }
                catch (MalformedURLException murle) {
                    BugCatcherManager.getBugCatcher().logError(murle);
                }
            }
            if (filteredNodes.size() > 0) {
                this.windowManager.openFloatingTableOnce(filteredNodes.toArray(new ArbilDataNode[0]), null);
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void viewSelectedSubnodes(ArbilTree tree) {
        ArbilDataNode[] selectedNodes = tree.getSelectedNodes();
        ArrayList<ArbilDataNode> filteredNodes = new ArrayList<ArbilDataNode>(selectedNodes.length);
        for (ArbilDataNode dataNode : selectedNodes) {
            if (!dataNode.isSession() && !dataNode.isMetaDataNode()) continue;
            filteredNodes.add(dataNode);
        }
        if (!filteredNodes.isEmpty()) {
            this.windowManager.openFloatingSubnodesWindows(filteredNodes.toArray(new ArbilDataNode[0]));
        }
    }

    public void openSelectedNodesInTable(ArbilTree tree) {
        this.windowManager.openFloatingTableOnce(tree.getSelectedNodes(), null);
    }

    public void startLongFieldEditor(ArbilTree tree) {
        ArbilDataNode[] selectedNodes;
        for (ArbilDataNode node : selectedNodes = tree.getSelectedNodes()) {
            if (node.getFields().size() <= 0) continue;
            List<ArbilField[]> fieldArrays = node.getFieldsSorted();
            new ArbilLongFieldEditor().showEditor(fieldArrays.get(0), fieldArrays.get(0)[0].getFieldValue(), 0);
        }
    }

    public void copyBranch(ArbilTree tree) {
        try {
            ImportExportDialog importExportDialog = new ImportExportDialog(tree);
            importExportDialog.copyToCache(tree.getSelectedNodes());
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void addLocalDirectory() {
        File[] selectedFiles = this.dialogHandler.showDirectorySelectBox("Add Working Directory", true);
        if (selectedFiles != null && selectedFiles.length > 0) {
            for (File currentDirectory : selectedFiles) {
                this.treeHelper.addLocationInteractive(currentDirectory.toURI());
            }
        }
    }

    public void addBulkResources(ArbilNode targetObject) {
        try {
            FavouriteSelectBox favouriteSelectBox = new FavouriteSelectBox(targetObject);
            File[] selectedFiles = this.dialogHandler.showFileSelectBox("Add Bulk Resources", false, true, null, PluginDialogHandler.DialogueType.open, favouriteSelectBox);
            if (selectedFiles != null && selectedFiles.length > 0) {
                new MetadataBuilder().requestAddNodeAndResources(favouriteSelectBox.getTargetNode(), "Add Bulk Resources", favouriteSelectBox.getSelectedFavouriteNode(), selectedFiles, favouriteSelectBox.getCopyDirectoryStructure(), favouriteSelectBox.getMetadataFilePerResource());
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void addNodeFromTemplate(ArbilDataNode leadSelectedTreeNode, String nodeType, String displayName) {
        try {
            if (leadSelectedTreeNode != null) {
                new MetadataBuilder().requestAddNode(leadSelectedTreeNode, nodeType, displayName);
            } else {
                new MetadataBuilder().requestRootAddNode(nodeType, displayName);
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void addSubnode(ArbilDataNode leadSelectedTreeNode, String nodeType, String nodeText) {
        try {
            if (leadSelectedTreeNode != null) {
                if (!leadSelectedTreeNode.getParentDomNode().getNeedsSaveToDisk(false) || this.dialogHandler.showConfirmDialogBox("Adding a node will save pending changes to \"" + leadSelectedTreeNode.getParentDomNode().toString() + "\" to disk. Do you want to proceed?", "Save pending changes?")) {
                    new MetadataBuilder().requestAddNode(leadSelectedTreeNode, nodeType, nodeText);
                }
            } else {
                new MetadataBuilder().requestRootAddNode(nodeType, nodeText);
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }
}

