/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.fieldeditors;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.util.BugCatcherManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageIdBox
extends JComboBox {
    public static final int languageSelectWidth = 100;
    private static final String defaultLanguageDropDownValue = "<select>";
    private static final String initializingDropDownValue = "initializing...";
    private final ArbilField cellField;

    public LanguageIdBox(ArbilField cellField, Rectangle parentCellRect) {
        this.cellField = cellField;
        this.setEditable(false);
        if (parentCellRect != null) {
            this.setPreferredSize(new Dimension(100, parentCellRect.height));
        }
        this.addItem(initializingDropDownValue);
        this.setEnabled(false);
    }

    public void init() {
        new Thread(){

            public void run() {
                String fieldLanguageId = LanguageIdBox.this.cellField.getLanguageId();
                List<ArbilVocabularyItem> languageItemArray = LanguageIdBox.this.cellField.getDocumentationLanguages().getSortedLanguageListSubset();
                if (languageItemArray != null) {
                    LanguageIdBox.this.setItems(languageItemArray, fieldLanguageId);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LanguageIdBox.this.setActionListener();
                            LanguageIdBox.this.setEnabled(true);
                        }
                    });
                }
            }
        }.start();
    }

    private void setItems(final List<ArbilVocabularyItem> languageItemArray, String fieldLanguageId) {
        final ArbilVocabularyItem selectedItem = this.findSelectedItem(fieldLanguageId, languageItemArray);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LanguageIdBox.this.addItems(languageItemArray, selectedItem);
            }
        });
    }

    private ArbilVocabularyItem findSelectedItem(String fieldLanguageId, List<ArbilVocabularyItem> languageItemArray) {
        ArbilVocabularyItem selectedItem = null;
        if (fieldLanguageId != null) {
            for (ArbilVocabularyItem currentItem : languageItemArray) {
                if (!fieldLanguageId.equals(currentItem.itemCode) && !fieldLanguageId.equals(currentItem.descriptionString)) continue;
                selectedItem = currentItem;
                break;
            }
        }
        return selectedItem;
    }

    private void addItems(List<ArbilVocabularyItem> languageItemArray, ArbilVocabularyItem selectedItem) {
        this.removeItem(initializingDropDownValue);
        for (ArbilVocabularyItem currentItem : languageItemArray) {
            this.addItem(currentItem);
        }
        this.addItem(defaultLanguageDropDownValue);
        if (selectedItem != null) {
            this.setSelectedItem(selectedItem);
        } else {
            this.setSelectedItem(defaultLanguageDropDownValue);
        }
    }

    private void setActionListener() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (LanguageIdBox.this.getSelectedItem() instanceof ArbilVocabularyItem) {
                        ArbilVocabularyItem selectedLanguage = (ArbilVocabularyItem)LanguageIdBox.this.getSelectedItem();
                        String languageCode = selectedLanguage.itemCode;
                        if (languageCode == null) {
                            languageCode = selectedLanguage.descriptionString;
                        }
                        LanguageIdBox.this.cellField.setLanguageId(languageCode, true, false);
                    } else if (LanguageIdBox.defaultLanguageDropDownValue.equals(LanguageIdBox.this.getSelectedItem())) {
                        LanguageIdBox.this.cellField.setLanguageId(null, true, false);
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
    }
}

