/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.IMDIVocabularies;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.plugins.ArbilPluginManager;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilHelp;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.ImportExportDialog;
import nl.mpi.arbil.ui.LanguageListDialogue;
import nl.mpi.arbil.ui.PreviewSplitPanel;
import nl.mpi.arbil.ui.TemplateDialogue;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizard;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.MimeHashQueue;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import nl.mpi.arbilcommons.journal.ArbilJournal;
import nl.mpi.pluginloader.PluginManager;
import nl.mpi.pluginloader.PluginService;
import nl.mpi.pluginloader.ui.PluginMenu;
import org.xml.sax.SAXException;

public class ArbilMenuBar
extends JMenuBar {
    public static final String FORUM_URL = "http://tla.mpi.nl/forums/software/arbil/";
    private static SessionStorage sessionStorage;
    private static MimeHashQueue mimeHashQueue;
    private static ArbilTreeHelper treeHelper;
    private static ArbilWindowManager windowManager;
    private static MessageDialogHandler dialogHandler;
    private static DataNodeLoader dataNodeLoader;
    public static final JMenu windowMenu;
    private boolean macOsMenu = false;
    private JMenuItem saveFileMenuItem = new JMenuItem();
    private JMenuItem showChangedNodesMenuItem = new JMenuItem();
    private JCheckBoxMenuItem saveWindowsCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem shortCutKeysjMenuItem = new JMenuItem();
    private JMenuItem arbilForumMenuItem = new JMenuItem();
    private JMenuItem checkForUpdatesMenuItem = new JMenuItem();
    private JMenuItem viewErrorLogMenuItem = new JMenuItem();
    private JCheckBoxMenuItem showSelectionPreviewCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem templatesMenu = new JMenuItem();
    private JCheckBoxMenuItem trackTableSelectionCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem useLanguageIdInColumnNameCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem undoMenuItem = new JMenuItem();
    private JMenu setCacheDirectoryMenu = new JMenu();
    private JMenu viewMenu = new JMenu();
    private JMenuItem resetWindowsMenuItem = new JMenuItem();
    private JMenuItem closeWindowsMenuItem = new JMenuItem();
    private JMenu optionsMenu = new JMenu();
    private JMenuItem searchReplaceMenuItem;
    private JMenuItem pasteMenuItem = new JMenuItem();
    private JMenuItem printHelpMenuItem = new JMenuItem();
    private JMenuItem redoMenuItem = new JMenuItem();
    public JCheckBoxMenuItem checkNewVersionAtStartCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JMenuItem copyMenuItem = new JMenuItem();
    private JCheckBoxMenuItem copyNewResourcesCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem checkResourcePermissionsCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem schemaCheckLocalFiles = new JCheckBoxMenuItem();
    private JMenuItem editPreferredLanguagesMenuItem = new JMenuItem();
    private JMenuItem editFieldViewsMenuItem = new JMenuItem();
    private JMenuItem updateAllLoadedVocabulariesMenuItem = new JMenuItem();
    private JMenu editMenu = new JMenu();
    private JMenu fileMenu = new JMenu();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpMenuItem = new JMenuItem();
    private JMenuItem setupWizardMenuItem = new JMenuItem();
    private JMenuItem importMenuItem = new JMenuItem();
    private JCheckBoxMenuItem showStatusBarMenuItem = new JCheckBoxMenuItem();
    private PreviewSplitPanel previewSplitPanel;
    private JApplet containerApplet = null;
    private JMenuItem exitMenuItem = new JMenuItem(){

        public boolean isVisible() {
            return !ArbilMenuBar.this.isMacOsMenu();
        }
    };
    private JMenuItem aboutMenuItem = new JMenuItem(){

        public boolean isVisible() {
            return !ArbilMenuBar.this.isMacOsMenu();
        }
    };
    private static ApplicationVersionManager versionManager;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setMimeHashQueue(MimeHashQueue mimeHashQueueInstance) {
        mimeHashQueue = mimeHashQueueInstance;
    }

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        if (!(treeHelperInstance instanceof ArbilTreeHelper)) {
            throw new RuntimeException(MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ARBILMENUBAR REQUIRES ARBILTREEHELPER. FOUND {0}"), treeHelperInstance.getClass()));
        }
        treeHelper = (ArbilTreeHelper)treeHelperInstance;
    }

    public static void setWindowManager(WindowManager windowManagerInstance) {
        if (!(windowManagerInstance instanceof ArbilWindowManager)) {
            throw new RuntimeException(MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ARBILMENUBAR REQUIRES ARBILWINDOWMANAGER. FOUND {0}"), windowManagerInstance.getClass()));
        }
        windowManager = (ArbilWindowManager)windowManagerInstance;
    }

    public static void setMessageDialogHandler(MessageDialogHandler dialogHandlerInstance) {
        dialogHandler = dialogHandlerInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public static void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        versionManager = versionManagerInstance;
    }

    public ArbilMenuBar(PreviewSplitPanel previewSplitPanelLocal, JApplet containerAppletLocal) {
        this.containerApplet = containerAppletLocal;
        this.previewSplitPanel = previewSplitPanelLocal;
        this.initFileMenu();
        this.initEditMenu();
        this.initOptionsMenu();
        this.initPluginMenu();
        this.initWindowMenu();
        this.initHelpMenu();
        this.setUpHotKeys();
    }

    private ArbilHelp getArbilHelp() {
        try {
            return ArbilHelp.getArbilHelpInstance();
        }
        catch (IOException ioEx) {
            dialogHandler.addMessageDialogToQueue(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("I/O ERROR WHILE TRYING TO READ HELP SYSTEM! SEE ERROR LOG FOR DETAILS."), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ERROR"));
            BugCatcherManager.getBugCatcher().logError(ioEx);
        }
        catch (SAXException saxEx) {
            dialogHandler.addMessageDialogToQueue(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("PARSER ERROR WHILE TRYING TO READ HELP SYSTEM! SEE ERROR LOG FOR DETAILS."), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ERROR"));
            BugCatcherManager.getBugCatcher().logError(saxEx);
        }
        return null;
    }

    private void initFileMenu() {
        this.fileMenu.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("FILE"));
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.saveFileMenuItem.setEnabled(dataNodeLoader.nodesNeedSave());
                ArbilMenuBar.this.showChangedNodesMenuItem.setEnabled(dataNodeLoader.nodesNeedSave());
            }
        });
        this.saveFileMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SAVE CHANGES"));
        this.saveFileMenuItem.setEnabled(false);
        this.saveFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    windowManager.stopEditingInCurrentWindow();
                    dataNodeLoader.saveNodesNeedingSave(true);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.fileMenu.add(this.saveFileMenuItem);
        this.showChangedNodesMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SHOW MODIFIED NODES"));
        this.showChangedNodesMenuItem.setEnabled(false);
        this.showChangedNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArrayList<ArbilDataNode> individualChangedNodes = new ArrayList<ArbilDataNode>();
                    for (ArbilDataNode currentTestable : dataNodeLoader.getNodesNeedSave()) {
                        if (currentTestable.hasChangedFields()) {
                            individualChangedNodes.add(currentTestable);
                        }
                        for (ArbilDataNode currentChildSaveable : currentTestable.getAllChildren()) {
                            if (!currentChildSaveable.hasChangedFields()) continue;
                            individualChangedNodes.add(currentChildSaveable);
                        }
                    }
                    windowManager.openFloatingTable(individualChangedNodes.toArray(new ArbilDataNode[0]), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("MODIFIED NODES"));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.fileMenu.add(this.showChangedNodesMenuItem);
        this.importMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("IMPORT..."));
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.importMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.exitMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("EXIT"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.exitMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        if (this.containerApplet == null) {
            this.fileMenu.add(this.exitMenuItem);
        } else {
            String loggedInUserName = this.containerApplet.getParameter(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("USERNAME"));
            if (loggedInUserName == null) {
                loggedInUserName = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("UNKNOWN USER");
            }
            JMenuItem logoutButton = new JMenuItem(MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("LOG OUT ({0})"), loggedInUserName));
            logoutButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String logoutUrl = ArbilMenuBar.this.containerApplet.getParameter(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("LOGOUTURL"));
                    try {
                        if (ArbilMenuBar.this.containerApplet != null) {
                            ArbilMenuBar.this.containerApplet.getAppletContext().showDocument(new URL(logoutUrl));
                        }
                    }
                    catch (MalformedURLException ex) {
                        dialogHandler.addMessageDialogToQueue(MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("INVALID LOGOUT URL: {0}"), logoutUrl), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("LOGOUT ERROR"));
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            });
            this.fileMenu.add(logoutButton);
        }
        this.add(this.fileMenu);
    }

    private void initEditMenu() {
        this.editMenu.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("EDIT"));
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.undoMenuItem.setEnabled(ArbilJournal.getSingleInstance().canUndo());
                ArbilMenuBar.this.redoMenuItem.setEnabled(ArbilJournal.getSingleInstance().canRedo());
            }
        });
        this.copyMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("COPY"));
        this.copyMenuItem.setEnabled(false);
        this.pasteMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("PASTE"));
        this.pasteMenuItem.setEnabled(false);
        this.undoMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("UNDO"));
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilJournal.getSingleInstance().undoFromFieldChangeHistory();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.searchReplaceMenuItem = new JMenuItem(){

            public boolean isEnabled() {
                return windowManager.getCurrentFrameComponent() instanceof ArbilSplitPanel;
            }
        };
        this.searchReplaceMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("FIND/REPLACE"));
        this.searchReplaceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component selectedComponent = windowManager.getCurrentFrameComponent();
                if (selectedComponent instanceof ArbilSplitPanel) {
                    ((ArbilSplitPanel)selectedComponent).showSearchPane();
                }
            }
        });
        this.editMenu.add(this.searchReplaceMenuItem);
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("REDO"));
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilJournal.getSingleInstance().redoFromFieldChangeHistory();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.add(this.editMenu);
    }

    private void initOptionsMenu() {
        this.optionsMenu.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("OPTIONS"));
        this.templatesMenu.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("TEMPLATES & PROFILES..."));
        this.templatesMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TemplateDialogue.showTemplatesDialogue();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.optionsMenu.add(this.templatesMenu);
        this.setCacheDirectoryMenu.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("LOCAL CORPUS STORAGE DIRECTORY"));
        this.setCacheDirectoryMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.setCacheDirectoryMenu.removeAll();
                JMenuItem cacheDirectoryMenuItem = new JMenuItem();
                cacheDirectoryMenuItem.setText(sessionStorage.getProjectWorkingDirectory().getAbsolutePath());
                cacheDirectoryMenuItem.setEnabled(false);
                JMenuItem changeCacheDirectoryMenuItem = new JMenuItem();
                changeCacheDirectoryMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("MOVE LOCAL CORPUS STORAGE DIRECTORY..."));
                changeCacheDirectoryMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            dialogHandler.offerUserToSaveChanges();
                            File[] selectedFiles = dialogHandler.showDirectorySelectBox(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("MOVE LOCAL CORPUS STORAGE DIRECTORY"), false);
                            if (selectedFiles != null && selectedFiles.length > 0) {
                                sessionStorage.changeCacheDirectory(selectedFiles[0], true);
                            }
                        }
                        catch (Exception ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                    }
                });
                ArbilMenuBar.this.setCacheDirectoryMenu.add(cacheDirectoryMenuItem);
                ArbilMenuBar.this.setCacheDirectoryMenu.add(changeCacheDirectoryMenuItem);
            }
        });
        this.optionsMenu.add(this.setCacheDirectoryMenu);
        this.editPreferredLanguagesMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("EDIT IMDI LANGUAGE LIST..."));
        this.editPreferredLanguagesMenuItem.setEnabled(true);
        this.editPreferredLanguagesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LanguageListDialogue.showLanguageDialogue();
            }
        });
        this.optionsMenu.add(this.editPreferredLanguagesMenuItem);
        this.updateAllLoadedVocabulariesMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("RE-DOWNLOAD CURRENT VOCABULARIES"));
        this.updateAllLoadedVocabulariesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IMDIVocabularies.getSingleInstance().redownloadCurrentlyLoadedVocabularies();
            }
        });
        this.optionsMenu.add(this.updateAllLoadedVocabulariesMenuItem);
        this.saveWindowsCheckBoxMenuItem.setSelected(sessionStorage.loadBoolean("saveWindows", true));
        this.saveWindowsCheckBoxMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SAVE WINDOWS ON EXIT"));
        this.optionsMenu.add(this.saveWindowsCheckBoxMenuItem);
        this.showSelectionPreviewCheckBoxMenuItem.setSelected(sessionStorage.loadBoolean("showSelectionPreview", true));
        this.previewSplitPanel.setPreviewPanel(this.showSelectionPreviewCheckBoxMenuItem.getState());
        this.showSelectionPreviewCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.showSelectionPreviewCheckBoxMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SHOW SELECTION PREVIEW"));
        this.showSelectionPreviewCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.previewSplitPanel.setPreviewPanel(ArbilMenuBar.this.showSelectionPreviewCheckBoxMenuItem.getState());
                    sessionStorage.saveBoolean("showSelectionPreview", ArbilMenuBar.this.showSelectionPreviewCheckBoxMenuItem.isSelected());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.optionsMenu.add(this.showSelectionPreviewCheckBoxMenuItem);
        this.showStatusBarMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SHOW STATUS BAR"));
        this.showStatusBarMenuItem.setState(sessionStorage.loadBoolean("showStatusBar", false));
        this.showStatusBarMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.showStatusBarMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                windowManager.setStatusBarVisible(ArbilMenuBar.this.showStatusBarMenuItem.getState());
                sessionStorage.saveBoolean("showStatusBar", ArbilMenuBar.this.showStatusBarMenuItem.getState());
            }
        });
        this.optionsMenu.add(this.showStatusBarMenuItem);
        this.checkNewVersionAtStartCheckBoxMenuItem.setSelected(sessionStorage.loadBoolean("checkNewVersionAtStart", true));
        this.checkNewVersionAtStartCheckBoxMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CHECK FOR NEW VERSION ON START"));
        this.optionsMenu.add(this.checkNewVersionAtStartCheckBoxMenuItem);
        this.copyNewResourcesCheckBoxMenuItem.setSelected(MetadataReader.getSingleInstance().copyNewResourcesToCache);
        this.copyNewResourcesCheckBoxMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("COPY NEW RESOURCES INTO CACHE"));
        this.copyNewResourcesCheckBoxMenuItem.setToolTipText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("WHEN ADDING A NEW RESOURCE TO A SESSION THIS OPTIONS WILL COPY THE FILE INTO THE LOCAL CACHE RATHER THAN LINKING TO ITS CURRENT LOCATION. THIS OPTION CAN MAKE A CONSIDERABLE DIFFERENCE TO DISK USE IF YOU ARE HANDLING LARGE FILES."));
        this.copyNewResourcesCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MetadataReader.getSingleInstance().copyNewResourcesToCache = ArbilMenuBar.this.copyNewResourcesCheckBoxMenuItem.isSelected();
                sessionStorage.saveBoolean("copyNewResources", ArbilMenuBar.this.copyNewResourcesCheckBoxMenuItem.isSelected());
            }
        });
        this.optionsMenu.add(this.copyNewResourcesCheckBoxMenuItem);
        this.checkResourcePermissionsCheckBoxMenuItem.setSelected(mimeHashQueue.isCheckResourcePermissions());
        this.checkResourcePermissionsCheckBoxMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CHECK PERMISSIONS FOR REMOTE RESOURCES"));
        this.checkResourcePermissionsCheckBoxMenuItem.setToolTipText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("THIS OPTION CHECKS THE SERVER PERMISSIONS FOR REMOTE RESOURCES AND SHOWS ICONS ACCORDINGLY."));
        this.checkResourcePermissionsCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                mimeHashQueue.setCheckResourcePermissions(ArbilMenuBar.this.checkResourcePermissionsCheckBoxMenuItem.isSelected());
                sessionStorage.saveBoolean("checkResourcePermissions", ArbilMenuBar.this.checkResourcePermissionsCheckBoxMenuItem.isSelected());
                dialogHandler.addMessageDialogToQueue(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("THE SETTING CHANGE WILL BE EFFECTIVE WHEN ARBIL IS RESTARTED."), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CHECK PERMISSIONS FOR REMOTE RESOURCES"));
            }
        });
        this.optionsMenu.add(this.checkResourcePermissionsCheckBoxMenuItem);
        this.schemaCheckLocalFiles.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ALWAYS CHECK LOCAL METADATA FILES FOR XML CONFORMANCE"));
        this.schemaCheckLocalFiles.setSelected(dataNodeLoader.isSchemaCheckLocalFiles());
        this.schemaCheckLocalFiles.setToolTipText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("THIS OPTION CHECKS ALL LOCAL METADATA FILES FOR XML CONFORMANCE EVERY TIME THEY ARE LOADED. IF THE METADATA FILE DOES NOT VALIDATE AGAINST THE SCHEMA IT WILL BE HIGHLIGHTED RED IN THE TREE."));
        this.schemaCheckLocalFiles.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                dataNodeLoader.setSchemaCheckLocalFiles(ArbilMenuBar.this.schemaCheckLocalFiles.isSelected());
                sessionStorage.saveBoolean("schemaCheckLocalFiles", ArbilMenuBar.this.schemaCheckLocalFiles.isSelected());
            }
        });
        this.optionsMenu.add(this.schemaCheckLocalFiles);
        this.trackTableSelectionCheckBoxMenuItem.setSelected(sessionStorage.loadBoolean("trackTableSelection", false));
        this.trackTableSelectionCheckBoxMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("TRACK TABLE SELECTION IN TREE"));
        this.trackTableSelectionCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    sessionStorage.saveBoolean("useLanguageIdInColumnName", ArbilMenuBar.this.trackTableSelectionCheckBoxMenuItem.getState());
                    sessionStorage.saveBoolean("trackTableSelection", ArbilMenuBar.this.trackTableSelectionCheckBoxMenuItem.isSelected());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.trackTableSelectionCheckBoxMenuItem.setEnabled(true);
        this.optionsMenu.add(this.trackTableSelectionCheckBoxMenuItem);
        this.useLanguageIdInColumnNameCheckBoxMenuItem.setSelected(sessionStorage.loadBoolean("useLanguageIdInColumnName", false));
        this.useLanguageIdInColumnNameCheckBoxMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SHOW LANGUAGE IN COLUMN NAME"));
        this.useLanguageIdInColumnNameCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    dialogHandler.offerUserToSaveChanges();
                    sessionStorage.saveBoolean("useLanguageIdInColumnName", ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.isSelected());
                    dataNodeLoader.requestReloadAllNodes();
                }
                catch (Exception ex) {
                    ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.setSelected(sessionStorage.loadBoolean("useLanguageIdInColumnName", false));
                }
            }
        });
        this.optionsMenu.add(this.useLanguageIdInColumnNameCheckBoxMenuItem);
        this.add(this.optionsMenu);
        this.optionsMenu.add(new JSeparator());
        this.viewMenu.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("COLUMN VIEW FOR NEW TABLES"));
        this.viewMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.viewMenuMenuSelected(evt);
            }
        });
        this.optionsMenu.add(this.viewMenu);
        this.editFieldViewsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("EDIT COLUMN VIEWS"));
        this.editFieldViewsMenuItem.setEnabled(false);
    }

    private void initPluginMenu() {
        ArbilPluginManager pluginManager = new ArbilPluginManager(sessionStorage, windowManager, dataNodeLoader, BugCatcherManager.getBugCatcher());
        List<URL> pluginUlrs = pluginManager.getPluginsFromDirectoriesAndPluginsList();
        this.add((JMenu)new PluginMenu(new PluginService(pluginUlrs.toArray(new URL[0])), (PluginManager)pluginManager, true));
    }

    private void initWindowMenu() {
        windowMenu.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("WINDOW"));
        this.resetWindowsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("RESET WINDOW LOCATIONS"));
        this.resetWindowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (dialogHandler.showConfirmDialogBox(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("RESET ALL WINDOWS TO DEFAULT SIZE AND LOCATION?"), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("RESET WINDOWS"))) {
                    windowManager.resetWindows();
                }
            }
        });
        this.closeWindowsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CLOSE ALL WINDOWS"));
        this.closeWindowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (dialogHandler.showConfirmDialogBox(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CLOSE ALL WINDOWS?"), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CLOSE WINDOWS"))) {
                    windowManager.closeAllWindows();
                }
            }
        });
        windowMenu.add(this.closeWindowsMenuItem);
        windowMenu.add(this.resetWindowsMenuItem);
        windowMenu.add(new JSeparator());
        this.add(windowMenu);
    }

    private void initHelpMenu() {
        this.helpMenu.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("HELP"));
        this.helpMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.viewErrorLogMenuItem.setEnabled(ArbilBugCatcher.getLogFile(sessionStorage, versionManager.getApplicationVersion()).exists());
            }
        });
        this.aboutMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ABOUT"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.aboutMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("HELP"));
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.helpMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.setupWizardMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("RUN SETUP WIZARD"));
        this.setupWizardMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                sessionStorage.saveString("wizardHasRun", ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("YES"));
                ArbilSetupWizard wizard = new ArbilSetupWizard(windowManager.getMainFrame());
                wizard.showModalDialog();
            }
        });
        this.helpMenu.add(this.setupWizardMenuItem);
        this.arbilForumMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ARBIL FORUM (WEBSITE)"));
        this.arbilForumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    windowManager.openFileInExternalApplication(new URI(ArbilMenuBar.FORUM_URL));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.helpMenu.add(this.arbilForumMenuItem);
        this.viewErrorLogMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("VIEW ERROR LOG"));
        this.viewErrorLogMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    windowManager.openFileInExternalApplication(ArbilBugCatcher.getLogFile(sessionStorage, versionManager.getApplicationVersion()).toURI());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.helpMenu.add(this.viewErrorLogMenuItem);
        this.checkForUpdatesMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CHECK FOR UPDATES"));
        this.checkForUpdatesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!versionManager.forceUpdateCheck()) {
                        ApplicationVersion appVersion = versionManager.getApplicationVersion();
                        String versionString = appVersion.currentMajor + "." + appVersion.currentMinor + "." + appVersion.currentRevision;
                        dialogHandler.addMessageDialogToQueue(MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("NO UPDATES FOUND, CURRENT VERSION IS {0}"), versionString), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CHECK FOR UPDATES"));
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.helpMenu.add(this.checkForUpdatesMenuItem);
        this.shortCutKeysjMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SHORT CUT KEYS"));
        this.shortCutKeysjMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.shortCutKeysjMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.helpMenu.add(this.shortCutKeysjMenuItem);
        this.add(this.helpMenu);
    }

    private void setUpHotKeys() {
        this.saveFileMenuItem.setMnemonic(83);
        this.saveFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        this.searchReplaceMenuItem.setMnemonic(70);
        this.searchReplaceMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
    }

    private void viewMenuMenuSelected(MenuEvent evt) {
        this.initViewMenu(this.viewMenu);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.performCleanExit();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        windowManager.openAboutPage();
    }

    private void shortCutKeysjMenuItemActionPerformed(ActionEvent evt) {
        ArbilHelp helpComponent = this.getArbilHelp();
        if (helpComponent != null) {
            if (null == windowManager.focusWindow("Help Viewer")) {
                windowManager.createWindow("Help Viewer", helpComponent);
            }
            helpComponent.setCurrentPage("IMDI", "Shortcut Keys");
        }
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        ArbilHelp arbilHelp = this.getArbilHelp();
        if (arbilHelp != null && null == windowManager.focusWindow("Help Viewer")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JInternalFrame helpWindow = windowManager.createWindow("Help Viewer", ArbilMenuBar.this.getArbilHelp());
                    helpWindow.setSize(800, 600);
                }
            });
        }
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        try {
            ImportExportDialog importExportDialog = new ImportExportDialog(ArbilMenuBar.treeHelper.getArbilTreePanel().remoteCorpusTree);
            importExportDialog.importArbilBranch();
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
            System.out.println(e.getMessage());
        }
    }

    private boolean saveApplicationState() {
        if (dataNodeLoader.nodesNeedSave()) {
            switch (JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SAVE CHANGES BEFORE EXITING?"), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ARBIL"), 1, -1)) {
                case 1: {
                    break;
                }
                case 0: {
                    dataNodeLoader.saveNodesNeedingSave(false);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        mimeHashQueue.terminateQueue();
        this.saveState(this.saveWindowsCheckBoxMenuItem.isSelected());
        sessionStorage.saveBoolean("saveWindows", this.saveWindowsCheckBoxMenuItem.isSelected());
        sessionStorage.saveBoolean("checkNewVersionAtStart", this.checkNewVersionAtStartCheckBoxMenuItem.isSelected());
        return true;
    }

    private void saveState(boolean saveWindows) {
        ArbilFieldViews.getSingleInstance().saveViewsToFile();
        if (saveWindows) {
            windowManager.saveWindowStates();
        }
    }

    public boolean performCleanExit() {
        windowManager.stopEditingInCurrentWindow();
        if (this.saveApplicationState()) {
            System.exit(0);
            return true;
        }
        return false;
    }

    private void initViewMenu(JMenu viewMenu) {
        viewMenu.removeAll();
        ButtonGroup viewMenuButtonGroup = new ButtonGroup();
        Enumeration menuItemName = ArbilFieldViews.getSingleInstance().getSavedFieldViewLables();
        while (menuItemName.hasMoreElements()) {
            String currentMenuName = menuItemName.nextElement().toString();
            JRadioButtonMenuItem viewLabelRadioButtonMenuItem = new JRadioButtonMenuItem();
            viewMenuButtonGroup.add(viewLabelRadioButtonMenuItem);
            viewLabelRadioButtonMenuItem.setSelected(ArbilFieldViews.getSingleInstance().getCurrentGlobalViewName().equals(currentMenuName));
            viewLabelRadioButtonMenuItem.setText(currentMenuName);
            viewLabelRadioButtonMenuItem.setName(currentMenuName);
            viewLabelRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        ArbilFieldViews.getSingleInstance().setCurrentGlobalViewName(((Component)evt.getSource()).getName());
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            });
            viewMenu.add(viewLabelRadioButtonMenuItem);
        }
    }

    public boolean isMacOsMenu() {
        return this.macOsMenu;
    }

    public void setMacOsMenu(boolean macOsMenu) {
        this.macOsMenu = macOsMenu;
    }

    static {
        windowMenu = new JMenu();
    }
}

