/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util.task;

import java.util.Collection;
import nl.mpi.arbil.util.task.ArbilTask;
import nl.mpi.arbil.util.task.ArbilTaskEvent;
import nl.mpi.arbil.util.task.ArbilTaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArbilTask
implements ArbilTask {
    private String name;
    private String description;
    private String status = null;
    private boolean indeterminate = true;
    private int targetValue = 100;
    private int progressValue = 0;
    private Collection<ArbilTaskListener> listeners;
    private String progressFormat;

    public DefaultArbilTask(String name, String description, String progressFormat, Collection<ArbilTaskListener> listeners) {
        this.name = name;
        this.description = description;
        this.progressFormat = progressFormat;
        this.listeners = listeners;
    }

    @Override
    public synchronized boolean isIndeterminate() {
        return this.indeterminate;
    }

    public synchronized void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        this.notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType.PROGRESS);
    }

    @Override
    public synchronized int getTargetValue() {
        return this.targetValue;
    }

    public synchronized void setTargetValue(int targetValue) {
        this.targetValue = targetValue;
        this.notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType.PROGRESS);
    }

    @Override
    public synchronized int getProgressValue() {
        return this.progressValue;
    }

    public synchronized void setProgressValue(int progressValue) {
        this.progressValue = progressValue;
        this.notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType.PROGRESS);
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
        this.notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType.CHANGED);
    }

    @Override
    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
        this.notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType.CHANGED);
    }

    @Override
    public String getProgressString() {
        if (this.progressFormat == null) {
            return null;
        }
        return String.format(this.progressFormat, this.progressValue, this.targetValue);
    }

    public synchronized void setProgressFormat(String format) {
        this.progressFormat = format;
        this.notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType.CHANGED);
    }

    @Override
    public synchronized String getStatus() {
        return this.status;
    }

    public synchronized void setStatus(String status) {
        this.status = status;
        this.notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType.CHANGED);
    }

    public void start() {
        this.notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType.STARTED);
    }

    public void finish() {
        this.notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType.COMPLETED);
    }

    protected void notifyAllListeners(ArbilTaskEvent.ArbilTaskEventType eventType) {
        for (ArbilTaskListener listener : this.getListeners()) {
            this.notifyListener(listener, eventType);
        }
    }

    protected void notifyListener(ArbilTaskListener listener, ArbilTaskEvent.ArbilTaskEventType eventType) {
        listener.notifyTask(new ArbilTaskEvent(this, eventType));
    }

    protected Collection<ArbilTaskListener> getListeners() {
        return this.listeners;
    }
}

