/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.Position;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public final class LocationPathPattern
extends Pattern {
    private Pattern upperPattern = null;
    private byte upwardsAxis = (byte)9;
    public NodeTest nodeTest = AnyNodeTest.getInstance();
    protected Expression[] filters = EMPTY_FILTER_ARRAY;
    protected Expression equivalentExpr = null;
    protected boolean firstElementPattern = false;
    protected boolean lastElementPattern = false;
    protected boolean specialFilter = false;
    private Expression variableBinding = null;
    private NodeTest refinedNodeTest = null;
    private static Expression[] EMPTY_FILTER_ARRAY = new Expression[0];

    public void setNodeTest(NodeTest test) {
        if (test == null) {
            throw new NullPointerException("test");
        }
        this.nodeTest = test;
    }

    public void setUpperPattern(byte axis, Pattern upper) {
        this.upwardsAxis = axis;
        this.upperPattern = upper;
    }

    public void addFilter(Expression filter) {
        int len = this.filters.length;
        Expression[] f2 = new Expression[len + 1];
        System.arraycopy(this.filters, 0, f2, 0, len);
        this.filters = f2;
        this.filters[len] = filter;
        filter.setContainer(this);
    }

    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        if (this.upperPattern != null) {
            this.upperPattern.setLineNumber(lineNumber);
        }
    }

    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        if (this.upperPattern != null) {
            this.upperPattern.setSystemId(systemId);
        }
    }

    public void setExecutable(Executable executable) {
        super.setExecutable(executable);
        if (this.upperPattern != null) {
            this.upperPattern.setExecutable(executable);
        }
    }

    public Expression[] getFilters() {
        return this.filters;
    }

    public Pattern getUpperPattern() {
        return this.upperPattern;
    }

    public byte getUpwardsAxis() {
        return this.upwardsAxis;
    }

    public boolean selectsOutwards() {
        if (this.specialFilter) {
            return true;
        }
        if (this.upperPattern instanceof LocationPathPattern && ((LocationPathPattern)this.upperPattern).selectsOutwards()) {
            return true;
        }
        for (int i = 0; i < this.filters.length; ++i) {
            if (!ExpressionTool.selectsOutwards(this.filters[i])) continue;
            return true;
        }
        return false;
    }

    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.upperPattern == null && this.filters.length == 0 && !this.firstElementPattern && !this.lastElementPattern) {
            ItemTypePattern ntp = new ItemTypePattern(this.nodeTest);
            ntp.setSystemId(this.getSystemId());
            ntp.setLineNumber(this.getLineNumber());
            return ntp;
        }
        if (this.upperPattern != null) {
            this.upperPattern = this.upperPattern.simplify(visitor);
        }
        for (int i = this.filters.length - 1; i >= 0; --i) {
            this.filters[i] = visitor.simplify(this.filters[i]);
        }
        return this;
    }

    public Pattern analyze(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.upperPattern != null) {
            this.upperPattern = this.upperPattern.analyze(visitor, contextItemType);
            if (this.upwardsAxis == 9) {
                AxisExpression step = this.nodeTest.getPrimitiveType() == 2 ? new AxisExpression(2, this.nodeTest) : new AxisExpression(3, this.nodeTest);
                step.setLocationId(env.getLocationMap().allocateLocationId(env.getSystemId(), this.getLineNumber()));
                step.setContainer(this);
                Expression exp = visitor.typeCheck(step, new ExpressionVisitor.ContextItemType(this.upperPattern.getItemType(), false));
                this.refinedNodeTest = (NodeTest)exp.getItemType(th);
            }
        }
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        int removeEntries = 0;
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(this.getItemType(), false);
        for (int i = this.filters.length - 1; i >= 0; --i) {
            Expression filter = visitor.typeCheck(this.filters[i], cit);
            filter = ExpressionTool.unsortedIfHomogeneous(opt, filter);
            this.filters[i] = filter = visitor.optimize(filter, cit);
            if (Literal.isConstantBoolean(filter, true)) {
                ++removeEntries;
                continue;
            }
            if (!Literal.isConstantBoolean(filter, false)) continue;
            return new ItemTypePattern(EmptySequenceTest.getInstance());
        }
        if (removeEntries > 0) {
            if (removeEntries == this.filters.length) {
                this.filters = EMPTY_FILTER_ARRAY;
            } else {
                Expression[] f2 = new Expression[this.filters.length - removeEntries];
                int j = 0;
                for (int i = 0; i < this.filters.length; ++i) {
                    if (Literal.isConstantBoolean(this.filters[i], true)) continue;
                    f2[j++] = this.filters[i];
                }
                this.filters = f2;
            }
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.filters.length == 1) {
            ComparisonExpression comp;
            if (Literal.isConstantOne(this.filters[0])) {
                this.firstElementPattern = true;
                this.specialFilter = true;
                this.filters = EMPTY_FILTER_ARRAY;
            } else if (this.filters[0] instanceof ComparisonExpression && ((comp = (ComparisonExpression)((Object)this.filters[0])).getSingletonOperator() == 50 && comp.getOperands()[0] instanceof Position && Literal.isConstantOne(comp.getOperands()[1]) || comp.getOperands()[1] instanceof Position && Literal.isConstantOne(comp.getOperands()[0]))) {
                this.firstElementPattern = true;
                this.specialFilter = true;
                this.filters = EMPTY_FILTER_ARRAY;
            }
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.filters.length == 1 && this.filters[0] instanceof IsLastExpression && ((IsLastExpression)this.filters[0]).getCondition()) {
            this.lastElementPattern = true;
            this.specialFilter = true;
            this.filters = EMPTY_FILTER_ARRAY;
        }
        if (this.isPositional(th)) {
            this.equivalentExpr = this.makeEquivalentExpression();
            this.equivalentExpr = visitor.typeCheck(this.equivalentExpr, contextItemType);
            this.specialFilter = true;
        }
        return this;
    }

    public int getDependencies() {
        int dependencies = 0;
        if (this.upperPattern != null) {
            dependencies |= this.upperPattern.getDependencies();
        }
        for (int i = 0; i < this.filters.length; ++i) {
            dependencies |= this.filters[i].getDependencies();
        }
        return dependencies &= 0x80;
    }

    public Iterator iterateSubExpressions() {
        Iterator[] pair;
        Iterator iter = this.filters.length == 0 ? Collections.EMPTY_LIST.iterator() : Arrays.asList(this.filters).iterator();
        if (this.variableBinding != null) {
            pair = new Iterator[]{new MonoIterator<Expression>(this.variableBinding), iter};
            iter = new MultiIterator(pair);
        }
        if (this.upperPattern != null) {
            pair = new Iterator[]{iter, this.upperPattern.iterateSubExpressions()};
            iter = new MultiIterator(pair);
        }
        return iter;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i] != original) continue;
            this.filters[i] = replacement;
            found = true;
        }
        if (this.upperPattern != null) {
            found |= this.upperPattern.replaceSubExpression(original, replacement);
        }
        if (this.variableBinding == original) {
            this.variableBinding = replacement;
            found = true;
        }
        return found;
    }

    public int allocateSlots(StaticContext env, SlotManager slotManager, int nextFree) {
        if (this.variableBinding != null) {
            nextFree = ExpressionTool.allocateSlots(this.variableBinding, nextFree, slotManager);
        }
        for (int i = 0; i < this.filters.length; ++i) {
            nextFree = ExpressionTool.allocateSlots(this.filters[i], nextFree, slotManager);
        }
        if (this.upperPattern != null) {
            nextFree = this.upperPattern.allocateSlots(env, slotManager, nextFree);
        }
        return nextFree;
    }

    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        if (this.upperPattern != null) {
            this.upperPattern.promote(offer, parent);
        }
        Binding[] savedBindingList = offer.bindingList;
        if (this.variableBinding instanceof Assignation) {
            offer.bindingList = ((Assignation)this.variableBinding).extendBindingList(offer.bindingList);
        }
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i] = this.filters[i].promote(offer, parent);
        }
        offer.bindingList = savedBindingList;
    }

    private Expression makeEquivalentExpression() {
        byte axis = this.nodeTest.getPrimitiveType() == 2 ? (byte)2 : 3;
        Expression step = new AxisExpression(axis, this.nodeTest);
        for (int n = 0; n < this.filters.length; ++n) {
            step = new FilterExpression(step, this.filters[n]);
        }
        ParentNodeExpression start = new ParentNodeExpression();
        start.setContainer(this);
        Expression path = ExpressionTool.makePathExpression(start, step, false);
        path.setContainer(this);
        return path;
    }

    public boolean matches(Item item, XPathContext context) throws XPathException {
        return item instanceof NodeInfo && this.matchesBeneathAnchor((NodeInfo)item, null, context);
    }

    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        if (this.variableBinding != null) {
            XPathContext c2 = context;
            Item ci = context.getContextItem();
            if (!(ci instanceof NodeInfo) || !((NodeInfo)ci).isSameNodeInfo(node)) {
                c2 = context.newContext();
                UnfailingIterator<NodeInfo> si = SingletonIterator.makeIterator(node);
                si.next();
                c2.setCurrentIterator(si);
            }
            this.variableBinding.evaluateItem(c2);
        }
        return this.internalMatches(node, anchor, context);
    }

    protected boolean internalMatches(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        XPathContextMinor c2;
        if (!this.nodeTest.matches(node)) {
            return false;
        }
        if (this.upperPattern != null) {
            block2 : switch (this.upwardsAxis) {
                case 9: {
                    NodeInfo par = node.getParent();
                    if (par == null) {
                        return false;
                    }
                    if (this.upperPattern.internalMatches(par, anchor, context)) break;
                    return false;
                }
                case 0: {
                    NodeInfo anc = node.getParent();
                    while (true) {
                        if (anc == null) {
                            return false;
                        }
                        if (this.upperPattern.internalMatches(anc, anchor, context)) break block2;
                        anc = anc.getParent();
                    }
                }
                case 1: {
                    NodeInfo anc = node;
                    while (true) {
                        if (anc == null) {
                            return false;
                        }
                        if (this.upperPattern.internalMatches(anc, anchor, context)) break block2;
                        anc = anc.getParent();
                    }
                }
                default: {
                    throw new XPathException("Unsupported axis " + Axis.axisName[this.upwardsAxis] + " in pattern");
                }
            }
        }
        if (this.specialFilter) {
            AxisIterator iter;
            if (this.firstElementPattern) {
                iter = node.iterateAxis((byte)11, this.nodeTest);
                return iter.next() == null;
            }
            if (this.lastElementPattern) {
                iter = node.iterateAxis((byte)7, this.nodeTest);
                return iter.next() == null;
            }
            if (this.equivalentExpr != null) {
                c2 = context.newMinorContext();
                UnfailingIterator<NodeInfo> single = SingletonIterator.makeIterator(node);
                single.next();
                c2.setCurrentIterator(single);
                try {
                    NodeInfo n;
                    SequenceIterator<? extends Item> nsv = this.equivalentExpr.iterate(c2);
                    do {
                        if ((n = (NodeInfo)nsv.next()) != null) continue;
                        return false;
                    } while (!n.isSameNodeInfo(node));
                    return true;
                }
                catch (XPathException e) {
                    XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e);
                    err.setXPathContext(c2);
                    err.setErrorCodeQName(e.getErrorCodeQName());
                    err.setLocator(this);
                    c2.getController().recoverableError(err);
                    return false;
                }
            }
        }
        if (this.filters.length != 0) {
            c2 = context.newMinorContext();
            UnfailingIterator<NodeInfo> iter = SingletonIterator.makeIterator(node);
            iter.next();
            c2.setCurrentIterator(iter);
            for (int i = 0; i < this.filters.length; ++i) {
                try {
                    if (this.filters[i].effectiveBooleanValue(c2)) continue;
                    return false;
                }
                catch (XPathException e) {
                    if ("XTDE0640".equals(e.getErrorCodeLocalPart())) {
                        throw e;
                    }
                    XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e);
                    err.setXPathContext(c2);
                    err.setErrorCodeQName(e.getErrorCodeQName());
                    err.setLocator(this);
                    c2.getController().recoverableError(err);
                    return false;
                }
            }
        }
        return true;
    }

    public int getNodeKind() {
        return this.nodeTest.getPrimitiveType();
    }

    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    public ItemType getItemType() {
        if (this.refinedNodeTest != null) {
            return this.refinedNodeTest;
        }
        return this.nodeTest;
    }

    public boolean isPositional(TypeHierarchy th) {
        for (int i = 0; i < this.filters.length; ++i) {
            int type = this.filters[i].getItemType(th).getPrimitiveType();
            if (type == 517 || type == 515 || type == 533 || type == 516 || type == 632) {
                return true;
            }
            if ((this.filters[i].getDependencies() & 0xC) == 0) continue;
            return true;
        }
        return false;
    }

    public void resolveCurrent(LetExpression let, PromotionOffer offer, boolean topLevel) throws XPathException {
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i] = this.filters[i].promote(offer, let);
        }
        if (this.upperPattern instanceof LocationPathPattern) {
            ((LocationPathPattern)this.upperPattern).resolveCurrent(let, offer, false);
        }
        if (topLevel) {
            this.variableBinding = let;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof LocationPathPattern) {
            LocationPathPattern lpp = (LocationPathPattern)other;
            if (!Arrays.equals(this.filters, lpp.filters)) {
                return false;
            }
            if (!this.nodeTest.equals(lpp.nodeTest)) {
                return false;
            }
            if (this.upwardsAxis != lpp.upwardsAxis) {
                return false;
            }
            return !(this.upperPattern == null ? lpp.upperPattern != null : !this.upperPattern.equals(lpp.upperPattern));
        }
        return false;
    }

    public int hashCode() {
        int h = 88267;
        for (int i = 0; i < this.filters.length; ++i) {
            h ^= this.filters[i].hashCode();
        }
        h ^= this.nodeTest.hashCode();
        if (this.upperPattern != null) {
            h ^= this.upperPattern.hashCode();
        }
        return h ^= this.upwardsAxis << 22;
    }
}

