/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public abstract class VennPattern
extends Pattern {
    protected Pattern p1;
    protected Pattern p2;
    private int nodeType = 0;

    public VennPattern(Pattern p1, Pattern p2) {
        this.p1 = p1;
        this.p2 = p2;
        if (p1.getNodeKind() == p2.getNodeKind()) {
            this.nodeType = p1.getNodeKind();
        }
    }

    public void setExecutable(Executable executable) {
        this.p1.setExecutable(executable);
        this.p2.setExecutable(executable);
        super.setExecutable(executable);
    }

    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        this.p1 = this.p1.simplify(visitor);
        this.p2 = this.p2.simplify(visitor);
        return this;
    }

    public Pattern analyze(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.p1 = this.p1.analyze(visitor, contextItemType);
        this.p2 = this.p2.analyze(visitor, contextItemType);
        return this;
    }

    public void resolveCurrent(LetExpression let, PromotionOffer offer, boolean topLevel) throws XPathException {
        this.p1.resolveCurrent(let, offer, topLevel);
        this.p2.resolveCurrent(let, offer, topLevel);
    }

    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        this.p1.promote(offer, parent);
        this.p2.promote(offer, parent);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        return this.p1.replaceSubExpression(original, replacement) || this.p2.replaceSubExpression(original, replacement);
    }

    public void setOriginalText(String pattern) {
        super.setOriginalText(pattern);
        this.p1.setOriginalText(pattern);
        this.p2.setOriginalText(pattern);
    }

    public int allocateSlots(StaticContext env, SlotManager slotManager, int nextFree) {
        nextFree = this.p1.allocateSlots(env, slotManager, nextFree);
        nextFree = this.p2.allocateSlots(env, slotManager, nextFree);
        return nextFree;
    }

    public void gatherComponentPatterns(Set set) {
        if (this.p1 instanceof VennPattern) {
            ((VennPattern)this.p1).gatherComponentPatterns(set);
        } else {
            set.add(this.p1);
        }
        if (this.p2 instanceof VennPattern) {
            ((VennPattern)this.p2).gatherComponentPatterns(set);
        } else {
            set.add(this.p2);
        }
    }

    public int getNodeKind() {
        return this.nodeType;
    }

    public ItemType getItemType() {
        if (this.nodeType == 0) {
            return AnyNodeTest.getInstance();
        }
        if (this.nodeType == -1) {
            return AnyItemType.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(this.nodeType);
    }

    public int getDependencies() {
        return this.p1.getDependencies() | this.p2.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        return new MultiIterator(new Iterator[]{this.p1.iterateSubExpressions(), this.p2.iterateSubExpressions()});
    }

    public Pattern getLHS() {
        return this.p1;
    }

    public Pattern getRHS() {
        return this.p2;
    }

    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.p1.setSystemId(systemId);
        this.p2.setSystemId(systemId);
    }

    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        this.p1.setLineNumber(lineNumber);
        this.p2.setLineNumber(lineNumber);
    }

    public boolean equals(Object other) {
        if (other instanceof VennPattern) {
            HashSet s0 = new HashSet(10);
            this.gatherComponentPatterns(s0);
            HashSet s1 = new HashSet(10);
            ((VennPattern)other).gatherComponentPatterns(s1);
            return ((Object)s0).equals(s1);
        }
        return false;
    }

    public int hashCode() {
        return 0x9BD723A6 ^ this.p1.hashCode() ^ this.p2.hashCode();
    }
}

