/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.dom;

import java.util.Iterator;
import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXNList;
import org.basex.api.dom.BXNNode;
import org.basex.io.IO;
import org.basex.query.iter.AxisIter;
import org.basex.query.util.ANodeList;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public abstract class BXNode
implements Node {
    private static final short[] TYPES = new short[]{9, 1, 3, 2, 8, 7, 4, 11};
    private static final String[] NAMES = new String[]{"#document", null, "#text", null, "#comment", null, "#cdata-section", "#document-fragment"};
    final ANode node;

    BXNode(ANode n) {
        this.node = n.deepCopy();
    }

    @Override
    public String getNodeName() {
        return NAMES[this.kind()];
    }

    @Override
    public final short getNodeType() {
        return TYPES[this.kind()];
    }

    int kind() {
        return this.node.kind();
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public final BXNode cloneNode(boolean deep) {
        return this.node.copy().toJava();
    }

    @Override
    public final short compareDocumentPosition(Node other) {
        int d = this.node.diff(((BXNode)other).node);
        return (short)(d < 0 ? -1 : (d > 0 ? 1 : 0));
    }

    @Override
    public BXNNode getAttributes() {
        return null;
    }

    @Override
    public final String getBaseURI() {
        return IO.get(Token.string(this.node.baseURI())).url();
    }

    @Override
    public BXNList getChildNodes() {
        return new BXNList(BXNode.finish(this.node.children()));
    }

    @Override
    public BXNode getFirstChild() {
        return BXNode.toJava(this.node.children().next().finish());
    }

    @Override
    public final BXNode getLastChild() {
        ANode n = null;
        Iterator<ANode> i$ = this.node.children().iterator();
        while (i$.hasNext()) {
            ANode t;
            n = t = i$.next();
        }
        return BXNode.toJava(n.finish());
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public BXNode getNextSibling() {
        return BXNode.toJava(this.node.followingSibling().next().finish());
    }

    @Override
    public BXNode getPreviousSibling() {
        return BXNode.toJava(this.node.precedingSibling().next().finish());
    }

    @Override
    public final BXNode getParentNode() {
        return BXNode.toJava(this.node.parent());
    }

    private static BXNode toJava(ANode n) {
        return n != null ? n.toJava() : null;
    }

    @Override
    public final boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    @Override
    public final boolean isSameNode(Node other) {
        return this == other;
    }

    @Override
    public BXDoc getOwnerDocument() {
        ANode p;
        ANode n = this.node;
        while ((p = n.parent()) != null) {
            n = p;
        }
        return n.type == NodeType.DOC ? (BXDoc)n.toJava() : null;
    }

    @Override
    public final boolean hasAttributes() {
        return this.getAttributes().getLength() != 0;
    }

    @Override
    public final Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public final String getPrefix() {
        return null;
    }

    @Override
    public final String getTextContent() {
        return Token.string(this.node.string());
    }

    @Override
    public final BXNode appendChild(Node newChild) {
        throw BXNode.readOnly();
    }

    @Override
    public final Object getUserData(String key) {
        return null;
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public final BXNode insertBefore(Node newChild, Node refChild) {
        throw BXNode.readOnly();
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        throw Util.notimplemented(new Object[0]);
    }

    @Override
    public final boolean isEqualNode(Node cmp) {
        throw Util.notimplemented(new Object[0]);
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        throw Util.notimplemented(new Object[0]);
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        throw Util.notimplemented(new Object[0]);
    }

    @Override
    public final void normalize() {
        throw BXNode.readOnly();
    }

    @Override
    public final BXNode removeChild(Node oldChild) {
        throw BXNode.readOnly();
    }

    @Override
    public final BXNode replaceChild(Node newChild, Node oldChild) {
        throw BXNode.readOnly();
    }

    @Override
    public final void setNodeValue(String nodeValue) {
        throw BXNode.readOnly();
    }

    @Override
    public final void setPrefix(String prefix) {
        throw BXNode.readOnly();
    }

    @Override
    public final void setTextContent(String textContent) {
        throw BXNode.readOnly();
    }

    @Override
    public final Object setUserData(String key, Object dat, UserDataHandler handler) {
        throw BXNode.readOnly();
    }

    public final String toString() {
        return '[' + this.getNodeName() + ": " + this.getNodeValue() + ']';
    }

    final BXNList getElements(String tag) {
        ANode n;
        byte[] nm;
        ANodeList nb = new ANodeList();
        AxisIter ai = this.node.descendant();
        byte[] byArray = nm = tag.equals("*") ? null : Token.token(tag);
        while ((n = ai.next()) != null) {
            if (n.type != NodeType.ELM || nm != null && !Token.eq(nm, n.name())) continue;
            nb.add(n.finish());
        }
        return new BXNList(nb);
    }

    static ANodeList finish(AxisIter ai) {
        ANode n;
        ANodeList nl = new ANodeList();
        while ((n = ai.next()) != null) {
            nl.add(n.finish());
        }
        return nl;
    }

    public final ANode getNod() {
        return this.node;
    }

    static final DOMException readOnly() {
        throw new DOMException(7, "DOM implementation is read-only.");
    }
}

