/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.build.Parser;
import org.basex.core.Progress;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Namespaces;
import org.basex.index.name.Names;
import org.basex.index.path.PathSummary;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public abstract class Builder
extends Progress {
    final PathSummary path = new PathSummary();
    final Namespaces ns = new Namespaces();
    final Parser parser;
    final String name;
    int ssize;
    int spos;
    MetaData meta;
    Names tags;
    Names atts;
    private final IntList pstack = new IntList();
    private final IntList tstack = new IntList();
    private int level;

    Builder(String nm, Parser parse) {
        this.parser = parse;
        this.name = nm;
    }

    final void parse() throws IOException {
        this.parser.parse(this);
        this.meta.lastid = this.meta.size - 1;
    }

    public final void startDoc(byte[] value) throws IOException {
        this.path.index(0, (byte)0, this.level);
        this.pstack.set(this.level++, this.meta.size);
        this.addDoc(value);
        this.ns.open();
    }

    public final void endDoc() throws IOException {
        int pre = this.pstack.get(--this.level);
        this.setSize(pre, this.meta.size - pre);
        ++this.meta.ndocs;
        this.ns.close(this.meta.size);
    }

    public final void startNS(byte[] pref, byte[] uri) {
        this.ns.add(pref, uri, this.meta.size);
    }

    public final void startElem(byte[] nm, Atts att) throws IOException {
        this.addElem(nm, att);
        ++this.level;
    }

    public final void emptyElem(byte[] nm, Atts att) throws IOException {
        this.addElem(nm, att);
        int pre = this.pstack.get(this.level);
        this.ns.close(pre);
        if (att.size() > 31) {
            this.setSize(pre, this.meta.size - pre);
        }
    }

    public final void endElem() throws IOException {
        this.checkStop();
        --this.level;
        int pre = this.pstack.get(this.level);
        this.setSize(pre, this.meta.size - pre);
        this.ns.close(pre);
    }

    public final void text(byte[] value) throws IOException {
        if (value.length != 0) {
            this.addText(value, (byte)2);
        }
    }

    public final void comment(byte[] value) throws IOException {
        this.addText(value, (byte)4);
    }

    public final void pi(byte[] pi) throws IOException {
        this.addText(pi, (byte)5);
    }

    public final void encoding(String enc) {
        this.meta.encoding = Token.eq(enc, "UTF-8", "UTF8") ? "UTF-8" : enc;
    }

    @Override
    protected final String tit() {
        return Text.CREATING_DB;
    }

    @Override
    public final String det() {
        return this.spos == 0 ? this.parser.detail() : Text.FINISHING_D;
    }

    @Override
    public final double prog() {
        return this.spos == 0 ? this.parser.progress() : (double)this.spos / (double)this.ssize;
    }

    public abstract Data build() throws IOException;

    public abstract void close() throws IOException;

    protected abstract void addDoc(byte[] var1) throws IOException;

    protected abstract void addElem(int var1, int var2, int var3, int var4, boolean var5) throws IOException;

    protected abstract void addAttr(int var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void addText(byte[] var1, int var2, byte var3) throws IOException;

    protected abstract void setSize(int var1, int var2) throws IOException;

    private void addElem(byte[] nm, Atts att) throws IOException {
        int n = this.tags.index(nm, null, true);
        this.path.index(n, (byte)1, this.level);
        int pre = this.meta.size;
        this.tstack.set(this.level, n);
        this.pstack.set(this.level, pre);
        int dis = this.level != 0 ? pre - this.pstack.get(this.level - 1) : 1;
        int as = att.size();
        boolean ne = this.ns.open();
        int u = this.ns.uri(nm, true);
        this.addElem(dis, n, Math.min(31, as + 1), u, ne);
        for (int a = 0; a < as; ++a) {
            byte[] av = att.string(a);
            byte[] an = att.name(a);
            n = this.atts.index(an, av, true);
            u = this.ns.uri(an, false);
            this.path.index(n, (byte)3, this.level + 1, av, this.meta);
            this.addAttr(n, av, Math.min(31, a + 1), u);
        }
        if (this.level > 1) {
            this.tags.stat(this.tstack.get(this.level - 1)).setLeaf(false);
        }
        this.limit(this.tags.size(), 32768, "%: Too many different tag names (limit: %).");
        this.limit(this.atts.size(), 32768, "%: Too many different attribute names (limit: %).");
        this.limit(this.ns.size(), 256, "%: Too many different namespaces (limit: %).");
        if (this.meta.size < 0) {
            this.limit(0, 0, "%: Input is too large for a single database.");
        }
    }

    private void limit(int value, int limit, String msg) throws IOException {
        if (value >= limit) {
            Builder.error(msg, this.parser.detail(), limit);
        }
    }

    private void addText(byte[] value, byte kind) throws IOException {
        int l = this.level;
        if (l > 1) {
            int tag = this.tstack.get(l - 1);
            if (kind == 2) {
                this.tags.index(tag, value);
            } else {
                this.tags.stat(tag).setLeaf(false);
            }
        }
        this.path.index(0, kind, l, value, this.meta);
        this.addText(value, l == 0 ? 1 : this.meta.size - this.pstack.get(l - 1), kind);
    }

    private static void error(String msg, Object ... ext) throws IOException {
        throw new BuildException(msg, ext);
    }
}

