/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.IOException;
import java.util.Locale;
import org.basex.build.SingleParser;
import org.basex.build.file.ParserProp;
import org.basex.core.BaseXException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;
import org.basex.util.list.TokenList;

public final class CSVParser
extends SingleParser {
    public static final String[] SEPARATORS = new String[]{"comma", "semicolon", "tab", "space"};
    public static final char[] SEPMAPPINGS = new char[]{',', ';', '\t', ' '};
    public static final String[] FORMATS = new String[]{"simple", "verbose"};
    private static final byte[] CSV = Token.token("csv");
    private static final byte[] HEADER = Token.token("header");
    private static final byte[] RECORD = Token.token("record");
    private static final byte[] ENTRY = Token.token("entry");
    private static final byte[] COLUMN = Token.token("col");
    private final TokenList headers = new TokenList();
    private final boolean simple;
    private final String encoding;
    private final int separator;
    private int row;
    private int col;

    public CSVParser(IO source, Prop pr) throws IOException {
        super(source, pr);
        int i;
        ParserProp props = new ParserProp(pr.get(Prop.PARSEROPT));
        this.row = props.is(ParserProp.HEADER) ? 0 : 1;
        String val = props.get(ParserProp.SEPARATOR).toLowerCase(Locale.ENGLISH);
        int s = -1;
        for (i = 0; i < SEPARATORS.length && s == -1; ++i) {
            if (!val.equals(SEPARATORS[i])) continue;
            s = SEPMAPPINGS[i];
        }
        if (s == -1) {
            i = Token.toInt(Token.token(val));
            if (i > 0) {
                s = i;
            } else {
                throw new BaseXException(Text.INVALID_VALUE_X_X, ParserProp.SEPARATOR[0], val);
            }
        }
        this.separator = s;
        val = props.get(ParserProp.FORMAT).toLowerCase(Locale.ENGLISH);
        this.simple = val.equals(FORMATS[0]);
        if (!this.simple && !val.equals(FORMATS[1])) {
            throw new BaseXException(Text.INVALID_VALUE_X_X, ParserProp.FORMAT[0], val);
        }
        this.encoding = props.get(ParserProp.ENCODING);
    }

    @Override
    public void parse() throws IOException {
        this.builder.startElem(CSV, this.atts);
        TokenBuilder tb = new TokenBuilder();
        NewlineInput nli = new NewlineInput(this.src).encoding(this.encoding);
        boolean quoted = false;
        boolean open = true;
        int ch = -1;
        while (true) {
            if (ch == -1) {
                ch = nli.read();
            }
            if (ch == -1) break;
            if (quoted) {
                if (ch == 34 && (ch = nli.read()) != 34) {
                    quoted = false;
                    continue;
                }
                tb.add(ch);
            } else if (ch == this.separator) {
                if (open) {
                    this.open();
                    open = false;
                }
                this.add(tb);
            } else if (ch == 10) {
                this.finish(tb, open);
                open = true;
            } else if (ch == 34) {
                quoted = true;
            } else {
                tb.add(XMLToken.valid(ch) ? ch : 63);
            }
            ch = -1;
        }
        nli.close();
        this.finish(tb, open);
        this.builder.endElem();
    }

    private void open() throws IOException {
        if (this.row == 0) {
            if (this.simple) {
                this.builder.startElem(HEADER, this.atts);
            }
        } else {
            this.builder.startElem(RECORD, this.atts);
        }
    }

    private void finish(TokenBuilder tb, boolean open) throws IOException {
        boolean close;
        boolean bl = close = !open;
        if (open && !tb.isEmpty()) {
            this.open();
            close = true;
        }
        this.add(tb);
        if (close) {
            if (this.simple || this.row != 0) {
                this.builder.endElem();
            }
            ++this.row;
        }
        this.col = 0;
    }

    private void add(TokenBuilder tb) throws IOException {
        byte[] t;
        if (this.row == 0 && !this.simple) {
            this.addHeader(tb.finish());
            tb.reset();
            return;
        }
        if (this.simple) {
            t = ENTRY;
        } else {
            if (this.col == this.headers.size()) {
                this.addHeader(COLUMN);
            }
            t = this.headers.get(this.col);
        }
        if (!tb.isEmpty() || this.simple) {
            this.builder.startElem(t, this.atts);
            this.builder.text(tb.finish());
            this.builder.endElem();
            tb.reset();
        }
        ++this.col;
    }

    private void addHeader(byte[] f) {
        byte[] fb;
        TokenBuilder nm = new TokenBuilder();
        for (int p = 0; p < f.length; p += Token.cl(f, p)) {
            int cp = Token.cp(f, p);
            nm.add((p == 0 ? XMLToken.isNCStartChar(cp) : XMLToken.isNCChar(cp)) ? cp : 95);
        }
        if (nm.isEmpty()) {
            nm.add(COLUMN);
        }
        if (this.headers.contains(fb = nm.finish())) {
            int c = 2;
            while (this.headers.contains(fb = Token.concat(nm.finish(), Token.token(c++)))) {
            }
        }
        this.headers.add(fb);
    }
}

