/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.IOException;
import org.basex.build.file.ParserProp;
import org.basex.build.xml.XMLParser;
import org.basex.core.BaseXException;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryException;
import org.basex.query.util.XMLConverter;
import org.basex.query.util.json.JSONConverter;
import org.basex.query.util.json.JsonMLConverter;
import org.basex.query.value.node.ANode;

public final class JSONParser
extends XMLParser {
    public JSONParser(IO source, Prop pr) throws IOException {
        this(source, pr, pr.get(Prop.PARSEROPT));
    }

    public JSONParser(IO source, Prop pr, String options) throws IOException {
        super(JSONParser.toXML(source, options), pr);
    }

    public static IO toXML(IO io, String options) throws IOException {
        ANode node;
        ParserProp props = new ParserProp(options);
        boolean jsonml = props.is(ParserProp.JSONML);
        String encoding = props.get(ParserProp.ENCODING);
        byte[] content = new NewlineInput(io).encoding(encoding).content();
        try {
            XMLConverter conv = jsonml ? new JsonMLConverter(null) : new JSONConverter(null);
            node = conv.parse(content);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex.getLocalizedMessage(), new Object[0]);
        }
        IOContent xml = new IOContent(node.serialize().toArray());
        xml.name(io.name());
        return xml;
    }
}

