/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.IOException;
import java.util.Arrays;
import org.basex.build.BuildException;
import org.basex.build.SingleParser;
import org.basex.build.file.MAB2;
import org.basex.build.file.ParserProp;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.out.PrintOutput;
import org.basex.io.random.DataAccess;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.ByteList;

public final class MAB2Parser
extends SingleParser {
    private static final String ENCODING = "iso-8859-1";
    private final ByteList buffer = new ByteList();
    private final TokenMap subjects = new TokenMap();
    private final TokenMap mediatypes = new TokenMap();
    private final TokenMap languages = new TokenMap();
    private final TokenMap mvids = new TokenMap();
    private final TokenMap lendings = new TokenMap();
    private final TokenMap status = new TokenMap();
    private final TokenMap posters = new TokenMap();
    private final TokenMap genres = new TokenMap();
    private final byte[][] sig = new byte[500][];
    private final byte[][] auth = new byte[50][];
    private final byte[][] inst = new byte[50][];
    private final boolean flat;
    private final DataAccess input;
    private long off;
    private int maxid;
    private static final byte[] CACHE = new byte[16];

    public MAB2Parser(IO source, Prop pr) throws IOException {
        super(source, pr);
        ParserProp props = new ParserProp(pr.get(Prop.PARSEROPT));
        this.flat = props.is(ParserProp.FLAT);
        this.input = new DataAccess(new IOFile(source.path()));
    }

    @Override
    public void parse() throws IOException {
        long pos;
        byte[] id;
        this.index(this.mediatypes, "mediatypes");
        this.index(this.subjects, "subjects");
        this.index(this.languages, "lang");
        this.index(this.mvids, "mvids");
        this.index(this.lendings, "lendings");
        this.index(this.status, "status");
        this.index(this.posters, "posters");
        this.index(this.genres, "genres");
        for (int i = 1; i <= this.mvids.size(); ++i) {
            int id2 = Token.toInt(this.mvids.value(i));
            if (this.maxid >= id2) continue;
            this.maxid = id2;
        }
        if (this.input.read1() != 35 || this.input.read1() != 35 || this.input.read1() != 35) {
            throw new BuildException("Invalid MAB2 input (doesn't start with ###)");
        }
        this.builder.startElem(MAB2.LIBRARY, this.atts.reset());
        Performance p = new Performance();
        TokenObjMap<MAB2Entry> ids = new TokenObjMap<MAB2Entry>();
        int i = 0;
        while ((id = this.id(this.input)) != null) {
            pos = this.off;
            byte[] par = MAB2Parser.par(this.input);
            boolean child = par != null;
            byte[] key = child ? par : id;
            MAB2Entry entry = (MAB2Entry)ids.get(key);
            if (entry == null) {
                entry = new MAB2Entry();
                ids.add(key, entry);
            }
            if (child) {
                entry.add(pos);
            } else {
                entry.pos(pos);
            }
            if (!Prop.debug) continue;
            if ((++i & Short.MAX_VALUE) == 0) {
                Util.err(" " + i + '\n', new Object[0]);
                continue;
            }
            if ((i & 0xFFF) == 0) {
                Util.err("!", new Object[0]);
                continue;
            }
            if ((i & 0x3FF) != 0) continue;
            Util.err(".", new Object[0]);
        }
        if (Prop.debug) {
            Util.err("\nParse Offsets (%): %/%\n", ids.size(), p, Performance.getMemory());
        }
        for (i = 1; i <= ids.size(); ++i) {
            MAB2Entry entry = (MAB2Entry)ids.value(i);
            pos = entry.pos;
            byte[] l = pos != 0L ? this.addEntry(this.input, pos, entry.size, null) : null;
            for (int j = 0; j < entry.size; ++j) {
                this.addEntry(this.input, entry.children[j], 0, l);
            }
            if (entry.size == 0 || pos == 0L || this.flat) continue;
            this.builder.endElem();
        }
        if (Prop.debug) {
            Util.err("\nCreate Titles: %/%\n", p, Performance.getMemory());
        }
        this.builder.endElem();
        PrintOutput out = new PrintOutput("mvids.dat");
        for (i = 1; i <= this.mvids.size(); ++i) {
            out.print(this.mvids.key(i));
            out.write(9);
            out.println(this.mvids.value(i));
        }
        out.close();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private byte[] id(DataAccess in) {
        while (in.more()) {
            byte n;
            if (in.read1() != 10 || (n = in.read1()) != 48 || in.read1() != 48 || in.read1() != 49) continue;
            this.off = in.cursor() - 3L;
            return MAB2Parser.ident(in);
        }
        return null;
    }

    private static byte[] par(DataAccess in) {
        while (in.more()) {
            if (in.read1() != 10) continue;
            byte b1 = in.read1();
            if (b1 == 35 || b1 == 10) {
                return null;
            }
            if ((b1 != 48 || in.read1() != 49 || in.read1() != 48) && (b1 != 52 || in.read1() != 53 || in.read1() != 51)) continue;
            return MAB2Parser.ident(in);
        }
        return null;
    }

    private static byte[] ident(DataAccess in) {
        byte b;
        in.read1();
        int l = 0;
        while ((b = in.read1()) >= 32) {
            MAB2Parser.CACHE[l++] = b;
        }
        return Arrays.copyOf(CACHE, l);
    }

    private byte[] find(DataAccess in, byte delim) {
        this.buffer.reset();
        while (in.more()) {
            byte c = in.read1();
            if (c == delim) {
                return this.buffer.toArray();
            }
            if (c >= 0 && c < 32) continue;
            this.buffer.add(c);
        }
        return null;
    }

    private byte[] addEntry(DataAccess in, long pos, int sb, byte[] last) throws IOException {
        int s;
        byte[] line;
        int l;
        byte[] mvID = null;
        byte[] bibID = null;
        byte[] title = null;
        byte[] description = null;
        byte[] type = null;
        byte[] language = null;
        byte[] original = null;
        byte[] subtitle = null;
        byte[] town = null;
        byte[] publisher = null;
        byte[] year = null;
        byte[] format = null;
        byte[] details = null;
        byte[] note = null;
        byte[] isbn = null;
        byte[] subject = null;
        int nrSigs = 0;
        int nrAuth = 0;
        int nrInst = 0;
        boolean shortTitle = false;
        in.cursor(pos);
        while ((l = (line = this.find(in, (byte)10)).length) > 3) {
            if (line[0] == 35) continue;
            int n = Token.toInt(line, 0, 3);
            if (n == 1) {
                if (bibID != null || (mvID = this.mvids.get(bibID = MAB2Parser.string(line))) != null) continue;
                mvID = Token.token(++this.maxid);
                this.mvids.add(bibID, mvID);
                continue;
            }
            if (n == 29) {
                type = this.mediatypes.get(MAB2Parser.num(line));
                continue;
            }
            if (n == 37 && language == null) {
                language = this.language(line);
                continue;
            }
            if (n == 81) {
                title = MAB2Parser.string(line);
                shortTitle = true;
                continue;
            }
            if (n >= 100 && n < 200 && (n & 3) == 0) {
                this.auth[nrAuth++] = MAB2Parser.string(line);
                continue;
            }
            if (n >= 200 && n < 300 && (n & 3) == 0) {
                this.inst[nrInst++] = MAB2Parser.string(line);
                continue;
            }
            if (n == 304) {
                original = MAB2Parser.string(line);
                continue;
            }
            if (n == 310) {
                title = MAB2Parser.string(line);
                shortTitle = true;
                continue;
            }
            if (n == 331) {
                if (title == null) {
                    title = MAB2Parser.string(line);
                    continue;
                }
                if (!shortTitle) continue;
                description = MAB2Parser.string(line);
                continue;
            }
            if (n == 335) {
                subtitle = MAB2Parser.string(line);
                continue;
            }
            if (n == 340) {
                if (original != null) continue;
                original = MAB2Parser.string(line);
                continue;
            }
            if (n == 359) {
                description = MAB2Parser.merge(description, MAB2Parser.string(line));
                continue;
            }
            if (n == 410) {
                town = MAB2Parser.string(line);
                continue;
            }
            if (n == 412) {
                publisher = MAB2Parser.string(line);
                continue;
            }
            if (n == 425) {
                year = MAB2Parser.year(line);
                continue;
            }
            if (n == 433) {
                format = MAB2Parser.string(line);
                continue;
            }
            if (n == 501) {
                details = MAB2Parser.string(line);
                year = MAB2Parser.year2(details, year);
                continue;
            }
            if (n == 537) {
                note = MAB2Parser.string(line);
                continue;
            }
            if (n == 540) {
                isbn = MAB2Parser.string(line);
                continue;
            }
            if (n == 542) {
                isbn = MAB2Parser.string(line);
                continue;
            }
            if (n == 544) {
                this.sig[nrSigs++] = MAB2Parser.string(line);
                continue;
            }
            if (n != 700 || nrSigs != 0) continue;
            this.sig[nrSigs++] = MAB2Parser.string(line);
        }
        this.atts.reset();
        this.atts.add(MAB2.MV_ID, mvID);
        this.atts.add(MAB2.BIB_ID, bibID);
        if (sb != 0 && !this.flat) {
            this.atts.add(MAB2.MAX, Token.token(sb));
        }
        if (last != null) {
            if (title == null) {
                title = last;
            } else if (!Token.eq(last, title)) {
                title = Token.concat(last, MAB2.SEMI, title);
            }
        }
        this.builder.startElem(MAB2.MEDIUM, this.atts);
        this.add(MAB2.TYPE, type);
        this.add(MAB2.LANGUAGE, language);
        for (s = 0; s < nrAuth; ++s) {
            this.add(MAB2.AUTHOR, this.auth[s]);
        }
        for (s = 0; s < nrInst; ++s) {
            this.add(MAB2.INSTITUTE, this.inst[s]);
        }
        this.add(MAB2.ORIGINAL, original);
        this.add(MAB2.TITLE, title);
        this.add(MAB2.SUBTITLE, subtitle);
        this.add(MAB2.DESCRIPTION, description);
        this.add(MAB2.TOWN, town);
        this.add(MAB2.PUBLISHER, publisher);
        this.add(MAB2.YEAR, year);
        this.add(MAB2.FORMAT, format);
        this.add(MAB2.DETAILS, details);
        this.add(MAB2.NOTE, note);
        for (s = 0; s < nrSigs; ++s) {
            this.add(MAB2.SIGNATURE, this.sig[s]);
        }
        for (s = 0; s < nrSigs; ++s) {
            if (subject != null) continue;
            subject = this.subjects.get(MAB2Parser.subject(this.sig[s]));
        }
        this.add(MAB2.SUBJECT, subject);
        this.add(MAB2.ISBN, isbn);
        this.add(MAB2.POSTER, this.posters.get(bibID));
        this.add(MAB2.GENRE, this.genres.get(mvID));
        this.add(MAB2.STATUS, this.status.get(bibID));
        this.add(MAB2.LENDINGS, this.lendings.get(bibID));
        if (sb == 0 || this.flat) {
            this.builder.endElem();
        }
        return title;
    }

    private void add(byte[] tag, byte[] cont) throws IOException {
        if (cont == null) {
            return;
        }
        this.builder.startElem(tag, this.atts.reset());
        this.builder.text(Token.utf8(cont, ENCODING));
        this.builder.endElem();
    }

    private static byte[] year(byte[] line) {
        byte[] n = new byte[4];
        int l = line.length;
        int c = 0;
        for (int i = 4; i < l; ++i) {
            byte b = line[i];
            if (b < 48 || b > 57) continue;
            n[c++] = b;
            if (c != 4) continue;
            return n;
        }
        return c != 0 ? Arrays.copyOf(n, c) : null;
    }

    private static byte[] year2(byte[] line, byte[] yr) {
        int oy;
        int l = line.length;
        int i = -1;
        int j = -1;
        while (++i != l) {
            byte b = line[i];
            if (b >= 48 && b <= 57) continue;
            if (i - 5 == j) break;
            j = i;
        }
        if (i - 5 != j) {
            return yr;
        }
        int n = oy = yr != null ? Token.toInt(yr) : 0;
        if (oy >= 1400 && oy <= 1950) {
            return yr;
        }
        byte[] y = Arrays.copyOfRange(line, j + 1, j + 5);
        oy = Token.toInt(y);
        return oy >= 1500 && oy <= 2050 ? y : yr;
    }

    private static byte[] subject(byte[] line) {
        byte[] n = new byte[3];
        int i = -1;
        int l = line.length;
        while (++i != l && line[i] < 97) {
        }
        int c = 0;
        while (i != l && line[i] >= 97) {
            n[c++] = line[i++];
            if (c != 3) continue;
            return n;
        }
        return null;
    }

    private byte[] language(byte[] token) {
        byte[] t = MAB2Parser.string(token);
        for (int i = 0; i < t.length; ++i) {
            if (t[i] != 63 && t[i] != 36) continue;
            t[i] = 43;
        }
        TokenBuilder tb = new TokenBuilder();
        for (byte[] lang : Token.split(t, 43)) {
            byte[] l = this.languages.get(lang);
            if (!tb.isEmpty()) {
                tb.add(43);
            }
            tb.add(l != null ? l : t);
        }
        return tb.finish();
    }

    private static byte[] string(byte[] line) {
        byte[] tmp = new byte[line.length - 4];
        int c = 0;
        int l = line.length;
        boolean space = false;
        for (int s = 4; s < l; ++s) {
            int b = line[s];
            if (b == -121) {
                b = 43;
            } else if (b == -84) {
                b = 32;
            } else if (b == 60) {
                b = 91;
            } else if (b == 62) {
                b = 93;
            }
            if (b == 32 && (space || s == 4)) continue;
            space = b == 32;
            tmp[c++] = b;
        }
        return c == tmp.length ? tmp : Arrays.copyOf(tmp, c);
    }

    private static byte[] num(byte[] line) {
        int l = line.length;
        int s = 3;
        while (++s < l && line[s] == 48) {
        }
        return Arrays.copyOfRange(line, s, line.length);
    }

    private static byte[] merge(byte[] text1, byte[] text2) {
        return text1 == null ? text2 : Token.concat(text1, Token.token(". "), text2);
    }

    private void index(TokenMap hash, String fn) {
        try {
            DataAccess in = new DataAccess(new IOFile(fn + ".dat"));
            while (true) {
                byte[] key = this.find(in, (byte)9);
                byte[] val = this.find(in, (byte)10);
                if (key != null) {
                    hash.add(key, val);
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }

    static final class MAB2Entry {
        long[] children;
        long pos;
        int size;

        MAB2Entry() {
        }

        void add(long c) {
            if (this.children == null) {
                this.children = new long[1];
            } else if (this.size == this.children.length) {
                this.children = Arrays.copyOf(this.children, this.size << 1);
            }
            this.children[this.size++] = c;
        }

        void pos(long p) {
            this.pos = p;
        }
    }
}

