/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.IOException;
import org.basex.build.SingleParser;
import org.basex.build.file.ParserProp;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class TextParser
extends SingleParser {
    private static final byte[] TEXT = Token.token("text");
    private static final byte[] LINE = Token.token("line");
    private final boolean lines;
    private final String encoding;

    public TextParser(IO source, Prop pr) throws IOException {
        super(source, pr);
        ParserProp props = new ParserProp(pr.get(Prop.PARSEROPT));
        this.lines = props.is(ParserProp.LINES);
        this.encoding = props.get(ParserProp.ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse() throws IOException {
        this.builder.startElem(TEXT, this.atts);
        TokenBuilder tb = new TokenBuilder();
        NewlineInput nli = new NewlineInput(this.src).encoding(this.encoding);
        try {
            int ch;
            while ((ch = nli.read()) != -1) {
                if (ch == 10 && this.lines) {
                    this.builder.startElem(LINE, this.atts);
                    this.builder.text(tb.finish());
                    this.builder.endElem();
                    tb.reset();
                    continue;
                }
                tb.add(XMLToken.valid(ch) ? ch : 63);
            }
        }
        finally {
            nli.close();
        }
        if (!this.lines) {
            this.builder.text(tb.finish());
        }
        this.builder.endElem();
    }
}

