/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import java.util.Stack;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.core.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class DOMWrapper
extends Parser {
    private final boolean stripNS;
    private final String filename;
    private final Node root;
    private final boolean chop;
    private int nodes;

    public DOMWrapper(Document doc, String fn, Prop pr) {
        super(fn, pr);
        this.root = doc;
        this.filename = fn;
        this.chop = pr.is(Prop.CHOP);
        this.stripNS = pr.is(Prop.STRIPNS);
    }

    @Override
    public void parse(Builder builder) throws IOException {
        builder.startDoc(Token.token(this.filename));
        Stack<NodeIterator> stack = new Stack<NodeIterator>();
        stack.push(new NodeIterator(this.root));
        while (!stack.empty()) {
            NodeIterator ni = (NodeIterator)stack.peek();
            if (ni.more()) {
                Node n = ni.curr();
                if (n instanceof Element) {
                    stack.push(new NodeIterator(n));
                    this.atts.reset();
                    NamedNodeMap at = n.getAttributes();
                    int as = at.getLength();
                    for (int a = 0; a < as; ++a) {
                        Attr att = (Attr)at.item(a);
                        byte[] an = Token.token(att.getName());
                        byte[] av = Token.token(att.getValue());
                        if (Token.eq(an, Token.XMLNS)) {
                            if (this.stripNS) continue;
                            builder.startNS(Token.EMPTY, av);
                            continue;
                        }
                        if (Token.startsWith(an, Token.XMLNSC)) {
                            if (this.stripNS) continue;
                            builder.startNS(Token.local(an), av);
                            continue;
                        }
                        this.atts.add(this.stripNS ? Token.local(an) : an, av);
                    }
                    byte[] en = Token.token(n.getNodeName());
                    builder.startElem(this.stripNS ? Token.local(en) : en, this.atts);
                } else if (n instanceof Text) {
                    String s = n.getNodeValue();
                    builder.text(Token.token(this.chop ? s.trim() : s));
                } else if (n instanceof Comment) {
                    builder.comment(Token.token(n.getNodeValue()));
                } else if (n instanceof ProcessingInstruction) {
                    builder.pi(Token.token(n.getNodeName() + ' ' + n.getNodeValue()));
                }
                ++this.nodes;
                continue;
            }
            stack.pop();
            if (stack.empty()) break;
            builder.endElem();
        }
        builder.endDoc();
    }

    @Override
    public String det() {
        return Util.info(org.basex.core.Text.NODES_PARSED_X, this.filename, this.nodes);
    }

    @Override
    public double prog() {
        return (double)this.nodes / 1000000.0 % 1.0;
    }

    private static final class NodeIterator {
        private final NodeList nl;
        private int i = -1;

        NodeIterator(Node n) {
            this.nl = n.getChildNodes();
        }

        boolean more() {
            return ++this.i < this.nl.getLength();
        }

        Node curr() {
            return this.nl.item(this.i);
        }
    }
}

