/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler
implements LexicalHandler {
    protected final Builder builder;
    private final boolean stripNS;
    private final Atts atts = new Atts();
    private boolean dtd;
    private final boolean chop;
    int nodes;
    private final StringBuilder sb = new StringBuilder();
    private final Atts ns = new Atts();

    public SAXHandler(Builder build, boolean ch, boolean sn) {
        this.builder = build;
        this.chop = ch;
        this.stripNS = sn;
    }

    @Override
    public void startElement(String uri, String ln, String qn, Attributes at) throws SAXException {
        try {
            this.finishText();
            int as = at.getLength();
            this.atts.reset();
            for (int a = 0; a < as; ++a) {
                byte[] an = Token.token(at.getQName(a));
                byte[] av = Token.token(at.getValue(a));
                this.atts.add(this.stripNS ? Token.local(an) : an, av);
            }
            byte[] en = Token.token(qn);
            this.builder.startElem(this.stripNS ? Token.local(en) : en, this.atts);
            ++this.nodes;
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    @Override
    public void endElement(String uri, String ln, String qn) throws SAXException {
        try {
            this.finishText();
            this.builder.endElem();
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    @Override
    public void characters(char[] ch, int s, int l) {
        this.sb.append(ch, s, l);
    }

    @Override
    public void processingInstruction(String nm, String cont) throws SAXException {
        if (this.dtd) {
            return;
        }
        try {
            this.finishText();
            this.builder.pi(Token.token(nm + ' ' + cont));
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    @Override
    public void comment(char[] ch, int s, int l) throws SAXException {
        if (this.dtd) {
            return;
        }
        try {
            this.finishText();
            this.builder.comment(Token.token(new String(ch, s, l)));
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    private void finishText() throws IOException {
        if (this.sb.length() != 0) {
            String s = this.sb.toString();
            this.builder.text(Token.token(this.chop ? s.trim() : s));
            this.sb.setLength(0);
        }
        if (!this.stripNS) {
            for (int i = 0; i < this.ns.size(); ++i) {
                this.builder.startNS(this.ns.name(i), this.ns.string(i));
            }
        }
        this.ns.reset();
    }

    protected static void error(IOException ex) throws SAXException {
        SAXException ioe = new SAXException(Util.message(ex));
        ioe.setStackTrace(ex.getStackTrace());
        throw ioe;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.ns.add(Token.token(prefix), Token.token(uri));
    }

    @Override
    public void startDTD(String n, String pid, String sid) {
        this.dtd = true;
    }

    @Override
    public void endDTD() {
        this.dtd = false;
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endEntity(String n) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startEntity(String n) {
    }

    static {
        System.setProperty("entityExpansionLimit", "536870912");
        System.setProperty("http.agent", "sax");
    }
}

