/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.basex.core.BaseXException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public abstract class AProp
implements Iterable<String> {
    protected final TreeMap<String, Object> props = new TreeMap();
    private IOFile file;

    protected AProp() {
        try {
            for (Field f : this.getClass().getFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Object[])) continue;
                Object[] arr = (Object[])obj;
                this.props.put(arr[0].toString(), arr[1]);
            }
        }
        catch (Exception ex) {
            Util.notexpected(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(String prop) {
        this.file = new IOFile(Prop.HOME + ".basex" + prop);
        StringList read = new StringList();
        TokenBuilder err = new TokenBuilder();
        if (!this.file.exists()) {
            err.addExt("Saving properties in \"%\"..." + Prop.NL, this.file);
        } else {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(this.file.file()));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                    int d = line.indexOf(61);
                    if (d < 0) {
                        err.addExt("%: \"%\" ignored. " + Prop.NL, this.file, line);
                        continue;
                    }
                    String val = line.substring(d + 1).trim();
                    String key = line.substring(0, d).trim();
                    int num = 0;
                    int ss = key.length();
                    for (int s = 0; s < ss; ++s) {
                        if (!Character.isDigit(key.charAt(s))) continue;
                        num = Integer.parseInt(key.substring(s));
                        key = key.substring(0, s);
                        break;
                    }
                    read.add(key);
                    Object entry = this.props.get(key);
                    if (entry == null) {
                        err.addExt("%: \"%\" not found. " + Prop.NL, this.file, key);
                        continue;
                    }
                    if (entry instanceof String) {
                        this.props.put(key, val);
                        continue;
                    }
                    if (entry instanceof Integer) {
                        this.props.put(key, Integer.parseInt(val));
                        continue;
                    }
                    if (entry instanceof Boolean) {
                        this.props.put(key, Boolean.parseBoolean(val));
                        continue;
                    }
                    if (entry instanceof String[]) {
                        if (num == 0) {
                            this.props.put(key, new String[Integer.parseInt(val)]);
                            continue;
                        }
                        ((String[])entry)[num - 1] = val;
                        continue;
                    }
                    if (!(entry instanceof int[])) continue;
                    ((int[])entry)[num] = Integer.parseInt(val);
                }
            }
            catch (Exception ex) {
                err.addExt("% could not be parsed." + Prop.NL, this.file);
                Util.debug(ex);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        try {
            if (err.isEmpty()) {
                boolean ok = true;
                for (Field f : this.getClass().getFields()) {
                    Object obj = f.get(null);
                    if (!(obj instanceof Object[])) continue;
                    String key = ((Object[])obj)[0].toString();
                    ok &= read.contains(key);
                }
                if (!ok) {
                    err.addExt("Saving properties in \"%\"..." + Prop.NL, this.file);
                }
            }
        }
        catch (IllegalAccessException ex) {
            Util.notexpected(ex);
        }
        if (!err.isEmpty()) {
            Util.err(err.toString(), new Object[0]);
            this.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void write() {
        StringBuilder user = new StringBuilder();
        BufferedReader br = null;
        try {
            if (this.file.exists()) {
                String line;
                br = new BufferedReader(new FileReader(this.file.file()));
                while ((line = br.readLine()) != null && !line.equals("# User defined section")) {
                }
                while ((line = br.readLine()) != null) {
                    user.append(line).append(Prop.NL);
                }
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(this.file.file()));
            bw.write(Prop.PROPHEADER + Prop.NL);
            for (Field f : this.getClass().getFields()) {
                int i;
                Object obj = f.get(null);
                if (!(obj instanceof Object[])) continue;
                String key = ((Object[])obj)[0].toString();
                Object val = this.props.get(key);
                if (val instanceof String[]) {
                    String[] str = (String[])val;
                    bw.write(key + " = " + str.length + Prop.NL);
                    int is = str.length;
                    for (i = 0; i < is; ++i) {
                        if (str[i] == null) continue;
                        bw.write(key + (i + 1) + " = " + str[i] + Prop.NL);
                    }
                    continue;
                }
                if (val instanceof int[]) {
                    int[] num = (int[])val;
                    int ns = num.length;
                    for (i = 0; i < ns; ++i) {
                        bw.write(key + i + " = " + num[i] + Prop.NL);
                    }
                    continue;
                }
                bw.write(key + " = " + val + Prop.NL);
            }
            bw.write(Prop.NL + "# User defined section" + Prop.NL);
            bw.write(user.toString());
        }
        catch (Exception ex) {
            Util.errln("% could not be written.", this.file);
            Util.debug(ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public final Object get(String key) {
        return this.props.get(key);
    }

    public final String get(Object[] key) {
        return this.get(key, String.class).toString();
    }

    public final int num(Object[] key) {
        return (Integer)this.get(key, Integer.class);
    }

    public final boolean is(Object[] key) {
        return (Boolean)this.get(key, Boolean.class);
    }

    public final String[] strings(Object[] key) {
        return (String[])this.get(key, String[].class);
    }

    public final int[] nums(Object[] key) {
        return (int[])this.get(key, int[].class);
    }

    public final void set(Object[] key, String val) {
        this.setObject(key[0].toString(), val);
    }

    public final void set(Object[] key, int val) {
        this.setObject(key[0].toString(), val);
    }

    public final void set(Object[] key, boolean val) {
        this.setObject(key[0].toString(), val);
    }

    public final void set(Object[] key, String[] val) {
        this.setObject(key[0].toString(), val);
    }

    public final void set(Object[] key, int[] val) {
        this.setObject(key[0].toString(), val);
    }

    public final void setObject(String key, Object val) {
        this.props.put(key, val);
        this.finish();
    }

    public final String set(String key, String val) {
        Object type = this.get(key);
        if (type == null) {
            return null;
        }
        String v = val;
        if (type instanceof Boolean) {
            boolean b = val == null || val.isEmpty() ? !((Boolean)type).booleanValue() : Util.yes(val);
            this.setObject(key, b);
            v = Util.flag(b);
        } else if (type instanceof Integer) {
            this.setObject(key, Integer.parseInt(val));
            v = String.valueOf(this.get(key));
        } else if (type instanceof String) {
            this.setObject(key, val);
        } else {
            Util.notexpected("Unknown property type: " + type.getClass().getSimpleName());
        }
        return v;
    }

    protected final void parse(String s) throws IOException {
        for (String ser : s.trim().split(",")) {
            if (ser.isEmpty()) continue;
            String[] sprop = ser.split("=", 2);
            String key = sprop[0].trim();
            String val = sprop.length < 2 ? "" : sprop[1];
            try {
                if (this.set(key, val) != null) {
                    continue;
                }
            }
            catch (Exception ex) {
                throw new BaseXException(Text.INVALID_VALUE_X_X, key, val);
            }
            throw new BaseXException(this.unknown(key), new Object[0]);
        }
    }

    public final String unknown(String key) {
        String sim = this.similar(key);
        return Util.info(sim != null ? Text.UNKNOWN_OPT_SIMILAR_X_X : Text.UNKNOWN_OPTION_X, key, sim);
    }

    public final boolean invert(Object[] key) {
        boolean val = !this.is(key);
        this.set(key, val);
        return val;
    }

    public final boolean sameAs(Object[] key, Object val) {
        return this.props.get(key[0].toString()).equals(val);
    }

    public final String similar(String key) {
        byte[] name = Token.token(key);
        Levenshtein ls = new Levenshtein();
        for (String prop : this.props.keySet()) {
            if (!ls.similar(name, Token.token(prop), 0)) continue;
            return prop;
        }
        return null;
    }

    private Object get(Object[] key, Class<?> c) {
        Class<?> cc;
        Object entry = this.props.get(key[0].toString());
        if (entry == null) {
            Util.notexpected("Property " + key[0] + " not defined.");
        }
        if (c != (cc = entry.getClass())) {
            Util.notexpected("Property '" + key[0] + "' is a " + Util.name(cc));
        }
        return entry;
    }

    void finish() {
    }

    @Override
    public final Iterator<String> iterator() {
        return this.props.keySet().iterator();
    }

    public final String toString() {
        TokenBuilder tb = new TokenBuilder();
        for (Map.Entry<String, Object> e : this.props.entrySet()) {
            if (!tb.isEmpty()) {
                tb.add(44);
            }
            tb.add(e.getKey()).add(61).addExt(e.getValue(), new Object[0]);
        }
        return tb.toString();
    }
}

