/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.basex.core.ILocking;
import org.basex.core.MainProp;
import org.basex.core.Progress;
import org.basex.util.list.StringList;

public final class DBLocking
implements ILocking {
    private final Map<String, ReentrantReadWriteLock> locks = new HashMap<String, ReentrantReadWriteLock>();
    private final AtomicInteger transactions = new AtomicInteger(0);
    private final ConcurrentLinkedQueue<Thread> queue = new ConcurrentLinkedQueue();
    private final ConcurrentMap<Thread, Object[]> locked = new ConcurrentHashMap<Thread, Object[]>();
    private final MainProp mprop;

    public DBLocking(MainProp mp) {
        this.mprop = mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire(Progress pr, StringList db) {
        Thread thread = Thread.currentThread();
        if (this.locked.containsKey(thread)) {
            throw new IllegalMonitorStateException("Thread already holds one or more locks.");
        }
        ConcurrentLinkedQueue<Thread> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            AtomicInteger e2;
            boolean result;
            this.queue.add(thread);
            AtomicInteger atomicInteger = this.transactions;
            synchronized (atomicInteger) {
                result = this.transactions.get() >= Math.max(this.mprop.num(MainProp.PARALLEL), 1) || this.queue.peek() != thread;
            }
            while (result) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                e2 = this.transactions;
                synchronized (e2) {
                    result = this.transactions.get() >= Math.max(this.mprop.num(MainProp.PARALLEL), 1) || this.queue.peek() != thread;
                }
            }
            e2 = this.transactions;
            synchronized (e2) {
                int t = this.transactions.incrementAndGet();
                assert (t <= Math.max(this.mprop.num(MainProp.PARALLEL), 1));
                this.queue.remove(thread);
            }
        }
        String[] objects = db.sort(true, true).unique().toArray();
        this.locked.put(thread, objects);
        for (String object : objects) {
            ReentrantReadWriteLock lock = this.locks.get(object);
            if (null == lock) {
                lock = new ReentrantReadWriteLock();
                this.locks.put(object, lock);
            }
            ((Lock)(pr.updating ? lock.writeLock() : lock.readLock())).lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Progress pr) {
        Object[] objects = (Object[])this.locked.remove(Thread.currentThread());
        if (null == objects) {
            throw new IllegalMonitorStateException("No locks held by current thread");
        }
        for (Object object : objects) {
            ReentrantReadWriteLock lock = this.locks.get(object);
            if (lock.isWriteLockedByCurrentThread()) {
                lock.writeLock().unlock();
                continue;
            }
            lock.readLock().unlock();
        }
        this.transactions.decrementAndGet();
        ConcurrentLinkedQueue<Thread> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            this.queue.notifyAll();
        }
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        String ind = "| ";
        StringBuilder sb = new StringBuilder(nl);
        sb.append("Locking" + nl);
        sb.append("| Transactions running: " + this.transactions.get() + nl);
        sb.append("| Transaction queue: " + this.queue + nl);
        sb.append("| Held locks by object:" + nl);
        for (String object : this.locks.keySet()) {
            sb.append("| | " + object + " -> " + this.locks.get(object) + nl);
        }
        sb.append("| Held locks by transaction:" + nl);
        for (Thread thread : this.locked.keySet()) {
            sb.append("| | " + thread + " -> " + this.locked.get(thread) + nl);
        }
        return sb.toString();
    }
}

