/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.ArrayList;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.util.TokenBuilder;

public final class Datas {
    private final ArrayList<Data> list = new ArrayList();

    synchronized Data pin(String db) {
        for (Data d : this.list) {
            if (!d.meta.name.equals(db)) continue;
            ++d.pins;
            return d;
        }
        return null;
    }

    synchronized boolean unpin(Data data) {
        for (Data d : this.list) {
            boolean close;
            if (d != data) continue;
            boolean bl = close = --d.pins == 0;
            if (close) {
                this.list.remove(d);
            }
            return close;
        }
        return false;
    }

    synchronized boolean pinned(String db) {
        for (Data d : this.list) {
            if (!d.meta.name.equals(db)) continue;
            return true;
        }
        return false;
    }

    synchronized void add(Data d) {
        this.list.add(d);
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized String info() {
        TokenBuilder tb = new TokenBuilder();
        tb.addExt(Text.OPENED_DB_X, this.list.size());
        tb.add(!this.list.isEmpty() ? ":" : ".");
        for (Data d : this.list) {
            tb.add(Text.NL + "- " + d.meta.name + " (" + d.pins + "x)");
        }
        return tb.toString();
    }

    synchronized void close() {
        for (Data d : this.list) {
            d.close();
        }
        this.list.clear();
    }

    public synchronized int pins(String db) {
        for (Data d : this.list) {
            if (!d.meta.name.equals(db)) continue;
            return d.pins;
        }
        return 0;
    }
}

