/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.basex.core.AProp;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Prop
extends AProp {
    public static final String NAME = "BaseX";
    public static final String VERSION = "7.3.1 beta";
    public static final String NL = System.getProperty("line.separator");
    public static final String ENCODING = System.getProperty("file.encoding");
    public static final String TMP = System.getProperty("java.io.tmpdir") + '/';
    private static final String OS = System.getProperty("os.name");
    public static final boolean MAC = OS.startsWith("Mac");
    public static final boolean WIN = OS.startsWith("Windows");
    public static final String DBPREFIX = "org.basex.";
    public static final String PATH = "org.basex.path";
    public static final String USERHOME = System.getProperty("user.home") + File.separator;
    public static final String HOME = Prop.homePath();
    static final String PROPHEADER = "# Property File." + NL + "# You can set additional options at the end of the file." + NL;
    static final String PROPUSER = "# User defined section";
    public static String language = "English";
    public static boolean langkeys;
    public static boolean debug;
    public static boolean gui;
    public static final Object[] CHOP;
    public static final Object[] INTPARSE;
    public static final Object[] DTD;
    public static final Object[] CATFILE;
    public static final Object[] CREATEFILTER;
    public static final Object[] ADDARCHIVES;
    public static final Object[] ADDRAW;
    public static final Object[] SKIPCORRUPT;
    public static final Object[] STRIPNS;
    public static final Object[] PARSER;
    public static final Object[] PARSEROPT;
    public static final Object[] HTMLOPT;
    public static final Object[] TEXTINDEX;
    public static final Object[] ATTRINDEX;
    public static final Object[] FTINDEX;
    public static final Object[] MAXLEN;
    public static final Object[] MAXCATS;
    public static final Object[] UPDINDEX;
    public static final Object[] WRITEBACK;
    public static final Object[] MAINMEM;
    public static final Object[] FORCECREATE;
    public static final Object[] AUTOFLUSH;
    public static final Object[] MAXSTAT;
    public static final Object[] TAILCALLS;
    public static final Object[] STEMMING;
    public static final Object[] CASESENS;
    public static final Object[] DIACRITICS;
    public static final Object[] LANGUAGE;
    public static final Object[] STOPWORDS;
    public static final Object[] LSERROR;
    public static final Object[] QUERYINFO;
    public static final Object[] XQUERY3;
    public static final Object[] SERIALIZE;
    public static final Object[] BINDINGS;
    public static final Object[] SERIALIZER;
    public static final Object[] EXPORTER;
    public static final Object[] QUERYPATH;
    public static final Object[] CACHEQUERY;
    public static final Object[] RUNS;
    public static final Object[] XMLPLAN;
    public static final Object[] COMPPLAN;
    public static final Object[] DOTPLAN;
    public static final Object[] DOTCOMPACT;
    public static final Object[] DOTDISPLAY;
    public static final Object[] DOTTY;
    public static final Object[] MAXHITS;

    private static String homePath() {
        File app;
        String dir;
        String path = System.getProperty(PATH);
        if (path != null) {
            return path + File.separator;
        }
        path = System.getProperty("user.dir");
        File config = new File(path, ".basex");
        if (config.exists()) {
            return config.getParent() + File.separator;
        }
        path = Prop.applicationPath();
        if (path != null && (config = new File(dir = (app = new File(path)).isFile() ? app.getParent() : app.getPath(), ".basex")).exists()) {
            return config.getParent() + File.separator;
        }
        return USERHOME;
    }

    private static String applicationPath() {
        ProtectionDomain pd = Prop.class.getProtectionDomain();
        if (pd == null) {
            return null;
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return null;
        }
        URL url = cs.getLocation();
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        TokenBuilder tb = new TokenBuilder();
        int pl = path.length();
        for (int p = 0; p < pl; ++p) {
            char ch = path.charAt(p);
            if (ch == '%' && p + 2 < pl) {
                tb.addByte((byte)Integer.parseInt(path.substring(p + 1, p + 3), 16));
                p += 2;
                continue;
            }
            tb.add(ch);
        }
        try {
            return new String(tb.finish(), ENCODING);
        }
        catch (Exception ex) {
            Util.stack(ex);
            return tb.toString();
        }
    }

    static {
        CHOP = new Object[]{"CHOP", true};
        INTPARSE = new Object[]{"INTPARSE", true};
        DTD = new Object[]{"DTD", false};
        CATFILE = new Object[]{"CATFILE", ""};
        CREATEFILTER = new Object[]{"CREATEFILTER", "*.xml"};
        ADDARCHIVES = new Object[]{"ADDARCHIVES", true};
        ADDRAW = new Object[]{"ADDRAW", false};
        SKIPCORRUPT = new Object[]{"SKIPCORRUPT", false};
        STRIPNS = new Object[]{"STRIPNS", false};
        PARSER = new Object[]{"PARSER", "xml"};
        PARSEROPT = new Object[]{"PARSEROPT", "encoding=UTF-8,flat=false,format=verbose,header=false,jsonml=false,lines=true,separator=comma"};
        HTMLOPT = new Object[]{"HTMLOPT", "html=false,omit-xml-declaration=false,method=xml,nons=false,nobogons=false,nodefaults=false,nocolons=false,norestart=false,ignorable=false,emptybogons=false,any=false,norootbogons=false,nocdata=false,lexical=false,encoding=utf-8"};
        TEXTINDEX = new Object[]{"TEXTINDEX", true};
        ATTRINDEX = new Object[]{"ATTRINDEX", true};
        FTINDEX = new Object[]{"FTINDEX", false};
        MAXLEN = new Object[]{"MAXLEN", 96};
        MAXCATS = new Object[]{"MAXCATS", 100};
        UPDINDEX = new Object[]{"UPDINDEX", false};
        WRITEBACK = new Object[]{"WRITEBACK", false};
        MAINMEM = new Object[]{"MAINMEM", false};
        FORCECREATE = new Object[]{"FORCECREATE", false};
        AUTOFLUSH = new Object[]{"AUTOFLUSH", true};
        MAXSTAT = new Object[]{"MAXSTAT", 30};
        TAILCALLS = new Object[]{"TAILCALLS", 42};
        STEMMING = new Object[]{"STEMMING", false};
        CASESENS = new Object[]{"CASESENS", false};
        DIACRITICS = new Object[]{"DIACRITICS", false};
        LANGUAGE = new Object[]{"LANGUAGE", "en"};
        STOPWORDS = new Object[]{"STOPWORDS", ""};
        LSERROR = new Object[]{"LSERROR", 0};
        QUERYINFO = new Object[]{"QUERYINFO", false};
        XQUERY3 = new Object[]{"XQUERY3", true};
        SERIALIZE = new Object[]{"SERIALIZE", true};
        BINDINGS = new Object[]{"BINDINGS", ""};
        SERIALIZER = new Object[]{"SERIALIZER", ""};
        EXPORTER = new Object[]{"EXPORTER", ""};
        QUERYPATH = new Object[]{"QUERYPATH", ""};
        CACHEQUERY = new Object[]{"CACHEQUERY", false};
        RUNS = new Object[]{"RUNS", 1};
        XMLPLAN = new Object[]{"XMLPLAN", false};
        COMPPLAN = new Object[]{"COMPPLAN", true};
        DOTPLAN = new Object[]{"DOTPLAN", false};
        DOTCOMPACT = new Object[]{"DOTCOMPACT", false};
        DOTDISPLAY = new Object[]{"DOTDISPLAY", true};
        DOTTY = new Object[]{"DOTTY", "dotty"};
        MAXHITS = new Object[]{"MAXHITS", -1};
    }
}

