/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Perm;
import org.basex.core.ProgressException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.parse.CmdBuilder;
import org.basex.data.Result;
import org.basex.io.IOFile;
import org.basex.io.out.BufferOutput;
import org.basex.io.out.NullOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.DOTSerializer;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.util.Performance;
import org.basex.util.Util;
import org.basex.util.list.StringList;

abstract class AQuery
extends Command {
    Result result;
    private QueryProcessor qp;
    private QueryException qe;
    private long init;
    private long pars;
    private long comp;
    private long eval;
    private long prnt;

    AQuery(Perm p, boolean d, String ... arg) {
        super(p, d, arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean query(String query) {
        String err;
        Performance p = new Performance();
        String inf = "";
        if (this.qe != null) {
            err = this.qe.getMessage();
        } else {
            try {
                boolean serial = this.prop.is(Prop.SERIALIZE);
                long hits = 0L;
                int updates = 0;
                int runs = Math.max(1, this.prop.num(Prop.RUNS));
                for (int r = 0; r < runs; ++r) {
                    Serializer ser;
                    PrintOutput po;
                    if (r != 0) {
                        this.qp = null;
                    }
                    this.qp = this.queryProcessor(query, this.context);
                    this.qp.parse();
                    this.pars += this.init + p.time();
                    this.init = 0L;
                    if (r == 0) {
                        this.plan(false);
                    }
                    this.qp.compile();
                    this.comp += p.time();
                    if (r == 0) {
                        this.plan(true);
                    }
                    PrintOutput printOutput = po = r == 0 && serial ? this.out : new NullOutput();
                    if (this.prop.is(Prop.CACHEQUERY)) {
                        this.result = this.qp.execute();
                        this.eval += p.time();
                        ser = this.qp.getSerializer(po);
                        this.result.serialize(ser);
                        hits = this.result.size();
                    } else {
                        Iter ir = this.qp.iter();
                        this.eval += p.time();
                        hits = 0L;
                        Item it = ir.next();
                        ser = this.qp.getSerializer(po);
                        while (it != null) {
                            this.checkStop();
                            ser.serialize(it);
                            it = ir.next();
                            ++hits;
                        }
                    }
                    updates = this.qp.updates();
                    ser.close();
                    this.qp.close();
                    this.prnt += p.time();
                }
                if (this.prop.is(Prop.QUERYINFO)) {
                    this.evalInfo(query, hits, updates, runs);
                }
                this.out.flush();
                long time = this.pars + this.comp + this.eval + this.prnt;
                boolean bl = this.info(Text.NL + Text.QUERY_EXECUTED_X, Performance.getTime(time, runs));
                return bl;
            }
            catch (QueryException ex) {
                Util.debug(ex);
                err = ex.getMessage();
            }
            catch (IOException ex) {
                Util.debug(ex);
                err = Util.message(ex);
            }
            catch (ProgressException ex) {
                err = Text.INTERRUPTED;
                inf = this.info();
            }
            catch (RuntimeException ex) {
                Util.debug(this.qp.info(), new Object[0]);
                throw ex;
            }
            catch (StackOverflowError ex) {
                Util.debug(ex);
                err = Err.XPSTACK.desc;
            }
            finally {
                if (this.qp != null) {
                    this.qp.close();
                }
            }
        }
        this.error(err, new Object[0]);
        if (Prop.debug || err.startsWith(Text.INTERRUPTED)) {
            this.info(Text.NL, new Object[0]);
            this.info(Text.QUERY_CC + query, new Object[0]);
            this.info(this.qp.info(), new Object[0]);
            this.info(inf, new Object[0]);
        }
        return false;
    }

    final boolean updating(Context ctx, String qu) {
        try {
            Performance p = new Performance();
            this.qp = this.progress(new QueryProcessor(qu, ctx));
            this.qp.parse();
            this.init = p.time();
            return this.qp.updating;
        }
        catch (QueryException ex) {
            Util.debug(ex);
            this.qe = ex;
            if (this.qp != null) {
                this.qp.close();
            }
            return false;
        }
    }

    @Override
    public boolean updating(Context ctx) {
        return this.args[0] != null && this.updating(ctx, this.args[0]);
    }

    @Override
    protected boolean databases(StringList db) {
        return this.qp != null && this.qp.databases(db);
    }

    @Override
    public boolean updated() {
        return this.qp == null || this.qp.updates() != 0;
    }

    final void queryNodes() {
        try {
            this.result = this.queryProcessor(this.args[0], this.context).queryNodes();
        }
        catch (QueryException ex) {
            Util.debug(ex);
            this.qp = null;
            this.error(ex.getMessage(), new Object[0]);
        }
    }

    private QueryProcessor queryProcessor(String query, Context ctx) {
        if (this.qp == null) {
            this.qp = this.progress(new QueryProcessor(query, ctx));
        }
        return this.qp;
    }

    @Override
    public final Result result() {
        Result r = this.result;
        this.result = null;
        return r;
    }

    private void evalInfo(String query, long hits, long updates, int runs) {
        long total = this.pars + this.comp + this.eval + this.prnt;
        this.info(Text.NL, new Object[0]);
        this.info(Text.QUERY_CC + QueryProcessor.removeComments(query, Integer.MAX_VALUE), new Object[0]);
        this.info(this.qp.info(), new Object[0]);
        this.info(Text.PARSING_CC + Performance.getTime(this.pars, runs), new Object[0]);
        this.info(Text.COMPILING_CC + Performance.getTime(this.comp, runs), new Object[0]);
        this.info(Text.EVALUATING_CC + Performance.getTime(this.eval, runs), new Object[0]);
        this.info(Text.PRINTING_CC + Performance.getTime(this.prnt, runs), new Object[0]);
        this.info(Text.TOTAL_TIME_CC + Performance.getTime(total, runs) + Text.NL, new Object[0]);
        this.info(Text.HITS_X_CC + hits + ' ' + (hits == 1L ? "Item" : "Items"), new Object[0]);
        this.info(Text.UPDATED_CC + updates + ' ' + (updates == 1L ? "Item" : "Items"), new Object[0]);
        this.info(Text.PRINTED_CC + Performance.format(this.out.size()), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plan(boolean c) {
        if (c != this.prop.is(Prop.COMPPLAN)) {
            return;
        }
        BufferOutput bo = null;
        try {
            if (this.prop.is(Prop.DOTPLAN)) {
                String path = this.context.prop.get(Prop.QUERYPATH);
                String dot = path.isEmpty() ? "plan.dot" : new IOFile(path).name().replaceAll("\\..*?$", ".dot");
                bo = new BufferOutput(dot);
                DOTSerializer d = new DOTSerializer(bo, this.prop.is(Prop.DOTCOMPACT));
                d.serialize(this.qp.plan());
                d.close();
                if (this.prop.is(Prop.DOTDISPLAY)) {
                    new ProcessBuilder(this.prop.get(Prop.DOTTY), dot).start();
                }
            }
            if (this.prop.is(Prop.XMLPLAN)) {
                this.info(Text.NL + Text.QUERY_PLAN_C, new Object[0]);
                this.info(this.qp.plan().serialize().toString(), new Object[0]);
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
        finally {
            if (bo != null) {
                try {
                    bo.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().xquery(0);
    }

    @Override
    public boolean stoppable() {
        return true;
    }
}

