/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.DropDB;
import org.basex.core.parse.CmdBuilder;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.util.Performance;
import org.basex.util.Util;

public final class Add
extends ACreate {
    private Builder build;
    boolean lock = true;

    public Add(String path) {
        this(path, (String)null);
    }

    public Add(String path, String input) {
        super(Perm.WRITE, true, path == null ? "" : path, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        IO io;
        String name = MetaData.normPath(this.args[0]);
        if (name == null || name.endsWith(".")) {
            return this.error(Text.NAME_INVALID_X, this.args[0]);
        }
        try {
            io = this.sourceToIO(name);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(Util.message(ex), new Object[0]);
        }
        if (io == null) {
            return this.error(Text.RES_NOT_FOUND, new Object[0]);
        }
        if (!io.exists()) {
            return this.in != null ? this.error(Text.RES_NOT_FOUND, new Object[0]) : this.error(Text.RES_NOT_FOUND_X, this.context.user.has(Perm.CREATE) ? io : this.args[1]);
        }
        if (!name.endsWith("/") && (io.isDir() || io.isArchive())) {
            name = name + '/';
        }
        String target = "";
        int s = name.lastIndexOf(47);
        if (s != -1) {
            target = name.substring(0, s);
            name = name.substring(s + 1);
        }
        Data data = this.context.data();
        if (!name.isEmpty()) {
            io.name(name);
        } else {
            name = io.name();
        }
        if (name.isEmpty()) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        DirParser parser = new DirParser(io, this.prop, data.meta.path);
        parser.target(target);
        long fl = parser.src.length();
        boolean large = false;
        Runtime rt = Runtime.getRuntime();
        if (fl > rt.freeMemory() / 3L) {
            Performance.gc(2);
            boolean bl = large = fl > rt.freeMemory() / 3L;
        }
        if (this.prop.is(Prop.MAINMEM)) {
            large = false;
        }
        String db = large ? this.context.mprop.random(data.meta.name) : name;
        this.build = large ? new DiskBuilder(db, parser, this.context) : new MemBuilder(db, parser);
        Data tmp = null;
        try {
            tmp = this.build.build();
            if (tmp.meta.size > 1) {
                if (this.lock && !data.startUpdate()) {
                    boolean bl = this.error(Text.DB_PINNED_X, data.meta.name);
                    return bl;
                }
                data.insert(data.meta.size, -1, tmp);
                this.context.update();
                if (this.lock) {
                    data.finishUpdate();
                }
            }
            boolean bl = this.info(((Parser)parser).info() + Text.PATH_ADDED_X_X, name, this.perf);
            return bl;
        }
        catch (IOException ex) {
            Util.debug(ex);
            boolean bl = this.error(Util.message(ex), new Object[0]);
            return bl;
        }
        finally {
            if (tmp != null) {
                tmp.close();
            }
            if (large) {
                DropDB.drop(db, this.context);
            }
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg("TO", 0).arg(1);
    }

    @Override
    protected String tit() {
        return Text.ADD;
    }

    @Override
    protected double prog() {
        return this.build != null ? this.build.prog() : 0.0;
    }
}

