/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.util.list.StringList;

public final class AlterDB
extends ACreate {
    private boolean closed;

    public AlterDB(String db, String name) {
        super(db, name);
    }

    @Override
    protected boolean run() {
        String src = this.args[0];
        String trg = this.args[1];
        if (!MetaData.validName(src, false)) {
            return this.error(Text.NAME_INVALID_X, src);
        }
        if (!MetaData.validName(trg, false)) {
            return this.error(Text.NAME_INVALID_X, trg);
        }
        if (!this.mprop.dbexists(src)) {
            return this.error(Text.DB_NOT_FOUND_X, src);
        }
        if (this.mprop.dbexists(trg)) {
            return this.error(Text.DB_EXISTS_X, trg);
        }
        if (!this.closed) {
            this.closed = AlterDB.close(this.context, src);
        }
        if (this.context.pinned(src)) {
            return this.error(Text.DB_PINNED_X, src);
        }
        return AlterDB.alter(src, trg, this.context) && (!this.closed || new Open(trg).run(this.context)) ? this.info(Text.DB_RENAMED_X, src, trg) : this.error(Text.DB_NOT_RENAMED_X, src);
    }

    @Override
    protected boolean databases(StringList db) {
        db.add(this.args);
        return true;
    }

    public static synchronized boolean alter(String source, String target, Context ctx) {
        if (ctx.mprop.dbpath(source).rename(ctx.mprop.dbpath(target))) {
            ctx.databases().alter(source, target);
            return true;
        }
        return false;
    }

    @Override
    public boolean newData(Context ctx) {
        this.closed = AlterDB.close(ctx, this.args[0]);
        return this.closed;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.ALTER) + " " + (Object)((Object)Commands.CmdAlter.DB)).args();
    }
}

