/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Databases;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.DropDB;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Copy
extends Command {
    private int of;
    private int tf;

    public Copy(String db, String newdb) {
        super(Perm.CREATE, db, newdb);
    }

    @Override
    protected boolean run() {
        String src = this.args[0];
        String trg = this.args[1];
        if (!MetaData.validName(src, false)) {
            return this.error(Text.NAME_INVALID_X, src);
        }
        if (!MetaData.validName(trg, false)) {
            return this.error(Text.NAME_INVALID_X, trg);
        }
        if (!this.mprop.dbexists(src)) {
            return this.error(Text.DB_NOT_FOUND_X, src);
        }
        if (this.mprop.dbexists(trg)) {
            return this.error(Text.DB_EXISTS_X, trg);
        }
        return this.copy(src, trg) ? this.info(Text.DB_COPIED_X, src, this.perf) : this.error(Text.DB_NOT_COPIED_X, src);
    }

    private boolean copy(String source, String target) {
        IOFile src = this.mprop.dbpath(source);
        IOFile trg = this.mprop.dbpath(target);
        StringList files = src.descendants();
        this.tf = files.size();
        boolean ok = true;
        try {
            for (String file : files) {
                if (Databases.FILES.matcher(file).matches()) {
                    new IOFile(src, file).copyTo(new IOFile(trg, file));
                }
                ++this.of;
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            ok = false;
        }
        if (!ok) {
            DropDB.drop(target, this.context);
        } else {
            this.context.databases().add(target);
        }
        return ok;
    }

    @Override
    protected boolean databases(StringList db) {
        db.add(this.args);
        return true;
    }

    @Override
    protected String tit() {
        return Text.COPY;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    protected double prog() {
        return (double)this.of / (double)this.tf;
    }
}

