/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.Date;
import org.basex.core.Command;
import org.basex.core.Databases;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class CreateBackup
extends Command {
    public CreateBackup(String arg) {
        super(Perm.CREATE, arg);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!MetaData.validName(name, true)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList dbs = this.context.databases().listDBs(name);
        if (dbs.size() == 0) {
            return this.error(Text.DB_NOT_FOUND_X, name);
        }
        boolean ok = true;
        for (String db : dbs) {
            if (!this.mprop.dbpath(db).isDir()) continue;
            if (this.backup(db)) {
                this.info(Text.DB_BACKUP_X, db, this.perf);
                continue;
            }
            this.info(Text.DB_NOT_BACKUP_X, db);
            ok = false;
        }
        return ok;
    }

    private boolean backup(String db) {
        String backup = db + '-' + Util.formatDate(new Date(), IO.DATE) + ".zip";
        IOFile zf = this.mprop.dbpath(backup);
        Zip zip = this.progress(new Zip(zf));
        try {
            zip.zip(this.mprop.dbpath(db), Databases.FILES);
            this.context.databases().add(db, true);
            return true;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }

    @Override
    protected boolean databases(StringList db) {
        return this.databases(db, 0);
    }

    @Override
    protected String tit() {
        return Text.BACKUP;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.BACKUP)).args();
    }
}

