/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.util.list.StringList;

public final class DropBackup
extends Command {
    public DropBackup(String name) {
        super(Perm.CREATE, name);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!MetaData.validName(name, true)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList dbs = this.context.databases().listDBs(name);
        for (String db : dbs) {
            DropBackup.drop(db.contains("-") ? db : db + '-', this.context);
        }
        if (dbs.size() == 0) {
            DropBackup.drop(name, this.context);
        }
        return this.info(Text.BACKUP_DROPPED_X, name + '*' + ".zip");
    }

    @Override
    protected boolean databases(StringList db) {
        return this.databases(db, 0);
    }

    private static int drop(String db, Context ctx) {
        IOFile dir = ctx.mprop.dbpath();
        int c = 0;
        for (IOFile f : dir.children()) {
            String n = f.name();
            if (!n.startsWith(db) || !n.endsWith(".zip") || !f.delete()) continue;
            ++c;
            int dl = db.length() - 1;
            ctx.databases().delete(db.charAt(dl) == '-' ? db.substring(0, dl) : db, true);
        }
        return c;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.BACKUP)).args();
    }
}

