/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Context;
import org.basex.core.Perm;
import org.basex.core.cmd.AQuery;
import org.basex.query.path.Axis;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;
import org.basex.util.list.BoolList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class Find
extends AQuery {
    public Find(String query) {
        super(Perm.NONE, true, query);
    }

    @Override
    protected boolean run() {
        return this.query(Find.find(this.args[0], this.context, false));
    }

    @Override
    public boolean updating(Context ctx) {
        return this.updating(ctx, Find.find(this.args[0], ctx, false));
    }

    @Override
    protected boolean databases(StringList db) {
        db.add("");
        return true;
    }

    public static String find(String query, Context ctx, boolean root) {
        boolean r;
        if (query.startsWith("/")) {
            return query;
        }
        boolean bl = r = root || ctx.root();
        if (query.isEmpty()) {
            return r ? "/" : ".";
        }
        String qu = query.replaceAll(" \\+", " ");
        String[] terms = Find.split(qu);
        String pre = "";
        String preds = "";
        String tag = "*";
        for (String term : terms) {
            if (term.startsWith("@=")) {
                preds = preds + "[@* = \"" + term.substring(2) + "\"]";
                continue;
            }
            if (term.startsWith("=")) {
                preds = preds + "[text() = \"" + term.substring(1) + "\"]";
                continue;
            }
            if (term.startsWith("~")) {
                preds = preds + "[text() contains text \"" + term.substring(1) + "\" using fuzzy]";
                continue;
            }
            if (term.startsWith("@")) {
                if (term.length() == 1) continue;
                preds = preds + "[@* contains text \"" + term.substring(1) + "\"]";
                if (!XMLToken.isName(Token.token(term = term.substring(1)))) continue;
                pre = pre + (r ? "" : ".") + "//@" + term + " | ";
                continue;
            }
            preds = preds + "[text() contains text \"" + term + "\"]";
            if (!XMLToken.isName(Token.token(term))) continue;
            pre = pre + (r ? "/" : "") + (Object)((Object)Axis.DESC) + "::*:" + term + " | ";
        }
        if (pre.isEmpty() && preds.isEmpty()) {
            return root ? "/" : ".";
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(pre + (r ? "/" : "") + (Object)((Object)Axis.DESCORSELF) + "::" + "*" + preds);
        return tb.toString();
    }

    public static String findTable(StringList filter, TokenList cols, BoolList elem, byte[] tag, boolean root) {
        TokenBuilder tb = new TokenBuilder();
        int is = filter.size();
        for (int i = 0; i < is; ++i) {
            String[] spl;
            for (String s : spl = Find.split(filter.get(i))) {
                byte[] term = Token.token(s);
                if (Token.contains(term, 34)) {
                    term = Token.replace(term, 34, 32);
                }
                if ((term = Token.trim(term)).length == 0) continue;
                tb.add(91);
                boolean elm = elem.get(i);
                tb.add(elm ? ".//" : "@");
                tb.add("*:");
                tb.add(cols.get(i));
                if (term[0] == 60 || term[0] == 62) {
                    tb.add(term[0]);
                    tb.addLong(Find.calcNum(Token.substring(term, 1)));
                } else {
                    tb.add(" contains text \"");
                    tb.add(term);
                    tb.add(34);
                }
                tb.add(93);
            }
        }
        return tb.isEmpty() ? "/" : (root ? "/" : "") + (Object)((Object)Axis.DESCORSELF) + "::*:" + Token.string(tag) + tb;
    }

    private static long calcNum(byte[] tok) {
        long i;
        int tl = tok.length;
        int s1 = tok.length < 1 ? 0 : Token.lc(tok[tl - 1]);
        int s2 = tok.length < 2 ? 0 : Token.lc(tok[tl - 2]);
        int f = 0;
        if (s1 == 107) {
            --tl;
            f = 10;
        }
        if (s1 == 109) {
            --tl;
            f = 20;
        }
        if (s1 == 103) {
            --tl;
            f = 30;
        }
        if (s1 == 98 && s2 == 107) {
            tl -= 2;
            f = 10;
        }
        if (s1 == 98 && s2 == 109) {
            tl -= 2;
            f = 20;
        }
        if (s1 == 98 && s2 == 103) {
            tl -= 2;
            f = 30;
        }
        return (i = Token.toLong(tok, 0, tl) << f) == Long.MIN_VALUE ? 0L : i;
    }

    private static String[] split(String str) {
        int l = str.length();
        String[] split = new String[l];
        int s = 0;
        char delim = '\u0000';
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < l; ++i) {
            char c = str.charAt(i);
            if (delim == '\u0000') {
                if (c == '\'' || c == '\"') {
                    delim = c;
                    continue;
                }
                if (!XMLToken.isChar(c) && c != '@' && c != '=' && c != '<' && c != '>' && c != '~') {
                    if (sb.length() == 0) continue;
                    split[s++] = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == delim) {
                delim = '\u0000';
                if (sb.length() == 0) continue;
                split[s++] = sb.toString();
                sb.setLength(0);
                continue;
            }
            if (c == '\'' || c == '\"') continue;
            sb.append(c);
        }
        if (sb.length() != 0) {
            split[s++] = sb.toString();
        }
        return Array.copyOf(split, s);
    }
}

