/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.regex.Pattern;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.MetaData;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.io.MimeTypes;
import org.basex.io.in.DataInput;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class List
extends Command {
    private static final Pattern PA = Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}.zip$");

    public List() {
        this(null);
    }

    public List(String name) {
        this(name, null);
    }

    public List(String name, String path) {
        super(Perm.NONE, name, path);
    }

    @Override
    protected boolean run() throws IOException {
        return this.args[0] == null || this.args[0].isEmpty() ? this.list() : this.listDB();
    }

    @Override
    protected boolean databases(StringList db) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean list() throws IOException {
        Table table = new Table();
        table.description = Text.DATABASES;
        boolean create = this.context.user.has(Perm.CREATE);
        table.header.add(DataText.T_NAME);
        table.header.add(Text.RESOURCES);
        table.header.add(Text.SIZE);
        if (create) {
            table.header.add(Text.INPUT_PATH);
        }
        for (String name : this.context.databases().listDBs()) {
            DataInput di = null;
            String file = null;
            long size = 0L;
            int docs = 0;
            MetaData meta = new MetaData(name, this.context);
            try {
                di = new DataInput(meta.dbfile("inf"));
                meta.read(di);
                size = meta.dbsize();
                docs = meta.ndocs;
                if (this.context.perm(Perm.READ, meta)) {
                    file = meta.original;
                }
            }
            catch (IOException ex) {
                file = Text.ERROR;
            }
            finally {
                if (di != null) {
                    try {
                        di.close();
                    }
                    catch (IOException ex) {}
                }
            }
            IOFile dir = new IOFile(this.mprop.dbpath(name), "raw");
            int bin = dir.descendants().size();
            if (file == null) continue;
            TokenList tl = new TokenList(4);
            tl.add(name);
            tl.add(docs + bin);
            tl.add(size);
            if (create) {
                tl.add(file);
            }
            table.contents.add(tl);
        }
        this.out.println(table.sort().finish());
        return true;
    }

    private boolean listDB() throws IOException {
        String path;
        String db = this.args[0];
        String string = path = this.args[1] != null ? this.args[1] : "";
        if (!MetaData.validName(db, false)) {
            return this.error(Text.NAME_INVALID_X, db);
        }
        Table table = new Table();
        table.description = Text.RESOURCES;
        table.header.add(Text.INPUT_PATH);
        table.header.add(Text.TYPE);
        table.header.add("Content-Type");
        table.header.add(Text.SIZE);
        try {
            TokenList tl;
            Data data = Open.open(db, this.context);
            Resources res = data.resources;
            IntList il = res.docs(path);
            int ds = il.size();
            for (int i = 0; i < ds; ++i) {
                int pre = il.get(i);
                tl = new TokenList(3);
                byte[] file = data.text(pre, true);
                tl.add(file);
                tl.add("xml");
                tl.add("application/xml");
                tl.add(data.size(pre, 0));
                table.contents.add(tl);
            }
            for (byte[] file : res.binaries(path)) {
                String f = Token.string(file);
                tl = new TokenList(3);
                tl.add(file);
                tl.add("raw");
                tl.add(MimeTypes.get(f));
                tl.add(data.meta.binary(f).length());
                table.contents.add(tl);
            }
            Close.close(data, this.context);
        }
        catch (IOException ex) {
            Util.debug(ex);
            String msg = ex.getMessage();
            return msg.isEmpty() ? this.error(Text.DB_NOT_OPENED_X, db) : this.error(msg, new Object[0]);
        }
        this.out.println(table.sort().finish());
        return true;
    }

    public static StringList list(Context ctx) {
        return List.list(ctx, false);
    }

    public static StringList list(Context ctx, boolean backups) {
        StringList db = new StringList();
        for (IOFile f : ctx.mprop.dbpath().children()) {
            String name = f.name();
            if (backups && name.endsWith(".zip")) {
                if (db.contains(name = List.dbname(name))) continue;
                db.add(name);
                continue;
            }
            if (!f.isDir() || name.startsWith(".")) continue;
            db.add(name);
        }
        return db.sort(false, true);
    }

    private static String dbname(String s) {
        return PA.split(s)[0];
    }
}

