/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Datas;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.data.MetaData;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Open
extends Command {
    public Open(String name) {
        this(name, null);
    }

    public Open(String name, String path) {
        super(Perm.NONE, name, path);
    }

    @Override
    protected boolean run() {
        new Close().run(this.context);
        String db = this.args[0];
        String path = this.args[1];
        if (!MetaData.validName(db, false)) {
            return this.error(Text.NAME_INVALID_X, db);
        }
        try {
            Data data = Open.open(db, this.context);
            this.context.openDB(data, path);
            if (data.meta.oldindex()) {
                this.info(Text.H_INDEX_FORMAT, new Object[0]);
            }
            if (data.meta.corrupt) {
                this.info(Text.DB_CORRUPT, new Object[0]);
            }
            return this.info(Text.DB_OPENED_X, db, this.perf);
        }
        catch (IOException ex) {
            Util.debug(ex);
            String msg = ex.getMessage();
            return msg.isEmpty() ? this.error(Text.DB_NOT_OPENED_X, db) : this.error(msg, new Object[0]);
        }
    }

    @Override
    protected boolean databases(StringList db) {
        db.add("").add(this.args[0]);
        return true;
    }

    @Override
    public boolean newData(Context ctx) {
        return new Close().run(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Data open(String name, Context ctx) throws IOException {
        Data data;
        Datas datas = ctx.datas;
        synchronized (datas) {
            data = ctx.pin(name);
            if (data == null) {
                if (!ctx.mprop.dbexists(name)) {
                    throw new BaseXException(Text.DB_NOT_FOUND_X, name);
                }
                data = new DiskData(name, ctx);
                ctx.pin(data);
            }
        }
        if (!ctx.perm(Perm.READ, data.meta)) {
            Close.close(data, ctx);
            throw new BaseXException(Text.PERM_REQUIRED_X, new Object[]{Perm.READ});
        }
        return data;
    }
}

