/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.regex.Pattern;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Open;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Restore
extends Command {
    private boolean closed;

    public Restore(String arg) {
        super(Perm.CREATE, arg);
    }

    @Override
    protected boolean run() {
        String db = this.args[0];
        if (!MetaData.validName(db, false)) {
            return this.error(Text.NAME_INVALID_X, db);
        }
        IOFile file = this.mprop.dbpath(db + ".zip");
        if (!file.exists()) {
            StringList list = Databases.backupPaths(db, this.context);
            if (!list.isEmpty()) {
                file = new IOFile(list.get(0));
            }
        } else {
            db = Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}$").split(db)[0];
        }
        if (!file.exists()) {
            return this.error(Text.BACKUP_NOT_FOUND_X, db);
        }
        if (!this.closed) {
            this.closed = Restore.close(this.context, db);
        }
        if (this.context.pinned(db)) {
            return this.error(Text.DB_PINNED_X, db);
        }
        return this.restore(file, db) && (!this.closed || new Open(db).run(this.context)) ? this.info(Text.DB_RESTORED_X, file.name(), this.perf) : this.error(Text.DB_NOT_RESTORED_X, db);
    }

    @Override
    protected boolean databases(StringList db) {
        db.add(this.args[0]);
        return true;
    }

    private boolean restore(IOFile file, String db) {
        try {
            this.progress(new Zip(file)).unzip(this.mprop.dbpath());
            this.context.databases().add(db);
            return true;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }

    @Override
    protected String tit() {
        return Text.RESTORE;
    }

    @Override
    public boolean newData(Context ctx) {
        this.closed = Restore.close(ctx, this.args[0]);
        return this.closed;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }
}

