/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import java.util.ArrayList;
import java.util.Locale;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.AlterUser;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateBackup;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateEvent;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.CreateUser;
import org.basex.core.cmd.Cs;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.DropBackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.DropEvent;
import org.basex.core.cmd.DropIndex;
import org.basex.core.cmd.DropUser;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Flush;
import org.basex.core.cmd.Get;
import org.basex.core.cmd.Grant;
import org.basex.core.cmd.Help;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.InfoIndex;
import org.basex.core.cmd.InfoStorage;
import org.basex.core.cmd.Inspect;
import org.basex.core.cmd.Kill;
import org.basex.core.cmd.List;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.core.cmd.Password;
import org.basex.core.cmd.Rename;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.RepoDelete;
import org.basex.core.cmd.RepoInstall;
import org.basex.core.cmd.RepoList;
import org.basex.core.cmd.Restore;
import org.basex.core.cmd.Retrieve;
import org.basex.core.cmd.Run;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.ShowBackups;
import org.basex.core.cmd.ShowDatabases;
import org.basex.core.cmd.ShowEvents;
import org.basex.core.cmd.ShowSessions;
import org.basex.core.cmd.ShowUsers;
import org.basex.core.cmd.Store;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CmdParser;
import org.basex.core.parse.Commands;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.value.item.QNm;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

final class StringParser
extends CmdParser {
    private final InputParser parser;
    private final Context ctx;

    StringParser(String in, Context c) {
        this.parser = new InputParser(in);
        this.ctx = c;
    }

    @Override
    void parse(ArrayList<Command> list) throws QueryException {
        block1: {
            Commands.Cmd cmd;
            do {
                cmd = this.consume(Commands.Cmd.class, null);
                list.add(this.parse(cmd));
                this.consumeWS();
                if (!this.parser.more()) break block1;
                if (!this.single) continue;
                throw this.help(null, cmd);
            } while (this.parser.consume(59));
            throw this.help(null, cmd);
        }
    }

    private Command parse(Commands.Cmd cmd) throws QueryException {
        switch (cmd) {
            case CREATE: {
                switch (this.consume(Commands.CmdCreate.class, cmd)) {
                    case BACKUP: {
                        return new CreateBackup(this.glob(cmd));
                    }
                    case DATABASE: 
                    case DB: {
                        return new CreateDB(this.name(cmd), this.single ? this.remaining(null) : this.string(null));
                    }
                    case INDEX: {
                        return new CreateIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    }
                    case USER: {
                        return new CreateUser(this.name(cmd), this.password());
                    }
                    case EVENT: {
                        return new CreateEvent(this.name(cmd));
                    }
                }
                break;
            }
            case COPY: {
                return new Copy(this.name(cmd), this.name(cmd));
            }
            case ALTER: {
                switch (this.consume(Commands.CmdAlter.class, cmd)) {
                    case DATABASE: 
                    case DB: {
                        return new AlterDB(this.name(cmd), this.name(cmd));
                    }
                    case USER: {
                        return new AlterUser(this.name(cmd), this.password());
                    }
                }
                break;
            }
            case OPEN: {
                return new Open(this.name(cmd), this.string(null));
            }
            case CHECK: {
                return new Check(this.string(cmd));
            }
            case ADD: {
                String arg = this.key("TO", null) ? this.string(cmd) : null;
                return new Add(arg, this.single ? this.remaining(cmd) : this.string(cmd));
            }
            case STORE: {
                String arg = this.key("TO", null) ? this.string(cmd) : null;
                return new Store(arg, this.single ? this.remaining(cmd) : this.string(cmd));
            }
            case RETRIEVE: {
                return new Retrieve(this.string(cmd));
            }
            case DELETE: {
                return new Delete(this.string(cmd));
            }
            case RENAME: {
                return new Rename(this.string(cmd), this.string(cmd));
            }
            case REPLACE: {
                return new Replace(this.string(cmd), this.single ? this.remaining(cmd) : this.string(cmd));
            }
            case INFO: {
                switch (this.consume(Commands.CmdInfo.class, cmd)) {
                    case NULL: {
                        return new Info();
                    }
                    case DATABASE: 
                    case DB: {
                        return new InfoDB();
                    }
                    case INDEX: {
                        return new InfoIndex((Object)this.consume(Commands.CmdIndexInfo.class, null));
                    }
                    case STORAGE: {
                        String arg2;
                        String arg1 = this.number(null);
                        String string = arg2 = arg1 != null ? this.number(null) : null;
                        if (arg1 == null) {
                            arg1 = this.xquery(null);
                        }
                        return new InfoStorage(arg1, arg2);
                    }
                }
                break;
            }
            case INSPECT: {
                return new Inspect();
            }
            case CLOSE: {
                return new Close();
            }
            case LIST: {
                return new List(this.string(null), this.string(null));
            }
            case DROP: {
                switch (this.consume(Commands.CmdDrop.class, cmd)) {
                    case DATABASE: 
                    case DB: {
                        return new DropDB(this.glob(cmd));
                    }
                    case INDEX: {
                        return new DropIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    }
                    case USER: {
                        return new DropUser(this.glob(cmd), this.key("ON", null) ? this.glob(cmd) : null);
                    }
                    case BACKUP: {
                        return new DropBackup(this.glob(cmd));
                    }
                    case EVENT: {
                        return new DropEvent(this.name(cmd));
                    }
                }
                break;
            }
            case OPTIMIZE: {
                switch (this.consume(Commands.CmdOptimize.class, cmd)) {
                    case NULL: {
                        return new Optimize();
                    }
                    case ALL: {
                        return new OptimizeAll();
                    }
                }
                break;
            }
            case EXPORT: {
                return new Export(this.string(cmd));
            }
            case XQUERY: {
                return new XQuery(this.xquery(cmd));
            }
            case RUN: {
                return new Run(this.string(cmd));
            }
            case FIND: {
                return new Find(this.string(cmd));
            }
            case CS: {
                return new Cs(this.xquery(cmd));
            }
            case GET: {
                return new Get(this.name(cmd));
            }
            case SET: {
                return new Set(this.name(cmd), (Object)this.string(null));
            }
            case PASSWORD: {
                return new Password(this.password());
            }
            case HELP: {
                return new Help(this.name(null));
            }
            case EXIT: {
                return new Exit();
            }
            case FLUSH: {
                return new Flush();
            }
            case KILL: {
                return new Kill(this.string(cmd));
            }
            case RESTORE: {
                return new Restore(this.name(cmd));
            }
            case SHOW: {
                switch (this.consume(Commands.CmdShow.class, cmd)) {
                    case DATABASES: {
                        return new ShowDatabases();
                    }
                    case SESSIONS: {
                        return new ShowSessions();
                    }
                    case USERS: {
                        return new ShowUsers(this.key("ON", null) ? this.name(cmd) : null);
                    }
                    case BACKUPS: {
                        return new ShowBackups();
                    }
                    case EVENTS: {
                        return new ShowEvents();
                    }
                }
                break;
            }
            case GRANT: {
                Commands.CmdPerm perm = this.consume(Commands.CmdPerm.class, cmd);
                if (perm == null) {
                    throw this.help(null, cmd);
                }
                String db = this.key("ON", null) ? this.glob(cmd) : null;
                this.key("TO", cmd);
                return new Grant((Object)perm, this.glob(cmd), db);
            }
            case REPO: {
                switch (this.consume(Commands.CmdRepo.class, cmd)) {
                    case INSTALL: {
                        return new RepoInstall(this.string(cmd), new InputInfo(this.parser));
                    }
                    case DELETE: {
                        return new RepoDelete(this.string(cmd), new InputInfo(this.parser));
                    }
                    case LIST: {
                        return new RepoList();
                    }
                }
                break;
            }
        }
        throw Util.notexpected("command specified, but not implemented yet");
    }

    String string(Commands.Cmd cmd) throws QueryException {
        StringBuilder sb = new StringBuilder();
        this.consumeWS();
        boolean q = false;
        while (this.parser.more()) {
            char c = this.parser.curr();
            if (!q && (c <= ' ' || c == ';')) break;
            if (c == '\"') {
                q ^= true;
            } else {
                sb.append(c);
            }
            this.parser.consume();
        }
        return this.finish(cmd, sb);
    }

    private String remaining(Commands.Cmd cmd) throws QueryException {
        StringBuilder sb = new StringBuilder();
        this.consumeWS();
        while (this.parser.more()) {
            sb.append(this.parser.consume());
        }
        String arg = this.finish(cmd, sb);
        if (arg != null) {
            if (arg.startsWith("\"")) {
                arg = arg.substring(1);
            }
            if (arg.endsWith("\"")) {
                arg = arg.substring(0, arg.length() - 1);
            }
        }
        return arg;
    }

    private String xquery(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        if (this.parser.more() && !this.parser.curr(59)) {
            QueryParser p = new QueryParser(this.parser.input, new QueryContext(this.ctx));
            p.ip = this.parser.ip;
            p.parse();
            sb.append(this.parser.input.substring(this.parser.ip, p.ip));
            this.parser.ip = p.ip;
        }
        return this.finish(cmd, sb);
    }

    private String name(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        while (Token.letterOrDigit(this.parser.curr()) || this.parser.curr(45)) {
            sb.append(this.parser.consume());
        }
        return this.finish(cmd, !this.parser.more() || this.parser.curr(59) || Token.ws(this.parser.curr()) ? sb : null);
    }

    private String password() throws QueryException {
        String pw = this.string(null);
        return pw != null ? pw : (this.passwords == null ? "" : this.passwords.password());
    }

    private String glob(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        char c;
        while (Token.letterOrDigit(c = this.parser.curr()) || c == '-' || c == '*' || c == '?' || c == ',') {
            sb.append(this.parser.consume());
        }
        return this.finish(cmd, !this.parser.more() || this.parser.curr(59) || Token.ws(this.parser.curr()) ? sb : null);
    }

    private boolean key(String key, Commands.Cmd cmd) throws QueryException {
        boolean ok;
        this.consumeWS();
        int p = this.parser.ip;
        boolean bl = ok = !(!this.parser.consume(key) && !this.parser.consume(key.toLowerCase(Locale.ENGLISH)) || !this.parser.curr(0) && !Token.ws(this.parser.curr()));
        if (!ok) {
            this.parser.ip = p;
            if (cmd != null) {
                throw this.help(null, cmd);
            }
        }
        return ok;
    }

    private String finish(Commands.Cmd cmd, StringBuilder s) throws QueryException {
        if (s != null && s.length() != 0) {
            return s.toString();
        }
        if (cmd != null) {
            throw this.help(null, cmd);
        }
        return null;
    }

    private String number(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        if (this.parser.curr() == '-') {
            sb.append(this.parser.consume());
        }
        while (Token.digit(this.parser.curr())) {
            sb.append(this.parser.consume());
        }
        return this.finish(cmd, !this.parser.more() || this.parser.curr(59) || Token.ws(this.parser.curr()) ? sb : null);
    }

    private void consumeWS() {
        while (this.parser.ip < this.parser.il && this.parser.input.charAt(this.parser.ip) <= ' ') {
            ++this.parser.ip;
        }
        this.parser.im = this.parser.ip - 1;
    }

    private <E extends Enum<E>> E consume(Class<E> cmp, Commands.Cmd par) throws QueryException {
        String token = this.name(null);
        if (!this.suggest || token == null || token.length() > 1) {
            try {
                String t = token == null ? "NULL" : token.toUpperCase(Locale.ENGLISH);
                return Enum.valueOf(cmp, t);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        Enum<?>[] alt = StringParser.list(cmp, token);
        if (token == null) {
            throw par == null ? this.error(StringParser.list(alt), Text.EXPECTING_CMD, new Object[0]) : this.help(StringParser.list(alt), par);
        }
        byte[] name = Token.uc(Token.token(token));
        Levenshtein ls = new Levenshtein();
        for (Enum<?> s : StringParser.list(cmp, null)) {
            byte[] sm = Token.uc(Token.token(s.name()));
            if (!ls.similar(name, sm, 0) || !Commands.Cmd.class.isInstance(s)) continue;
            throw this.error(StringParser.list(alt), Text.UNKNOWN_SIMILAR_X, name, sm);
        }
        throw par == null ? this.error(StringParser.list(alt), Text.UNKNOWN_TRY_X, token) : this.help(StringParser.list(alt), par);
    }

    private QueryException help(StringList alt, Commands.Cmd cmd) {
        return this.error(alt, Text.SYNTAX_X, cmd.help(true));
    }

    private static <T extends Enum<T>> Enum<?>[] list(Class<T> en, String i) {
        Enum[] list = new Enum[]{};
        String t = i == null ? "" : i.toUpperCase(Locale.ENGLISH);
        for (Enum e : (Enum[])en.getEnumConstants()) {
            if (!e.name().startsWith(t)) continue;
            int s = list.length;
            Enum[] tmp = new Enum[s + 1];
            System.arraycopy(list, 0, tmp, 0, s);
            tmp[s] = e;
            list = tmp;
        }
        return list;
    }

    private QueryException error(StringList comp, String m, Object ... e) {
        return new QueryException(this.parser.info(), new QNm(), m, e).suggest(this.parser, comp);
    }

    private static StringList list(Enum<?>[] comp) {
        StringList list = new StringList();
        for (Enum<?> c : comp) {
            list.add(c.name().toLowerCase(Locale.ENGLISH));
        }
        return list;
    }
}

