/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.AlterUser;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateBackup;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateEvent;
import org.basex.core.cmd.CreateUser;
import org.basex.core.cmd.Cs;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.DropBackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.DropEvent;
import org.basex.core.cmd.DropUser;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Flush;
import org.basex.core.cmd.Get;
import org.basex.core.cmd.Grant;
import org.basex.core.cmd.Help;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.InfoIndex;
import org.basex.core.cmd.InfoStorage;
import org.basex.core.cmd.Inspect;
import org.basex.core.cmd.Kill;
import org.basex.core.cmd.List;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.core.cmd.Password;
import org.basex.core.cmd.Rename;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.RepoDelete;
import org.basex.core.cmd.RepoInstall;
import org.basex.core.cmd.RepoList;
import org.basex.core.cmd.Restore;
import org.basex.core.cmd.Retrieve;
import org.basex.core.cmd.Run;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.ShowBackups;
import org.basex.core.cmd.ShowDatabases;
import org.basex.core.cmd.ShowEvents;
import org.basex.core.cmd.ShowSessions;
import org.basex.core.cmd.ShowUsers;
import org.basex.core.cmd.Store;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CmdParser;
import org.basex.io.IO;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.TokenBuilder;

final class XMLParser
extends CmdParser {
    private final String input;
    private final Context ctx;

    XMLParser(String in, Context c) {
        this.input = in;
        this.ctx = c;
    }

    @Override
    void parse(ArrayList<Command> list) throws QueryException {
        try {
            DBNode node = new DBNode(IO.get(this.input), this.ctx.prop);
            String query = "/*";
            if (!this.execute("commands", node).isEmpty()) {
                query = "commands" + query;
                if (this.execute("commands[not(text())]", node).isEmpty()) {
                    throw this.error(Text.SYNTAX_X, "<commands><...></commands>");
                }
            }
            QueryProcessor qa = new QueryProcessor(query, this.ctx).context(node);
            for (Item ia : qa.value()) {
                list.add(this.command(ia));
            }
        }
        catch (IOException ex) {
            throw this.error(Text.PARSING_CC + "%", ex);
        }
    }

    private Command command(Item root) throws QueryException {
        String e = ((ANode)root).qname().toJava().toString();
        if (e.equals("add") && this.check(root, "path?", "<input")) {
            return new Add(this.value(root, "path"), this.xml(root));
        }
        if (e.equals("alter-db") && this.check(root, "name", "newname")) {
            return new AlterDB(this.value(root, "name"), this.value(root, "newname"));
        }
        if (e.equals("alter-user") && this.check(root, "name", "#password?")) {
            return new AlterUser(this.value(root, "name"), this.value(root));
        }
        if (e.equals("check") && this.check(root, "input")) {
            return new Check(this.value(root, "input"));
        }
        if (e.equals("close") && this.check(root, new String[0])) {
            return new Close();
        }
        if (e.equals("copy") && this.check(root, "name", "newname")) {
            return new Copy(this.value(root, "name"), this.value(root, "newname"));
        }
        if (e.equals("create-backup") && this.check(root, "name")) {
            return new CreateBackup(this.value(root, "name"));
        }
        if (e.equals("create-db") && this.check(root, "name", "<input?")) {
            return new CreateDB(this.value(root, "name"), this.xml(root));
        }
        if (e.equals("create-event") && this.check(root, "name?")) {
            return new CreateEvent(this.value(root, "name"));
        }
        if (e.equals("create-index") && this.check(root, "type")) {
            return new Export(this.value(root, "type"));
        }
        if (e.equals("create-user") && this.check(root, "name", "#password?")) {
            return new CreateUser(this.value(root, "name"), this.value(root));
        }
        if (e.equals("cs") && this.check(root, "#query")) {
            return new Cs(this.value(root));
        }
        if (e.equals("delete") && this.check(root, "path")) {
            return new Delete(this.value(root, "path"));
        }
        if (e.equals("drop-backup") && this.check(root, "name")) {
            return new DropBackup(this.value(root, "name"));
        }
        if (e.equals("drop-db") && this.check(root, "name")) {
            return new DropDB(this.value(root, "name"));
        }
        if (e.equals("drop-event") && this.check(root, "name")) {
            return new DropEvent(this.value(root, "name"));
        }
        if (e.equals("drop-index") && this.check(root, "type")) {
            return new Export(this.value(root, "type"));
        }
        if (e.equals("drop-user") && this.check(root, "name", "database?")) {
            return new DropUser(this.value(root, "name"), this.value(root, "database"));
        }
        if (e.equals("exit") && this.check(root, new String[0])) {
            return new Exit();
        }
        if (e.equals("export") && this.check(root, "path")) {
            return new Export(this.value(root, "path"));
        }
        if (e.equals("find") && this.check(root, "#query")) {
            return new Find(this.value(root));
        }
        if (e.equals("flush") && this.check(root, new String[0])) {
            return new Flush();
        }
        if (e.equals("get") && this.check(root, "option")) {
            return new Get(this.value(root, "option"));
        }
        if (e.equals("grant") && this.check(root, "name", "permission", "database?")) {
            return new Grant((Object)this.value(root, "permission"), this.value(root, "name"), this.value(root, "database"));
        }
        if (e.equals("help") && this.check(root, "#command?")) {
            return new Help(this.value(root));
        }
        if (e.equals("info") && this.check(root, new String[0])) {
            return new Info();
        }
        if (e.equals("info-db") && this.check(root, new String[0])) {
            return new InfoDB();
        }
        if (e.equals("info-index") && this.check(root, "type?")) {
            return new InfoIndex(this.value(root, "type"));
        }
        if (e.equals("info-storage") && this.check(root, "#query?")) {
            return new InfoStorage(this.value(root));
        }
        if (e.equals("kill") && this.check(root, "target?")) {
            return new Kill(this.value(root, "target"));
        }
        if (e.equals("list") && this.check(root, "name?", "path?")) {
            return new List(this.value(root, "name"), this.value(root, "path"));
        }
        if (e.equals("open") && this.check(root, "name", "path?")) {
            return new Open(this.value(root, "name"), this.value(root, "path"));
        }
        if (e.equals("optimize") && this.check(root, new String[0])) {
            return new Optimize();
        }
        if (e.equals("optimize-all") && this.check(root, new String[0])) {
            return new OptimizeAll();
        }
        if (e.equals("password") && this.check(root, "#password?")) {
            return new Password(this.value(root));
        }
        if (e.equals("rename") && this.check(root, "path", "newpath")) {
            return new Rename(this.value(root, "path"), this.value(root, "newpath"));
        }
        if (e.equals("replace") && this.check(root, "path", "<input")) {
            return new Replace(this.value(root, "path"), this.xml(root));
        }
        if (e.equals("repo-delete") && this.check(root, "name")) {
            return new RepoDelete(this.value(root, "name"), null);
        }
        if (e.equals("repo-install") && this.check(root, "path")) {
            return new RepoInstall(this.value(root, "path"), null);
        }
        if (e.equals("repo-list") && this.check(root, new String[0])) {
            return new RepoList();
        }
        if (e.equals("restore") && this.check(root, "name")) {
            return new Restore(this.value(root, "name"));
        }
        if (e.equals("retrieve") && this.check(root, "path")) {
            return new Retrieve(this.value(root, "path"));
        }
        if (e.equals("run") && this.check(root, "file")) {
            return new Run(this.value(root, "file"));
        }
        if (e.equals("inspect") && this.check(root, new String[0])) {
            return new Inspect();
        }
        if (e.equals("set") && this.check(root, "option", "#value?")) {
            return new Set(this.value(root, "option"), (Object)this.value(root));
        }
        if (e.equals("show-backups") && this.check(root, new String[0])) {
            return new ShowBackups();
        }
        if (e.equals("show-databases") && this.check(root, new String[0])) {
            return new ShowDatabases();
        }
        if (e.equals("show-events") && this.check(root, new String[0])) {
            return new ShowEvents();
        }
        if (e.equals("show-sessions") && this.check(root, new String[0])) {
            return new ShowSessions();
        }
        if (e.equals("show-users") && this.check(root, "database?")) {
            return new ShowUsers(this.value(root, "database"));
        }
        if (e.equals("store") && this.check(root, "path?", "<input")) {
            return new Store(this.value(root, "path"), this.xml(root));
        }
        if (e.equals("xquery") && this.check(root, "#query")) {
            return new XQuery(this.value(root));
        }
        throw this.error(Text.UNKNOWN_CMD_X, "<" + e + "/>");
    }

    private String value(Item root, String att) throws QueryException {
        return this.execute("string(@" + att + ")", root);
    }

    private String value(Item root) throws QueryException {
        return this.execute("string(.)", root);
    }

    private String xml(Item root) throws QueryException {
        return new QueryProcessor("node()", this.ctx).context(root).execute().toString().trim();
    }

    private String execute(String query, Item context) throws QueryException {
        QueryProcessor qp = new QueryProcessor(query, this.ctx).context(context);
        Iter ir = qp.iter();
        Item it = ir.next();
        return it == null ? "" : it.toJava().toString().trim();
    }

    private boolean check(Item root, String ... checks) throws QueryException {
        byte[] a;
        ValueBuilder ma = new ValueBuilder();
        ValueBuilder oa = new ValueBuilder();
        String t = null;
        boolean ot = true;
        boolean n = false;
        for (String c : checks) {
            boolean o = c.endsWith("?");
            if (!(c = c.replace("?", "")).isEmpty() && !Character.isLetter(c.charAt(0))) {
                t = c.substring(1);
                ot = o;
                n = c.charAt(0) == '<';
                continue;
            }
            (o ? oa : ma).add(Str.get(c));
        }
        TokenBuilder tb = new TokenBuilder(".");
        tb.add("[every $e in $A satisfies @*/name() = $e]");
        tb.add("[every $e in @* satisfies $e/name() = ($A,$O)]");
        tb.add("[every $e in @* satisfies data($e)]");
        if (t == null) {
            tb.add("[not(node())]");
        } else if (!ot) {
            tb.add("[node()]");
            if (!n) {
                tb.add("[not(*)]");
            }
        }
        QueryProcessor qp = new QueryProcessor(tb.toString(), this.ctx).context(root);
        qp.bind("A", ma).bind("O", oa);
        if (!qp.execute().toString().isEmpty()) {
            return true;
        }
        TokenBuilder syntax = new TokenBuilder();
        byte[] nm = ((ANode)root).qname().string();
        syntax.reset().add(60).add(nm);
        for (Item i : ma) {
            a = i.string(null);
            syntax.add(32).add(a).add("=\"...\"");
        }
        for (Item i : oa) {
            a = i.string(null);
            syntax.add(" (").add(a).add("=\"...\")");
        }
        if (t != null) {
            syntax.add(62);
            if (ot) {
                syntax.add(40);
            }
            syntax.add(91).add(t).add(93);
            if (ot) {
                syntax.add(41);
            }
            syntax.add("</").add(nm).add(62);
        } else {
            syntax.add("/>");
        }
        throw this.error(Text.SYNTAX_X, syntax);
    }

    private QueryException error(String msg, Object ... ext) {
        return new QueryException(null, new QNm(), msg, ext);
    }
}

