/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.Users;
import org.basex.core.cmd.DropDB;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.Version;
import org.basex.util.ft.Language;

public final class MetaData {
    public final IOFile path;
    public final Prop prop;
    public String name;
    public Users users;
    public String encoding = "UTF-8";
    public String original = "";
    public long filesize;
    public int ndocs;
    public long time;
    public boolean chop;
    public boolean updindex;
    public boolean textindex;
    public boolean attrindex;
    public boolean ftxtindex;
    public boolean createtext;
    public boolean createattr;
    public boolean createftxt;
    public boolean stemming;
    public boolean casesens;
    public boolean diacritics;
    public int maxcats;
    public int maxlen;
    public Language language;
    public boolean uptodate = true;
    public boolean corrupt;
    public boolean dirty;
    public int size;
    public int lastid = -1;
    private boolean oldindex;
    public boolean wcindex;
    public int scoring;

    public MetaData(Prop pr) {
        this("", pr, null);
    }

    public MetaData(String db, Context ctx) {
        this(db, ctx.prop, ctx.mprop);
    }

    private MetaData(String db, Prop pr, MainProp mprop) {
        this.path = mprop != null ? mprop.dbpath(db) : null;
        this.prop = pr;
        this.name = db;
        this.chop = this.prop.is(Prop.CHOP);
        this.createtext = this.prop.is(Prop.TEXTINDEX);
        this.createattr = this.prop.is(Prop.ATTRINDEX);
        this.createftxt = this.prop.is(Prop.FTINDEX);
        this.diacritics = this.prop.is(Prop.DIACRITICS);
        this.stemming = this.prop.is(Prop.STEMMING);
        this.casesens = this.prop.is(Prop.CASESENS);
        this.updindex = this.prop.is(Prop.UPDINDEX);
        this.maxlen = this.prop.num(Prop.MAXLEN);
        this.maxcats = this.prop.num(Prop.MAXCATS);
        this.language = Language.get(this.prop);
        this.users = new Users(false);
    }

    public static String normPath(String path) {
        StringBuilder sb = new StringBuilder();
        boolean slash = false;
        for (int p = 0; p < path.length(); ++p) {
            char c = path.charAt(p);
            if (c == '\\' || c == '/') {
                if (!slash && p != 0) {
                    sb.append('/');
                }
                slash = true;
                continue;
            }
            if (Prop.WIN && ":*?\"<>\\|".indexOf(c) != -1) {
                return null;
            }
            if (slash) {
                slash = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean validName(String name, boolean glob) {
        if (name == null) {
            return false;
        }
        int nl = name.length();
        for (int n = 0; n < nl; ++n) {
            char ch = name.charAt(n);
            if (glob && (ch == '?' || ch == '*' || ch == ',') || Token.letterOrDigit(ch) || ch == '-') continue;
            return false;
        }
        return nl != 0;
    }

    private static long dbsize(IOFile io) {
        long s = 0L;
        if (io.isDir()) {
            for (IOFile f : io.children()) {
                s += MetaData.dbsize(f);
            }
        } else {
            s += io.length();
        }
        return s;
    }

    public static IOFile file(IOFile path, String fn) {
        return new IOFile(path, fn + ".basex");
    }

    public boolean oldindex() {
        return this.oldindex || this.wcindex || this.scoring != 0;
    }

    public long dbsize() {
        return this.path != null ? MetaData.dbsize(this.path) : 0L;
    }

    public long dbtime() {
        return this.path != null ? this.path.timeStamp() : 0L;
    }

    public IOFile dbfile(String fn) {
        return MetaData.file(this.path, fn);
    }

    public IOFile binaries() {
        return new IOFile(this.path, "raw");
    }

    public IOFile binary(String pth) {
        if (this.path == null) {
            return null;
        }
        IOFile dir = this.binaries();
        IOFile file = new IOFile(dir, pth);
        return file.path().startsWith(dir.path()) ? file : null;
    }

    public synchronized boolean drop(String pat) {
        return this.path != null && DropDB.drop(this.path, pat + ".basex");
    }

    public void read(DataInput in) throws IOException {
        String k;
        String storage = "";
        String istorage = "";
        while (!(k = Token.string(in.readToken())).isEmpty()) {
            if (k.equals("PERM")) {
                this.users.read(in);
                continue;
            }
            String v = Token.string(in.readToken());
            if (k.equals("STORAGE")) {
                storage = v;
                continue;
            }
            if (k.equals("ISTORAGE")) {
                istorage = v;
                continue;
            }
            if (k.equals("FNAME")) {
                this.original = v;
                continue;
            }
            if (k.equals("ENCODING")) {
                this.encoding = v;
                continue;
            }
            if (k.equals("SIZE")) {
                this.size = Token.toInt(v);
                continue;
            }
            if (k.equals("NDOCS")) {
                this.ndocs = Token.toInt(v);
                continue;
            }
            if (k.equals("FTSCTYPE")) {
                this.scoring = Token.toInt(v);
                continue;
            }
            if (k.equals("MAXLEN")) {
                this.maxlen = Token.toInt(v);
                continue;
            }
            if (k.equals("MAXCATS")) {
                this.maxcats = Token.toInt(v);
                continue;
            }
            if (k.equals("LASTID")) {
                this.lastid = Token.toInt(v);
                continue;
            }
            if (k.equals("TIME")) {
                this.time = Token.toLong(v);
                continue;
            }
            if (k.equals("FSIZE")) {
                this.filesize = Token.toLong(v);
                continue;
            }
            if (k.equals("FTDC")) {
                this.diacritics = MetaData.toBool(v);
                continue;
            }
            if (k.equals("CHOPPED")) {
                this.chop = MetaData.toBool(v);
                continue;
            }
            if (k.equals("UPDINDEX")) {
                this.updindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("TXTINDEX")) {
                this.textindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("ATVINDEX")) {
                this.attrindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("FTXINDEX")) {
                this.ftxtindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("CRTTXT")) {
                this.createtext = MetaData.toBool(v);
                continue;
            }
            if (k.equals("CRTATV")) {
                this.createattr = MetaData.toBool(v);
                continue;
            }
            if (k.equals("CRTFTX")) {
                this.createftxt = MetaData.toBool(v);
                continue;
            }
            if (k.equals("WCINDEX")) {
                this.wcindex = MetaData.toBool(v);
                continue;
            }
            if (k.equals("FTSTEM")) {
                this.stemming = MetaData.toBool(v);
                continue;
            }
            if (k.equals("FTCS")) {
                this.casesens = MetaData.toBool(v);
                continue;
            }
            if (k.equals("FTDC")) {
                this.diacritics = MetaData.toBool(v);
                continue;
            }
            if (k.equals("FTLANG")) {
                this.language = Language.get(v);
                continue;
            }
            if (k.equals("UPTODATE")) {
                this.uptodate = MetaData.toBool(v);
                continue;
            }
            if (!k.equals("PTHINDEX") || MetaData.toBool(v)) continue;
            this.uptodate = false;
        }
        if (!storage.equals("7.1") && new Version(storage).compareTo(new Version("7.1")) > 0) {
            throw new BuildException(Text.H_DB_FORMAT, storage);
        }
        this.oldindex = !istorage.equals("7.1") && new Version(istorage).compareTo(new Version("7.1")) > 0;
        this.corrupt = this.dbfile("upd").exists();
        if (this.wcindex) {
            this.ftxtindex = false;
        }
    }

    void write(DataOutput out) throws IOException {
        MetaData.writeInfo(out, "STORAGE", "7.1");
        MetaData.writeInfo(out, "FNAME", this.original);
        MetaData.writeInfo(out, "TIME", this.time);
        MetaData.writeInfo(out, "ISTORAGE", "7.1");
        MetaData.writeInfo(out, "FSIZE", this.filesize);
        MetaData.writeInfo(out, "NDOCS", this.ndocs);
        MetaData.writeInfo(out, "ENCODING", this.encoding);
        MetaData.writeInfo(out, "SIZE", this.size);
        MetaData.writeInfo(out, "CHOPPED", this.chop);
        MetaData.writeInfo(out, "UPDINDEX", this.updindex);
        MetaData.writeInfo(out, "TXTINDEX", this.textindex);
        MetaData.writeInfo(out, "ATVINDEX", this.attrindex);
        MetaData.writeInfo(out, "FTXINDEX", this.ftxtindex);
        MetaData.writeInfo(out, "CRTTXT", this.createtext);
        MetaData.writeInfo(out, "CRTATV", this.createattr);
        MetaData.writeInfo(out, "CRTFTX", this.createftxt);
        MetaData.writeInfo(out, "FTSTEM", this.stemming);
        MetaData.writeInfo(out, "FTCS", this.casesens);
        MetaData.writeInfo(out, "FTDC", this.diacritics);
        MetaData.writeInfo(out, "MAXLEN", this.maxlen);
        MetaData.writeInfo(out, "MAXCATS", this.maxcats);
        MetaData.writeInfo(out, "UPTODATE", this.uptodate);
        MetaData.writeInfo(out, "LASTID", this.lastid);
        if (this.language != null) {
            MetaData.writeInfo(out, "FTLANG", this.language.toString());
        }
        out.writeToken(Token.token("PERM"));
        this.users.write(out);
        out.write(0);
    }

    void update() {
        this.time = System.currentTimeMillis();
        this.uptodate = false;
        this.dirty = true;
        if (!this.updindex) {
            this.textindex = false;
            this.attrindex = false;
        }
        this.ftxtindex = false;
    }

    private static boolean toBool(String v) {
        return v.equals("1");
    }

    private static void writeInfo(DataOutput out, String k, boolean pr) throws IOException {
        MetaData.writeInfo(out, k, pr ? "1" : "0");
    }

    private static void writeInfo(DataOutput out, String k, long v) throws IOException {
        MetaData.writeInfo(out, k, Long.toString(v));
    }

    private static void writeInfo(DataOutput out, String k, String v) throws IOException {
        out.writeToken(Token.token(k));
        out.writeToken(Token.token(v));
    }
}

