/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.Set;
import org.basex.core.Text;
import org.basex.data.DataText;
import org.basex.data.NSNode;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Namespaces {
    private final IntList uriStack = new IntList();
    private final TokenSet pref;
    private final TokenSet uri;
    final NSNode root;
    private boolean newns;
    private int uriL = 1;
    NSNode current;

    public Namespaces() {
        this.pref = new TokenSet();
        this.uri = new TokenSet();
        this.current = this.root = new NSNode(-1);
    }

    Namespaces(DataInput in) throws IOException {
        this.pref = new TokenSet(in);
        this.uri = new TokenSet(in);
        this.current = this.root = new NSNode(in, null);
    }

    void write(DataOutput out) throws IOException {
        this.pref.write(out);
        this.uri.write(out);
        this.root.write(out);
    }

    public NSNode add(byte[] p, byte[] u, int pre) {
        NSNode newNode = null;
        if (!this.newns) {
            newNode = new NSNode(pre);
            this.current = this.current.add(newNode);
            this.newns = true;
        }
        int k = this.addPrefix(p);
        int v = this.addURI(u);
        this.current.add(k, v);
        if (p.length == 0) {
            this.uriStack.set(this.uriL, v);
        }
        return newNode;
    }

    public boolean open() {
        this.uriStack.set(this.uriL + 1, this.uriStack.get(this.uriL));
        ++this.uriL;
        boolean n = this.newns;
        this.newns = false;
        return n;
    }

    public void close(int pre) {
        while (this.current.pre >= pre && this.current.par != null) {
            this.current = this.current.par;
        }
        --this.uriL;
        this.uriStack.set(this.uriL, this.uriStack.get(this.uriL - 1));
    }

    public int uri(byte[] n, boolean elem) {
        int u;
        if (this.uri.size() == 0) {
            return 0;
        }
        byte[] pr = Token.prefix(n);
        int n2 = u = elem ? this.uriStack.get(this.uriL) : 0;
        if (pr.length != 0) {
            u = this.uri(pr, this.current);
        }
        return u;
    }

    public int size() {
        return this.uri.size();
    }

    public byte[] globalNS() {
        if (this.root.size == 0) {
            return Token.EMPTY;
        }
        if (this.root.size > 1) {
            return null;
        }
        NSNode n = this.root.ch[0];
        if (n.size != 0 || n.pre != 1 || n.vals.length != 2) {
            return null;
        }
        return this.pref.key(n.vals[0]).length == 0 ? this.uri.key(n.vals[1]) : null;
    }

    public byte[] uri(int id) {
        return this.uri.key(id);
    }

    public int uri(byte[] name, int pre) {
        return this.uri(Token.prefix(name), this.current.find(pre));
    }

    public void delete(byte[] u) {
        int id = this.uri.id(u);
        if (id != 0) {
            this.current.delete(id);
        }
    }

    byte[] prefix(int id) {
        return this.pref.key(id);
    }

    int[] get(int pre) {
        return this.current.find((int)pre).vals;
    }

    private int uri(byte[] pr, NSNode nd) {
        if (Token.eq(Token.XML, pr)) {
            return 0;
        }
        int id = this.pref.id(pr);
        if (id == 0) {
            return 0;
        }
        NSNode n = nd;
        while (n != null) {
            int u = n.uri(id);
            if (u != 0) {
                return u;
            }
            n = n.par;
        }
        return 0;
    }

    void delete(int pre, int size) {
        NSNode nd = this.current.find(pre);
        if (nd.pre == pre) {
            nd = nd.par;
        }
        while (nd != null) {
            nd.delete(pre, size);
            nd = nd.par;
        }
        Namespaces.delete(this.root, pre, size);
    }

    private static void delete(NSNode n, int pre, int ms) {
        if (n.pre >= pre + ms) {
            n.pre -= ms;
        }
        for (int c = 0; c < n.size; ++c) {
            Namespaces.delete(n.ch[c], pre, ms);
        }
    }

    void insert(int pre, int ms, Set<NSNode> cache) {
        Namespaces.insert(this.root, pre, ms, cache);
    }

    private static void insert(NSNode n, int pre, int ms, Set<NSNode> cache) {
        if (!cache.contains(n) && n.pre >= pre) {
            n.pre += ms;
        }
        for (int c = 0; c < n.size; ++c) {
            Namespaces.insert(n.ch[c], pre, ms, cache);
        }
    }

    public int add(int pre, int par, byte[] p, byte[] u) {
        NSNode nd = this.current.find(par);
        NSNode t = new NSNode(pre);
        int k = this.addPrefix(p);
        int v = this.addURI(u);
        if (nd.pre == pre) {
            nd.add(k, v);
        } else {
            t.add(k, v);
            nd.add(t);
        }
        return v;
    }

    public int addURI(byte[] u) {
        return Math.abs(this.uri.add(u));
    }

    private int addPrefix(byte[] p) {
        return Math.abs(this.pref.add(p));
    }

    void setNearestRoot(NSNode n, int pre) {
        int uriI = this.uri(Token.EMPTY, pre);
        this.uriStack.set(this.uriL, uriI);
        this.uriStack.set(this.uriL - 1, uriI);
        this.current = n;
    }

    void setRoot(NSNode n) {
        this.current = n;
    }

    public byte[] table(int s, int e) {
        if (this.root.size == 0) {
            return Token.EMPTY;
        }
        Table t = new Table();
        t.header.add(DataText.TABLEID);
        t.header.add(DataText.TABLEPRE);
        t.header.add(DataText.TABLEDIST);
        t.header.add(DataText.TABLEPREF);
        t.header.add(DataText.TABLEURI);
        for (int i = 0; i < 3; ++i) {
            t.align.add(true);
        }
        this.table(t, this.root, s, e);
        return t.contents.isEmpty() ? Token.EMPTY : t.finish();
    }

    private void table(Table t, NSNode n, int s, int e) {
        int i;
        for (i = 0; i < n.vals.length; i += 2) {
            if (n.pre < s || n.pre > e) continue;
            TokenList tl = new TokenList();
            tl.add(n.vals[i + 1]);
            tl.add(n.pre);
            tl.add(n.pre - n.par.pre);
            tl.add(this.pref.key(n.vals[i]));
            tl.add(this.uri.key(n.vals[i + 1]));
            t.contents.add(tl);
        }
        for (i = 0; i < n.size; ++i) {
            this.table(t, n.ch[i], s, e);
        }
    }

    public byte[] info() {
        TokenObjMap<TokenList> map = new TokenObjMap<TokenList>();
        this.info(map, this.root);
        TokenBuilder tb = new TokenBuilder();
        for (byte[] val : map.keys()) {
            tb.add("  ");
            TokenList key = map.get(val);
            key.sort(false);
            int ks = key.size();
            if (ks > 1 || key.get(0).length != 0) {
                if (key.size() != 1) {
                    tb.add("(");
                }
                for (int k = 0; k < ks; ++k) {
                    if (k != 0) {
                        tb.add(", ");
                    }
                    tb.add(key.get(k));
                }
                if (ks != 1) {
                    tb.add(")");
                }
                tb.add(" = ");
            }
            tb.addExt("\"%\"" + Text.NL, new Object[]{val});
        }
        return tb.finish();
    }

    private void info(TokenObjMap<TokenList> map, NSNode n) {
        for (int i = 0; i < n.vals.length; i += 2) {
            byte[] key = this.uri.key(n.vals[i + 1]);
            byte[] val = this.pref.key(n.vals[i]);
            TokenList old = map.get(key);
            if (old == null) {
                old = new TokenList();
                map.add(key, old);
            }
            if (old.contains(val)) continue;
            old.add(val);
        }
        for (NSNode c : n.ch) {
            this.info(map, c);
        }
    }

    public String toString(int s, int e) {
        return this.root.print(this, s, e);
    }

    public String toString() {
        return this.toString(0, Integer.MAX_VALUE);
    }
}

