/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.basex.core.AProp;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.core.parse.PasswordReader;
import org.basex.data.Data;
import org.basex.data.Namespaces;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.gui.AGUI;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIInput;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIProp;
import org.basex.gui.GUIStatus;
import org.basex.gui.GUIToolBar;
import org.basex.gui.dialog.DialogPass;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.view.ViewContainer;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.editor.EditorView;
import org.basex.gui.view.explore.ExploreView;
import org.basex.gui.view.folder.FolderView;
import org.basex.gui.view.info.InfoView;
import org.basex.gui.view.map.MapView;
import org.basex.gui.view.plot.PlotView;
import org.basex.gui.view.table.TableView;
import org.basex.gui.view.text.TextView;
import org.basex.gui.view.tree.TreeView;
import org.basex.io.IOUrl;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryException;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.Version;

public final class GUI
extends AGUI {
    public final ViewNotifier notify;
    public final GUIStatus status;
    public final GUIInput input;
    public final BaseXButton filter;
    public final EditorView editor;
    public final InfoView info;
    public boolean painting;
    public boolean updating;
    public boolean fullscreen;
    private final GUIMenu menu;
    public final BaseXBack buttons;
    public final BaseXBack nav;
    final ViewContainer views;
    final BaseXButton hist;
    final BaseXCombo mode;
    private final TextView text;
    private final BaseXBack top;
    private final BaseXButton go;
    private final BaseXBack control;
    private final BaseXLabel hits;
    private final GUIToolBar toolbar;
    private Command command;
    private int menuHeight;
    private JFrame fullscr;
    private int threadID;

    public GUI(Context ctx, GUIProp gprops) {
        super(ctx, gprops);
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int[] ps = this.gprop.nums(GUIProp.GUILOC);
        int[] sz = this.gprop.nums(GUIProp.GUISIZE);
        int x = Math.max(0, Math.min(scr.width - sz[0], ps[0]));
        int y = Math.max(0, Math.min(scr.height - sz[1], ps[1]));
        this.setBounds(x, y, sz[0], sz[1]);
        if (this.gprop.is(GUIProp.MAXSTATE)) {
            this.setExtendedState(2);
            this.setExtendedState(4);
            this.setExtendedState(6);
        }
        this.top = new BaseXBack(new BorderLayout());
        this.control = new BaseXBack(new BorderLayout());
        this.menu = new GUIMenu(this);
        this.setJMenuBar(this.menu);
        this.buttons = new BaseXBack(new BorderLayout());
        this.toolbar = new GUIToolBar(GUIConstants.TOOLBAR, this);
        this.buttons.add((Component)this.toolbar, "West");
        this.hits = new BaseXLabel(" ");
        this.hits.setFont(this.hits.getFont().deriveFont(18.0f));
        BaseXLayout.setWidth(this.hits, 150);
        this.hits.setHorizontalAlignment(4);
        BaseXBack b = new BaseXBack();
        b.add(this.hits);
        this.buttons.add((Component)b, "East");
        if (this.gprop.is(GUIProp.SHOWBUTTONS)) {
            this.control.add((Component)this.buttons, "Center");
        }
        this.nav = new BaseXBack(new BorderLayout(5, 0)).border(2, 2, 0, 2);
        this.mode = new BaseXCombo(this, Text.SEARCH, Text.XQUERY, Text.COMMAND);
        this.mode.setSelectedIndex(2);
        this.mode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int s = GUI.this.mode.getSelectedIndex();
                if (s == GUI.this.gprop.num(GUIProp.SEARCHMODE) || !GUI.this.mode.isEnabled()) {
                    return;
                }
                GUI.this.gprop.set(GUIProp.SEARCHMODE, s);
                GUI.this.input.setText("");
                GUI.this.refreshControls();
            }
        });
        this.nav.add((Component)this.mode, "West");
        this.input = new GUIInput(this);
        this.hist = new BaseXButton(this, "hist", Token.token(Text.H_SHOW_HISTORY));
        this.hist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] hs;
                final JPopupMenu pop = new JPopupMenu();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ac) {
                        GUI.this.input.setText(ac.getActionCommand());
                        GUI.this.input.requestFocusInWindow();
                        pop.setVisible(false);
                    }
                };
                int i = GUI.this.context.data() == null ? 2 : GUI.this.gprop.num(GUIProp.SEARCHMODE);
                for (String en : hs = GUI.this.gprop.strings(i == 0 ? GUIProp.SEARCH : (i == 1 ? GUIProp.XQUERY : GUIProp.COMMANDS))) {
                    JMenuItem jmi = new JMenuItem(en);
                    jmi.addActionListener(al);
                    pop.add(jmi);
                }
                pop.show(GUI.this.hist, 0, GUI.this.hist.getHeight());
            }
        });
        b = new BaseXBack(new BorderLayout(5, 0));
        b.add((Component)this.hist, "West");
        b.add((Component)this.input, "Center");
        this.nav.add((Component)b, "Center");
        this.go = new BaseXButton(this, "go", Token.token(Text.H_EXECUTE_QUERY));
        this.go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.execute();
            }
        });
        this.filter = BaseXButton.command(GUICommands.C_FILTER, this);
        b = new BaseXBack(new TableLayout(1, 3));
        b.add(this.go);
        b.add(Box.createHorizontalStrut(1));
        b.add(this.filter);
        this.nav.add((Component)b, "East");
        if (this.gprop.is(GUIProp.SHOWINPUT)) {
            this.control.add((Component)this.nav, "South");
        }
        this.top.add((Component)this.control, "North");
        this.notify = new ViewNotifier(this);
        this.text = new TextView(this.notify);
        this.editor = new EditorView(this.notify);
        this.info = new InfoView(this.notify);
        this.views = new ViewContainer(this, this.text, this.editor, this.info, new FolderView(this.notify), new PlotView(this.notify), new TableView(this.notify), new MapView(this.notify), new TreeView(this.notify), new ExploreView(this.notify));
        this.top.add((Component)this.views, "Center");
        this.setContentBorder();
        this.status = new GUIStatus(this);
        if (this.gprop.is(GUIProp.SHOWSTATUS)) {
            this.top.add((Component)this.status, "South");
        }
        this.setDefaultCloseOperation(2);
        this.add(this.top);
        this.setVisible(true);
        this.views.updateViews();
        this.refreshControls();
        new Thread(){

            @Override
            public void run() {
                GUI.this.views.run();
                GUI.this.checkVersion();
            }
        }.start();
        this.input.requestFocusInWindow();
    }

    @Override
    public void dispose() {
        if (!this.editor.confirm()) {
            return;
        }
        boolean max = this.getExtendedState() == 6;
        this.gprop.set(GUIProp.MAXSTATE, max);
        if (!max) {
            this.gprop.set(GUIProp.GUILOC, new int[]{this.getX(), this.getY()});
            this.gprop.set(GUIProp.GUISIZE, new int[]{this.getWidth(), this.getHeight()});
        }
        super.dispose();
        this.gprop.write();
        this.context.close();
    }

    void execute() {
        boolean cmd;
        String in = this.input.getText().trim();
        boolean bl = cmd = this.mode.getSelectedIndex() == 2;
        if (cmd || in.startsWith("!")) {
            int i;
            int n = i = cmd ? 0 : 1;
            if (i == in.length()) {
                return;
            }
            try {
                PasswordReader pr = new PasswordReader(){

                    @Override
                    public String password() {
                        DialogPass dp = new DialogPass();
                        return dp.ok() ? Token.md5(dp.pass()) : "";
                    }
                };
                CommandParser cp = new CommandParser(in.substring(i), this.context);
                cp.password(pr);
                this.execute(false, cp.parse());
            }
            catch (QueryException ex) {
                if (!this.info.visible()) {
                    GUICommands.C_SHOWINFO.execute(this);
                }
                this.info.setInfo(ex.getMessage(), null, null, false);
                this.info.reset();
            }
        } else if (this.gprop.num(GUIProp.SEARCHMODE) == 1 || in.startsWith("/")) {
            this.xquery(in, false);
        } else {
            String qu = Find.find(in, this.context, this.gprop.is(GUIProp.FILTERRT));
            this.execute(false, new XQuery(qu));
        }
    }

    public void xquery(String qu, boolean edit) {
        Namespaces ns = this.context.data().nspaces;
        String in = qu.trim().isEmpty() ? "()" : qu;
        int u = ns.uri(Token.EMPTY, 0);
        if (u != 0) {
            in = Util.info("declare default element namespace \"%\"; %", ns.uri(u), in);
        }
        this.execute(edit, new XQuery(in));
    }

    public void execute(Command cmd) {
        this.execute(false, cmd);
    }

    public void execute(final boolean edit, final Command ... cmd) {
        if (this.updating) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                for (Command c : cmd) {
                    if (!GUI.this.exec(c, edit)) break;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exec(Command cmd, boolean edit) {
        int thread = ++this.threadID;
        while (this.command != null) {
            this.command.stop();
            Performance.sleep(50L);
            if (this.threadID == thread) continue;
            return true;
        }
        this.cursor(GUIConstants.CURSORWAIT);
        boolean ok = true;
        try {
            Performance perf = new Performance();
            Data data = this.context.data();
            if (this.gprop.is(GUIProp.FILTERRT) && this.context.current() != null && !this.context.root()) {
                this.context.update();
            }
            Nodes current = this.context.current();
            this.command = cmd;
            ArrayOutput ao = new ArrayOutput().max(this.gprop.num(GUIProp.MAXTEXT));
            this.updating = cmd.updating(this.context);
            if (edit) {
                this.editor.start();
            } else if (this.editor.visible()) {
                this.editor.reset();
            }
            if (cmd.newData(this.context)) {
                this.notify.init();
            }
            String inf = null;
            try {
                cmd.execute(this.context, ao);
                inf = cmd.info();
            }
            catch (BaseXException ex) {
                ok = false;
                inf = ex.getMessage();
            }
            finally {
                this.updating = false;
            }
            String time = perf.getTime();
            if (this.info.visible()) {
                this.info.setInfo(inf, cmd, time, ok);
            }
            this.info.reset();
            boolean interrupted = inf.startsWith(Text.INTERRUPTED);
            if (edit) {
                this.editor.info(interrupted ? Text.INTERRUPTED : (ok ? "OK" : inf), ok || interrupted);
            }
            if (!ok && !interrupted) {
                if (!(edit && !inf.startsWith("Improper use? Potential bug? Your feedback is welcome:") || this.info.visible())) {
                    GUICommands.C_SHOWINFO.execute(this);
                }
            } else {
                Nodes nodes;
                Result result = cmd.result();
                Nodes nodes2 = nodes = result instanceof Nodes && result.size() != 0L ? (Nodes)result : null;
                if (this.context.data() != data) {
                    this.notify.init();
                } else if (cmd.updated()) {
                    this.notify.update();
                    if (nodes == null) {
                        nodes = this.context.current();
                    }
                } else if (result != null) {
                    Nodes nd = this.context.current();
                    Nodes marked = this.context.marked;
                    boolean flt = this.gprop.is(GUIProp.FILTERRT);
                    if (flt || nd != null && !nd.sameAs(current)) {
                        if (nodes != null) {
                            this.notify.context((Nodes)result, flt, null);
                        }
                    } else if (marked != null) {
                        if (nodes != null) {
                            marked = nodes;
                        } else if (marked.size() != 0L) {
                            marked = new Nodes(data);
                        }
                        this.notify.mark(marked, null);
                    }
                }
                if (thread == this.threadID && !interrupted) {
                    this.status.setText(Util.info(Text.TIME_NEEDED_X, time));
                    if (result != null) {
                        this.setResults(result.size());
                    }
                    if (nodes == null) {
                        if (!this.text.visible() && ao.size() != 0L) {
                            GUICommands.C_SHOWTEXT.execute(this);
                        }
                        this.text.setText(ao);
                    }
                    this.text.cacheText(ao, cmd, result);
                }
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
            BaseXDialog.error(this, Util.info(Text.EXEC_ERROR, cmd, !ex.toString().isEmpty() ? ex.toString() : ex.getMessage()));
            this.updating = false;
        }
        this.cursor(GUIConstants.CURSORARROW, true);
        this.command = null;
        return ok;
    }

    public void stop() {
        if (this.command != null) {
            this.command.stop();
        }
        this.cursor(GUIConstants.CURSORARROW, true);
        this.command = null;
    }

    public void set(Object[] pr, Object val) {
        this.set(this.context.prop, pr, val);
    }

    public void setMain(Object[] pr, Object val) {
        this.set(this.context.mprop, pr, val);
    }

    private void set(AProp prop, Object[] pr, Object val) {
        if (!prop.sameAs(pr, val)) {
            Set cmd = new Set(pr, val);
            cmd.run(this.context);
            this.info.setInfo(cmd.info(), cmd, null, true);
        }
    }

    private void setContentBorder() {
        int n = this.control.getComponentCount();
        int n2 = this.top.getComponentCount();
        if (n == 0 && n2 == 2) {
            this.views.border(0, 0, 0, 0);
        } else {
            this.views.setBorder(new CompoundBorder(new EmptyBorder(3, 1, 3, 1), new EtchedBorder()));
        }
    }

    public void updateLayout() {
        GUIConstants.init(this.gprop);
        this.notify.layout();
        this.views.repaint();
    }

    public void updateControl(JComponent comp, boolean show, String layout) {
        if (comp == this.status) {
            if (!show) {
                this.top.remove(comp);
            } else {
                this.top.add((Component)comp, layout);
            }
        } else if (comp == this.menu) {
            if (!show) {
                this.menuHeight = this.menu.getHeight();
            }
            int s = show ? this.menuHeight : 0;
            BaseXLayout.setHeight(this.menu, s);
            this.menu.setSize(this.menu.getWidth(), s);
        } else if (!show) {
            this.control.remove(comp);
        } else {
            this.control.add((Component)comp, layout);
        }
        this.setContentBorder();
        (this.fullscr == null ? this.getRootPane() : this.fullscr).validate();
        this.refreshControls();
    }

    public void layoutViews() {
        this.views.updateViews();
        this.refreshControls();
        this.repaint();
    }

    public void refreshControls() {
        int i;
        Nodes marked = this.context.marked;
        if (marked != null) {
            this.setResults(marked.size());
        }
        this.filter.setEnabled(marked != null && marked.size() != 0L);
        boolean inf = this.gprop.is(GUIProp.SHOWINFO);
        this.context.prop.set(Prop.QUERYINFO, inf);
        this.context.prop.set(Prop.XMLPLAN, inf);
        Data data = this.context.data();
        int t = this.mode.getSelectedIndex();
        int s = data == null ? 2 : this.gprop.num(GUIProp.SEARCHMODE);
        this.mode.setEnabled(data != null);
        this.go.setEnabled(s == 2 || !this.gprop.is(GUIProp.EXECRT));
        if (s != t) {
            this.mode.setSelectedIndex(s);
            this.input.setText("");
            this.input.requestFocusInWindow();
        }
        this.toolbar.refresh();
        this.menu.refresh();
        int n = i = this.context.data() == null ? 2 : this.gprop.num(GUIProp.SEARCHMODE);
        String[] hs = i == 0 ? this.gprop.strings(GUIProp.SEARCH) : (i == 1 ? this.gprop.strings(GUIProp.XQUERY) : this.gprop.strings(GUIProp.COMMANDS));
        this.hist.setEnabled(hs.length != 0);
    }

    private void setResults(long n) {
        int mh = this.context.prop.num(Prop.MAXHITS);
        if (mh < 0) {
            mh = Integer.MAX_VALUE;
        }
        this.hits.setText(Util.info(Text.RESULTS_X, (n >= (long)mh ? "\u2265" : "") + n));
    }

    public void fullscreen() {
        this.fullscreen ^= true;
        this.fullscreen(this.fullscreen);
    }

    public void fullscreen(boolean full) {
        if (full ^ this.fullscr == null) {
            return;
        }
        if (full) {
            this.control.remove(this.buttons);
            this.control.remove(this.nav);
            this.getRootPane().remove(this.menu);
            this.top.remove(this.status);
            this.remove(this.top);
            this.fullscr = new JFrame();
            this.fullscr.setIconImage(this.getIconImage());
            this.fullscr.setTitle(this.getTitle());
            this.fullscr.setUndecorated(true);
            this.fullscr.setJMenuBar(this.menu);
            this.fullscr.add(this.top);
            this.fullscr.setDefaultCloseOperation(2);
        } else {
            this.fullscr.removeAll();
            this.fullscr.dispose();
            this.fullscr = null;
            if (!this.gprop.is(GUIProp.SHOWBUTTONS)) {
                this.control.add((Component)this.buttons, "Center");
            }
            if (!this.gprop.is(GUIProp.SHOWINPUT)) {
                this.control.add((Component)this.nav, "South");
            }
            if (!this.gprop.is(GUIProp.SHOWSTATUS)) {
                this.top.add((Component)this.status, "South");
            }
            this.setJMenuBar(this.menu);
            this.add(this.top);
        }
        this.gprop.set(GUIProp.SHOWBUTTONS, !full);
        this.gprop.set(GUIProp.SHOWINPUT, !full);
        this.gprop.set(GUIProp.SHOWSTATUS, !full);
        this.fullscreen = full;
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this.fullscr);
        this.setContentBorder();
        this.refreshControls();
        this.updateControl(this.menu, !full, "North");
        this.setVisible(!full);
    }

    void checkVersion() {
        Version used;
        Version disk = new Version(this.gprop.get(GUIProp.UPDATEVERSION));
        if (disk.compareTo(used = new Version("7.3.1 beta".replaceAll(" .*", ""))) < 0) {
            this.gprop.set(GUIProp.UPDATEVERSION, used.toString());
        } else {
            try {
                String page = Token.string(new IOUrl(Text.VERSION_URL).read());
                Matcher m = Pattern.compile("^(Version )?([\\w\\d.]*?)( .*|$)", 32).matcher(page);
                if (m.matches()) {
                    Version latest = new Version(m.group(2));
                    if (disk.compareTo(latest) < 0 && BaseXDialog.confirm(this, Util.info(Text.H_NEW_VERSION, "BaseX", latest))) {
                        BaseXDialog.browse(this, Text.UPDATE_URL);
                    } else {
                        this.gprop.set(GUIProp.UPDATEVERSION, latest.toString());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

