/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.AbstractButton;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Cs;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.XQuery;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.DialogAbout;
import org.basex.gui.dialog.DialogColors;
import org.basex.gui.dialog.DialogEdit;
import org.basex.gui.dialog.DialogExport;
import org.basex.gui.dialog.DialogFonts;
import org.basex.gui.dialog.DialogInsert;
import org.basex.gui.dialog.DialogManage;
import org.basex.gui.dialog.DialogMapLayout;
import org.basex.gui.dialog.DialogNew;
import org.basex.gui.dialog.DialogPackages;
import org.basex.gui.dialog.DialogPrefs;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogProps;
import org.basex.gui.dialog.DialogServer;
import org.basex.gui.dialog.DialogTreeOptions;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.view.ViewData;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.func.Function;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public enum GUICommands implements GUICommand
{
    C_CREATE(Text.NEW + "...", "% N", Text.H_NEW, false, false){

        @Override
        public void execute(GUI gui) {
            DialogNew dialog = new DialogNew(gui);
            if (!dialog.ok()) {
                return;
            }
            String in = gui.gprop.get(GUIProp.CREATEPATH);
            String db = gui.gprop.get(GUIProp.CREATENAME);
            DialogProgress.execute(gui, new CreateDB(db, in.isEmpty() ? null : in));
        }
    }
    ,
    C_OPEN_MANAGE(Text.OPEN_MANAGE + "...", "% O", Text.H_OPEN_MANAGE, false, false){

        @Override
        public void execute(GUI gui) {
            if (new DialogManage(gui).nodb() && BaseXDialog.confirm(gui, Text.NEW_DB_QUESTION)) {
                C_CREATE.execute(gui);
            }
        }
    }
    ,
    C_INFO(Text.PROPERTIES + "...", "% D", Text.H_PROPERTIES, true, false){

        @Override
        public void execute(GUI gui) {
            new DialogProps(gui);
        }
    }
    ,
    C_EXPORT(Text.EXPORT + "...", "% shift E", Text.H_EXPORT, true, false){

        @Override
        public void execute(GUI gui) {
            DialogExport dialog = new DialogExport(gui);
            if (!dialog.ok()) {
                return;
            }
            IOFile root = new IOFile(dialog.path());
            if (root.exists()) {
                IO file = null;
                boolean overwrite = false;
                Data d = gui.context.data();
                IntList il = d.resources.docs();
                int is = il.size();
                for (int i = 0; i < is; ++i) {
                    file = root.merge(Token.string(d.text(il.get(i), true)));
                    if (!file.exists()) continue;
                    if (overwrite) {
                        file = null;
                        break;
                    }
                    overwrite = true;
                }
                if (overwrite) {
                    String msg;
                    String string = msg = file == null ? Text.FILES_REPLACE_X : Text.FILE_EXISTS_X;
                    if (file == null) {
                        file = root;
                    }
                    if (!BaseXDialog.confirm(gui, Util.info(msg, file))) {
                        return;
                    }
                }
            }
            DialogProgress.execute(gui, new Export(root.path()));
        }
    }
    ,
    C_CLOSE(Text.CLOSE, "% shift W", Text.H_CLOSE, true, false){

        @Override
        public void execute(GUI gui) {
            gui.execute(new Close());
        }
    }
    ,
    C_SERVER(Text.S_SERVER_ADMIN + "...", null, Text.S_H_SERVER_ADMIN, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogServer(gui);
        }
    }
    ,
    C_EDITNEW(Text.NEW + "...", "% T", Text.H_NEW_FILE, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.newFile();
        }
    }
    ,
    C_EDITOPEN(Text.OPEN + "...", "% R", Text.H_OPEN_FILE, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.open();
        }
    }
    ,
    C_EDITSAVE(Text.SAVE, "% S", Text.H_SAVE, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.save();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(gui.editor != null && gui.editor.saveable());
        }
    }
    ,
    C_EDITSAVEAS(Text.SAVE_AS + "...", "% shift S", Text.H_SAVE, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.saveAs();
        }
    }
    ,
    C_EDITCLOSE(Text.CLOSE, "% W", Text.H_CLOSE_FILE, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.close(null);
        }
    }
    ,
    C_EXIT(Text.EXIT, "% Q", Text.H_EXIT, false, false){

        @Override
        public void execute(GUI gui) {
            gui.dispose();
        }
    }
    ,
    C_COPYPATH(Text.COPY_PATH, "% shift C", Text.H_CPPATH, true, false){

        @Override
        public void execute(GUI gui) {
            int pre = gui.context.marked.pres[0];
            byte[] txt = ViewData.path(gui.context.data(), pre);
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new StringSelection(Token.string(txt)), null);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            Nodes marked = gui.context.marked;
            b.setEnabled(marked != null && marked.size() != 0L);
        }
    }
    ,
    C_COPY(Text.COPY, "", Text.H_COPY, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            Nodes n = ctx.marked;
            ctx.copied = new Nodes(n.pres, n.data);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(14.updatable(gui.context.marked, new int[0]));
        }
    }
    ,
    C_PASTE(Text.PASTE, "", Text.H_PASTE, true, false){

        @Override
        public void execute(GUI gui) {
            StringBuilder sb = new StringBuilder();
            Nodes n = gui.context.copied;
            int i = 0;
            while ((long)i < n.size()) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(15.openPre(n, i));
                ++i;
            }
            gui.context.copied = null;
            gui.execute(new XQuery("insert nodes (" + sb + ") into " + 15.openPre(gui.context.marked, 0)));
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            Context ctx = gui.context;
            b.setEnabled(15.updatable(ctx.marked, 0) && ctx.copied != null);
        }
    }
    ,
    C_DELETE(Text.DELETE + "...", "", Text.H_DELETE, true, false){

        @Override
        public void execute(GUI gui) {
            if (!BaseXDialog.confirm(gui, Text.DELETE_NODES)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            Nodes n = gui.context.marked;
            int i = 0;
            while ((long)i < n.size()) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(16.openPre(n, i));
                ++i;
            }
            gui.context.marked = new Nodes(n.data);
            gui.context.copied = null;
            gui.context.focused = -1;
            gui.execute(new XQuery("delete nodes (" + sb + ')'));
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(16.updatable(gui.context.marked, new int[0]));
        }
    }
    ,
    C_INSERT(Text.NEW + "...", "", Text.H_NEW_NODE, true, false){

        @Override
        public void execute(GUI gui) {
            Nodes n = gui.context.marked;
            DialogInsert insert = new DialogInsert(gui);
            if (!insert.ok()) {
                return;
            }
            StringList sl = insert.result;
            NodeType type = ANode.type(insert.kind);
            String item = Token.string(type.string()) + " { " + 17.quote(sl.get(0)) + " }";
            if (type == NodeType.ATT || type == NodeType.PI) {
                item = item + " { " + 17.quote(sl.get(1)) + " }";
            } else if (type == NodeType.ELM) {
                item = item + " { () }";
            }
            gui.context.copied = null;
            gui.execute(new XQuery("insert node " + item + " into " + 17.openPre(n, 0)));
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(17.updatable(gui.context.marked, 3, 5, 4, 2));
        }
    }
    ,
    C_EDIT(Text.EDIT + "...", "", Text.H_EDIT, true, false){

        @Override
        public void execute(GUI gui) {
            Nodes n = gui.context.marked;
            DialogEdit edit = new DialogEdit(gui, n.pres[0]);
            if (!edit.ok()) {
                return;
            }
            String rename = null;
            String replace = null;
            int k = edit.kind;
            if (k == 1 || k == 5 || k == 3) {
                rename = edit.result.get(0);
                if (k != 1) {
                    replace = edit.result.get(1);
                }
            } else {
                replace = edit.result.get(0);
            }
            if (rename != null) {
                gui.execute(new XQuery("rename node " + 18.openPre(n, 0) + " as " + 18.quote(rename)));
            }
            if (replace != null) {
                gui.execute(new XQuery("replace value of node " + 18.openPre(n, 0) + " with " + 18.quote(replace)));
            }
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(18.updatable(gui.context.marked, 0));
        }
    }
    ,
    C_FILTER(Text.FILTER_SELECTED, "", Text.H_FILTER_SELECTED, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            Nodes marked = ctx.marked;
            if (marked.size() == 0L) {
                int pre = gui.context.focused;
                if (pre == -1) {
                    return;
                }
                marked = new Nodes(pre, ctx.data());
            }
            gui.notify.context(marked, false, null);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            Nodes marked = gui.context.marked;
            b.setEnabled(marked != null && marked.size() != 0L);
        }
    }
    ,
    C_SHOWEDITOR(Text.EDITOR, "% E", Text.H_EDITOR, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWEDITOR);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWEDITOR));
        }
    }
    ,
    C_SHOWINFO(Text.QUERY_INFO, "% I", Text.H_QUERY_INFO, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWINFO);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWINFO));
        }
    }
    ,
    C_PACKAGES(Text.PACKAGES + "...", null, Text.H_PACKAGES, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogPackages(gui);
        }
    }
    ,
    C_SHOWBUTTONS(Text.BUTTONS, null, Text.H_BUTTONS, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWBUTTONS);
            gui.updateControl(gui.buttons, gui.gprop.is(GUIProp.SHOWBUTTONS), "Center");
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWBUTTONS));
        }
    }
    ,
    C_SHOWINPUT(Text.INPUT_BAR, null, Text.H_INPUT_BAR, false, true){

        @Override
        public void execute(GUI gui) {
            gui.updateControl(gui.nav, gui.gprop.invert(GUIProp.SHOWINPUT), "South");
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWINPUT));
        }
    }
    ,
    C_SHOWSTATUS(Text.STATUS_BAR, null, Text.H_STATUS_BAR, false, true){

        @Override
        public void execute(GUI gui) {
            gui.updateControl(gui.status, gui.gprop.invert(GUIProp.SHOWSTATUS), "South");
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWSTATUS));
        }
    }
    ,
    C_SHOWTEXT(Text.TEXT, "% 1", Text.H_TEXT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWTEXT);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWTEXT));
        }
    }
    ,
    C_SHOWMAP(Text.MAP, "% 2", Text.H_MAP, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWMAP);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWMAP));
        }
    }
    ,
    C_SHOWTREE(Text.TREE, "% 3", Text.H_TREE, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWTREE);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWTREE));
        }
    }
    ,
    C_SHOWFOLDER(Text.FOLDER, "% 4", Text.H_FOLDER, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWFOLDER);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWFOLDER));
        }
    }
    ,
    C_SHOWPLOT(Text.PLOT, "% 5", Text.H_PLOT, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWPLOT);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWPLOT));
        }
    }
    ,
    C_SHOWTABLE(Text.TABLE, "% 6", Text.H_TABLE, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWTABLE);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWTABLE));
        }
    }
    ,
    C_SHOWEXPLORE(Text.EXPLORER, "% 7", Text.H_EXPLORER, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWEXPLORE);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWEXPLORE));
        }
    }
    ,
    C_FULL(Text.FULLSCREEN, Prop.MAC ? "% shift F" : "F11", Text.H_FULLSCREEN, false, true){

        @Override
        public void execute(GUI gui) {
            gui.fullscreen();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.fullscreen);
        }
    }
    ,
    C_RTEXEC(Text.RT_EXECUCTION, null, Text.H_RT_EXECUTION, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.EXECRT);
            gui.refreshControls();
            gui.stop();
            gui.notify.layout();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.EXECRT));
        }
    }
    ,
    C_RTFILTER(Text.RT_FILTERING, null, Text.H_RT_FILTERING, true, true){

        @Override
        public void execute(GUI gui) {
            boolean rt = gui.gprop.invert(GUIProp.FILTERRT);
            gui.stop();
            gui.refreshControls();
            gui.notify.layout();
            Context ctx = gui.context;
            boolean root = ctx.root();
            if (!rt) {
                if (!root) {
                    gui.notify.context(new Nodes(0, ctx.data()), true, null);
                    gui.notify.mark(ctx.current(), null);
                }
            } else if (root) {
                gui.notify.mark(new Nodes(ctx.data()), null);
            } else {
                Nodes mark = ctx.marked;
                ctx.marked = new Nodes(ctx.data());
                gui.notify.context(mark, true, null);
            }
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.FILTERRT));
        }
    }
    ,
    C_COLOR(Text.COLORS + "...", null, Text.H_COLORS, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogColors(gui);
        }
    }
    ,
    C_FONTS(Text.FONTS_D, null, Text.H_FONTS, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogFonts(gui);
        }
    }
    ,
    C_MAPLAYOUT(Text.MAP_LAYOUT_D, null, Text.H_MAP_LAYOUT, true, false){

        @Override
        public void execute(GUI gui) {
            new DialogMapLayout(gui);
        }
    }
    ,
    C_TREEOPTIONS(Text.TREE_OPTIONS_D, null, Text.H_TREE_OPTIONS, true, false){

        @Override
        public void execute(GUI gui) {
            new DialogTreeOptions(gui);
        }
    }
    ,
    C_PREFS(Text.PREFERENCES + "...", Prop.MAC ? "% COMMA" : "% P", Text.H_PREFERENCES, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogPrefs(gui);
        }
    }
    ,
    C_HELP(Text.HELP, "F1", Text.H_HELP, false, false){

        @Override
        public void execute(GUI gui) {
            BaseXDialog.browse(gui, Text.DOC_URL);
        }
    }
    ,
    C_COMMUNITY(Text.COMMUNITY, null, Text.H_COMMUNITY, false, false){

        @Override
        public void execute(GUI gui) {
            BaseXDialog.browse(gui, Text.COMMUNITY_URL);
        }
    }
    ,
    C_UPDATES(Text.CHECK_FOR_UPDATES, null, Text.H_UPDATES, false, false){

        @Override
        public void execute(GUI gui) {
            BaseXDialog.browse(gui, Text.UPDATE_URL);
        }
    }
    ,
    C_ABOUT(Text.ABOUT + "...", null, Text.H_ABOUT, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogAbout(gui);
        }
    }
    ,
    C_GOBACK(Text.GO_BACK, "alt LEFT", Text.GO_BACK, true, false){

        @Override
        public void execute(GUI gui) {
            gui.notify.hist(false);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            String tt = gui.notify.tooltip(true);
            b.setEnabled(tt != null);
            b.setToolTipText(tt != null && tt.isEmpty() ? Text.GO_BACK : tt);
        }
    }
    ,
    C_GOFORWARD(Text.GO_FORWARD, "alt RIGHT", Text.GO_FORWARD, true, false){

        @Override
        public void execute(GUI gui) {
            gui.notify.hist(true);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            String tt = gui.notify.tooltip(false);
            b.setEnabled(tt != null);
            b.setToolTipText(tt != null && tt.isEmpty() ? Text.GO_FORWARD : tt);
        }
    }
    ,
    C_GOUP(Text.GO_UP, "alt UP", Text.H_GO_UP, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            if (ctx.root()) {
                return;
            }
            boolean doc = true;
            Data data = ctx.data();
            for (int pre : ctx.current().pres) {
                doc &= data.kind(pre) == 0;
            }
            if (doc) {
                ctx.update();
                gui.notify.context(ctx.current(), false, null);
            } else {
                gui.execute(new Cs(".."));
            }
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(!gui.gprop.is(GUIProp.FILTERRT) && gui.context.data() != null && !gui.context.root());
        }
    }
    ,
    C_GOHOME(Text.GO_HOME, "alt HOME", Text.H_GO_HOME, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            if (ctx.root()) {
                return;
            }
            ctx.update();
            gui.notify.context(ctx.current(), false, null);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(gui.context.data() != null && !gui.context.root());
        }
    }
    ,
    C_HOME(Text.GO_HOME, null, Text.H_GO_HOME, true, false){

        @Override
        public void execute(GUI gui) {
            gui.execute(new XQuery("/"));
        }
    };

    private final boolean data;
    private final String label;
    private final String key;
    private final String help;
    private final boolean checked;

    private GUICommands(String l, String k, String h, boolean d, boolean c) {
        this.label = l;
        this.key = k;
        this.help = h;
        this.data = d;
        this.checked = c;
    }

    @Override
    public void refresh(GUI gui, AbstractButton b) {
        b.setEnabled(!this.data || gui.context.data() != null);
    }

    @Override
    public final boolean checked() {
        return this.checked;
    }

    @Override
    public String help() {
        return this.help;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public String key() {
        return this.key;
    }

    static boolean updatable(Nodes n, int ... no) {
        if (n == null || (no.length == 0 ? n.size() < 1L : n.size() != 1L)) {
            return false;
        }
        int k = n.data.kind(n.pres[0]);
        for (int i : no) {
            if (k != i) continue;
            return false;
        }
        return true;
    }

    static String quote(String s) {
        return '\"' + s.replaceAll("\"", "&quot;") + '\"';
    }

    static String openPre(Nodes n, int i) {
        return Function._DB_OPEN_PRE.get(Str.get(n.data.meta.name), Int.get(n.pres[i])).toString();
    }
}

