/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUICommand;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXLayout;

public final class GUIConstants {
    public static final String MAPVIEW = "map";
    public static final String FOLDERVIEW = "folder";
    public static final String TEXTVIEW = "text";
    public static final String TABLEVIEW = "table";
    public static final String INFOVIEW = "info";
    public static final String EXPLOREVIEW = "explore";
    public static final String PLOTVIEW = "plot";
    public static final String TREEVIEW = "tree";
    public static final String EDITORVIEW = "editor";
    public static final String VIEWS = "V H editor folder map plot  - H text info table tree explore - -";
    static final GUICommands[] TOOLBAR = new GUICommands[]{GUICommands.C_CREATE, GUICommands.C_OPEN_MANAGE, GUICommands.C_INFO, GUICommands.C_CLOSE, null, GUICommands.C_GOHOME, GUICommands.C_GOBACK, GUICommands.C_GOUP, GUICommands.C_GOFORWARD, null, GUICommands.C_SHOWEDITOR, GUICommands.C_SHOWINFO, null, GUICommands.C_SHOWTEXT, GUICommands.C_SHOWMAP, GUICommands.C_SHOWTREE, GUICommands.C_SHOWFOLDER, GUICommands.C_SHOWPLOT, GUICommands.C_SHOWTABLE, GUICommands.C_SHOWEXPLORE};
    static final String[] MENUBAR = new String[]{Text.DATABASE, Text.EDITOR, Text.VIEW, Text.NODES, Text.OPTIONS, Text.HELP};
    static final GUICommand[][] MENUITEMS = new GUICommand[][]{{GUICommands.C_CREATE, GUICommands.C_OPEN_MANAGE, GUICommands.EMPTY, GUICommands.C_INFO, GUICommands.C_EXPORT, GUICommands.C_CLOSE, GUICommands.EMPTY, GUICommands.C_SERVER, Prop.MAC ? null : GUICommands.EMPTY, Prop.MAC ? null : GUICommands.C_EXIT}, {GUICommands.C_EDITNEW, GUICommands.C_EDITOPEN, GUICommands.C_EDITSAVE, GUICommands.C_EDITSAVEAS, GUICommands.C_EDITCLOSE, GUICommands.EMPTY, GUICommands.C_SHOWEDITOR, GUICommands.C_SHOWINFO}, {GUICommands.C_SHOWBUTTONS, GUICommands.C_SHOWINPUT, GUICommands.C_SHOWSTATUS, GUICommands.EMPTY, GUICommands.C_SHOWTEXT, GUICommands.C_SHOWMAP, GUICommands.C_SHOWTREE, GUICommands.C_SHOWFOLDER, GUICommands.C_SHOWPLOT, GUICommands.C_SHOWTABLE, GUICommands.C_SHOWEXPLORE, GUICommands.EMPTY, GUICommands.C_FULL}, {GUICommands.C_COPY, GUICommands.C_PASTE, GUICommands.C_DELETE, GUICommands.C_INSERT, GUICommands.C_EDIT, GUICommands.EMPTY, GUICommands.C_COPYPATH, GUICommands.C_FILTER}, {GUICommands.C_RTEXEC, GUICommands.C_RTFILTER, GUICommands.EMPTY, GUICommands.C_COLOR, GUICommands.C_FONTS, GUICommands.C_MAPLAYOUT, GUICommands.C_TREEOPTIONS, Prop.MAC ? null : GUICommands.EMPTY, GUICommands.C_PACKAGES, Prop.MAC ? null : GUICommands.C_PREFS}, {GUICommands.C_HELP, Prop.MAC ? null : GUICommands.EMPTY, GUICommands.C_COMMUNITY, GUICommands.C_UPDATES, Prop.MAC ? null : GUICommands.EMPTY, Prop.MAC ? null : GUICommands.C_ABOUT}};
    public static final GUICommands[] POPUP = new GUICommands[]{GUICommands.C_GOBACK, GUICommands.C_FILTER, null, GUICommands.C_COPY, GUICommands.C_PASTE, GUICommands.C_DELETE, GUICommands.C_INSERT, GUICommands.C_EDIT, null, GUICommands.C_COPYPATH};
    public static final Cursor CURSORARROW = new Cursor(0);
    public static final Cursor CURSORHAND = new Cursor(12);
    public static final Cursor CURSORWAIT = new Cursor(3);
    public static final Cursor CURSORMOVEH = new Cursor(11);
    public static final Cursor CURSORMOVEV = new Cursor(8);
    public static final Cursor CURSORTEXT = new Cursor(2);
    public static final Cursor CURSORMOVE = new Cursor(13);
    public static final Color LGRAY = new Color(224, 224, 224);
    public static final Color GRAY = new Color(160, 160, 160);
    public static final Color DGRAY = new Color(64, 64, 64);
    public static final Color WHITE = Color.white;
    public static final Color RED = new Color(208, 0, 0);
    public static final Color LRED = new Color(255, 208, 200);
    public static final Color GREEN = new Color(0, 176, 0);
    public static final Color BLUE = new Color(0, 64, 192);
    public static final Color LBLUE = new Color(128, 160, 224);
    public static final Color PINK = new Color(160, 0, 160);
    public static Color color1;
    public static Color color2;
    public static Color color3;
    public static Color color4;
    public static Color colormark1;
    public static Color colormark2;
    public static Color colormark3;
    public static Color colormark4;
    public static Color color1A;
    public static Color color2A;
    public static Color color3A;
    public static Color colormark1A;
    public static Color colormark2A;
    private static final Color[] COLORS;
    public static Font dfont;
    public static Font lfont;
    public static Font font;
    public static Font bfont;
    public static Font mfont;
    private static int[] dwidth;
    private static int[] lwidth;
    private static int[] fwidth;
    private static int[] bwidth;
    public static int[] mfwidth;
    public static final int SHF = 1;
    public static final int ALT = 8;
    public static final int CTRL = 2;
    public static final int SC;

    private GUIConstants() {
    }

    public static void init(GUIProp prop) {
        int r = prop.num(GUIProp.COLORRED);
        int g = prop.num(GUIProp.COLORGREEN);
        int b = prop.num(GUIProp.COLORBLUE);
        color1 = new Color(GUIConstants.col(r, 24), GUIConstants.col(g, 25), GUIConstants.col(b, 40));
        color2 = new Color(GUIConstants.col(r, 32), GUIConstants.col(g, 32), GUIConstants.col(b, 44));
        color3 = new Color(GUIConstants.col(r, 48), GUIConstants.col(g, 50), GUIConstants.col(b, 40));
        color4 = new Color(GUIConstants.col(r, 140), GUIConstants.col(g, 100), GUIConstants.col(b, 70));
        color1A = new Color(GUIConstants.col(r, 110), GUIConstants.col(g, 150), GUIConstants.col(b, 160), 100);
        colormark1A = new Color(GUIConstants.col(r, 32), GUIConstants.col(g, 160), GUIConstants.col(b, 320), 100);
        colormark2A = new Color(GUIConstants.col(r, 16), GUIConstants.col(g, 80), GUIConstants.col(b, 160), 100);
        colormark1 = new Color(GUIConstants.col(r, 16), GUIConstants.col(g, 120), GUIConstants.col(b, 240));
        colormark2 = new Color(GUIConstants.col(r, 16), GUIConstants.col(g, 80), GUIConstants.col(b, 160));
        colormark3 = new Color(GUIConstants.col(r, 32), GUIConstants.col(g, 160), GUIConstants.col(b, 320));
        colormark4 = new Color(GUIConstants.col(r, 1), GUIConstants.col(g, 40), GUIConstants.col(b, 80));
        for (int l = 1; l < COLORS.length + 1; ++l) {
            GUIConstants.COLORS[l - 1] = new Color(Math.max(255 - l * r, 0), Math.max(255 - l * g, 0), Math.max(255 - l * b, 0));
        }
        Color c = COLORS[16];
        color2A = new Color(c.getRed(), c.getGreen(), c.getBlue(), 40);
        color3A = new Color(c.getRed(), c.getGreen(), c.getBlue(), 100);
        String f = prop.get(GUIProp.FONT);
        int type = prop.num(GUIProp.FONTTYPE);
        int size = prop.num(GUIProp.FONTSIZE);
        font = new Font(f, type, size);
        mfont = new Font(prop.get(GUIProp.MONOFONT), type, size);
        bfont = new Font(f, 1, size);
        lfont = new Font(f, type, size + 10);
        dfont = new Font(prop.get(GUIProp.MONOFONT), 0, UIManager.getFont("TextArea.font").getSize() - 1);
        Container comp = new Container();
        dwidth = comp.getFontMetrics(dfont).getWidths();
        fwidth = comp.getFontMetrics(font).getWidths();
        lwidth = comp.getFontMetrics(lfont).getWidths();
        mfwidth = comp.getFontMetrics(mfont).getWidths();
        bwidth = comp.getFontMetrics(bfont).getWidths();
    }

    public static Color color(int i) {
        return COLORS[Math.min(COLORS.length - 1, i)];
    }

    public static int[] fontWidths(Font f) {
        if (f == font) {
            return fwidth;
        }
        if (f == mfont) {
            return mfwidth;
        }
        if (f == bfont) {
            return bwidth;
        }
        if (f == lfont) {
            return lwidth;
        }
        if (f == dfont) {
            return dwidth;
        }
        return new Container().getFontMetrics(f).getWidths();
    }

    private static int col(int c, int f) {
        return Math.max(0, 255 - c * f / 10);
    }

    static {
        COLORS = new Color[100];
        SC = Prop.MAC ? 4 : 2;
    }

    public static enum Fill {
        PLAIN,
        NONE,
        GRADIENT;

    }

    public static enum Msg {
        WARN("warn", "warning"),
        ERROR("error", "error"),
        SUCCESS("ok", "information"),
        QUESTION("warn", "question"),
        YESNOCANCEL("warn", "question");

        public final Icon small;
        public final Icon large;

        private Msg(String s, String l) {
            this.small = BaseXLayout.icon(s);
            this.large = UIManager.getIcon("OptionPane." + l + "Icon");
        }
    }
}

