/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.RepoDelete;
import org.basex.core.cmd.RepoInstall;
import org.basex.gui.GUI;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXList;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.RepoManager;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.StringList;

public final class DialogPackages
extends BaseXDialog {
    private final BaseXList packages;
    private final BaseXLabel title;
    private final BaseXButton install;
    private final BaseXButton delete;
    private final BaseXLabel name;
    private final BaseXLabel version;
    private final BaseXLabel type;
    private final BaseXLabel path;
    private boolean refresh;

    public DialogPackages(GUI main) {
        super(main, Text.PACKAGES);
        this.panel.setLayout(new BorderLayout(8, 0));
        this.packages = new BaseXList(new String[0], this, false);
        this.packages.setSize(270, 220);
        this.title = new BaseXLabel(" ").large().border(0, 5, 5, 0);
        this.name = new BaseXLabel(" ");
        this.version = new BaseXLabel(" ");
        this.type = new BaseXLabel(" ");
        this.path = new BaseXLabel(" ");
        BaseXBack table = new BaseXBack(new TableLayout(4, 2, 16, 0)).border(5);
        table.add(new BaseXLabel(Text.NAME + ":", false, true));
        table.add(this.name);
        table.add(new BaseXLabel(Text.VERSINFO + ":", false, true));
        table.add(this.version);
        table.add(new BaseXLabel(Text.TYPE + ":", false, true));
        table.add(this.type);
        table.add(new BaseXLabel(Text.PATH + ":", false, true));
        table.add(this.path);
        this.install = new BaseXButton(Text.INSTALL + "...", this);
        this.delete = new BaseXButton(Text.DELETE + "...", this);
        BaseXBack p = new BaseXBack(new BorderLayout());
        p.add((Component)this.title, "North");
        p.add((Component)table, "Center");
        p.add((Component)this.newButtons(this.install, this.delete), "South");
        BaseXLayout.setWidth(p, 430);
        this.set(this.packages, "Center");
        this.set(p, "East");
        this.refresh = true;
        this.action(null);
        this.finish(null);
    }

    @Override
    public void action(Object cmp) {
        Context ctx = this.gui.context;
        if (this.refresh) {
            this.packages.setData(new RepoManager(ctx).list().toArray());
            this.packages.requestFocusInWindow();
            this.refresh = false;
        }
        StringList pkgs = this.packages.getValues();
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (cmp == this.install) {
            String pp = this.gui.gprop.get(GUIProp.PKGPATH);
            BaseXFileChooser fc = new BaseXFileChooser(Text.FILE_OR_DIR, pp, this.gui);
            fc.addFilter("XML Archives", ".xar");
            fc.addFilter("Java Archives", ".jar");
            fc.addFilter("XQuery Files", IO.XQSUFFIXES);
            IOFile file = fc.select(BaseXFileChooser.Mode.FDOPEN);
            if (file == null) {
                return;
            }
            this.gui.gprop.set(GUIProp.PKGPATH, file.path());
            this.refresh = true;
            cmds.add(new RepoInstall(file.path(), null));
        } else if (cmp == this.delete) {
            if (!BaseXDialog.confirm(this.gui, Util.info(Text.DELETE_PACKAGES_X, pkgs.size()))) {
                return;
            }
            this.refresh = true;
            for (String p : pkgs) {
                cmds.add(new RepoDelete(p, null));
            }
        } else {
            byte[] key = Token.token(this.packages.getValue());
            TokenMap pkg = ctx.repo.pkgDict();
            if (pkg.get(key) != null) {
                this.title.setText(key.length == 0 ? "..." : Token.string(key));
                this.name.setText(Token.string(Package.name(key)));
                this.version.setText(Token.string(Package.version(key)));
                this.type.setText("EXPath");
                this.path.setText(Token.string(pkg.get(key)));
            } else {
                IOFile file = RepoManager.file(key, ctx.repo);
                String pp = Token.string(key);
                this.title.setText(key.length == 0 ? "..." : pp);
                this.name.setText(file != null ? file.name() : "-");
                this.version.setText("-");
                this.type.setText("Internal");
                this.path.setText(pp.replace('.', '/'));
            }
            this.delete.setEnabled(pkgs.size() > 0);
        }
        if (!cmds.isEmpty()) {
            DialogProgress.execute((BaseXDialog)this, cmds.toArray(new Command[cmds.size()]));
        }
    }
}

