/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.basex.core.Text;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Rename;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogInput;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogProps;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXTree;
import org.basex.gui.layout.TreeFolder;
import org.basex.gui.layout.TreeLeaf;
import org.basex.gui.layout.TreeNode;
import org.basex.gui.layout.TreeRootFolder;
import org.basex.util.Token;

public class DialogResources
extends BaseXBack {
    final BaseXTextField filterText;
    final TreeFolder root;
    final BaseXDialog dialog;
    final BaseXTree tree;
    final BaseXButton filter;
    final BaseXButton clear;

    DialogResources(final DialogProps dp) {
        this.setLayout(new BorderLayout(0, 5));
        this.dialog = dp;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.tree = new BaseXTree(rootNode, dp).border(4, 4, 4, 4);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        ImageIcon xml = BaseXLayout.icon("file_xml");
        ImageIcon raw = BaseXLayout.icon("file_raw");
        this.tree.setCellRenderer(new TreeNodeRenderer((Icon)xml, raw));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeNode n = (TreeNode)e.getPath().getLastPathComponent();
                String filt = n.equals(DialogResources.this.root) ? "" : n.path();
                String trgt = filt + '/';
                if (n.isLeaf()) {
                    n = (TreeNode)n.getParent();
                    trgt = (n == null || n.equals(DialogResources.this.root) ? "" : n.path()) + '/';
                } else {
                    filt = trgt;
                }
                DialogResources.this.filterText.setText(filt);
                dp.add.target.setText(trgt);
            }
        });
        Data data = dp.gui.context.data();
        String label = data.meta.name + " (/)";
        this.root = new TreeRootFolder(Token.token(label), Token.token("/"), this.tree, data);
        ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(this.root, rootNode, 0);
        this.filter = new BaseXButton(Text.FILTER, dp);
        this.clear = new BaseXButton(Text.CLEAR, dp);
        this.filter.setEnabled(false);
        this.clear.setEnabled(false);
        new BaseXPopup(this.tree, dp.gui, new DeleteCmd(), new RenameCmd());
        BaseXBack buttons = new BaseXBack();
        buttons.add(this.filter);
        buttons.add(this.clear);
        BaseXBack btn = new BaseXBack().layout(new BorderLayout());
        btn.add((Component)buttons, "East");
        this.filterText = new BaseXTextField(Text.PLEASE_WAIT_D, dp);
        this.filterText.setEnabled(false);
        BaseXLayout.setWidth(this.filterText, 250);
        BaseXBack panel = new BaseXBack(new BorderLayout());
        panel.add((Component)this.filterText, "Center");
        panel.add((Component)btn, "South");
        JScrollPane sp = new JScrollPane(this.tree);
        BaseXLayout.setWidth(sp, 250);
        this.add((Component)sp, "Center");
        this.add((Component)panel, "South");
        new Thread(){

            @Override
            public void run() {
                DialogResources.this.tree.setCursor(GUIConstants.CURSORWAIT);
                DialogResources.this.tree.expandPath(new TreePath(DialogResources.this.root.getPath()));
                DialogResources.this.filterText.setText("/");
                DialogResources.this.filterText.setEnabled(true);
                DialogResources.this.tree.setCursor(GUIConstants.CURSORARROW);
                DialogResources.this.filter.setEnabled(true);
                DialogResources.this.clear.setEnabled(true);
            }
        }.start();
    }

    TreeNode selection() {
        TreePath t = this.tree.getSelectionPath();
        return t == null ? null : (TreeNode)t.getLastPathComponent();
    }

    private void refreshFolder(TreeFolder n) {
        if (n == null) {
            return;
        }
        n.removeChildren();
        TreePath path = new TreePath(n.getPath());
        this.tree.collapsePath(path);
        this.tree.expandPath(path);
    }

    void action(Object comp) {
        if (comp == this.filter) {
            this.filter();
        } else if (comp == this.clear) {
            this.filterText.setText("/");
            this.filterText.requestFocus();
            this.refreshFolder(this.root);
        }
    }

    private void filter() {
        TreeLeaf[] leaves;
        byte[] path = TreeNode.preparePath(Token.token(this.filterText.getText()));
        if (Token.eq(path, Token.SLASH)) {
            this.refreshFolder(this.root);
            return;
        }
        Data data = this.dialog.gui.context.data();
        this.root.removeAllChildren();
        if (data.resources.isDir(path)) {
            this.root.add(new TreeFolder(TreeFolder.name(path), TreeFolder.path(path), this.tree, data));
        }
        byte[] name = TreeFolder.name(path);
        byte[] sub = TreeFolder.path(path);
        for (TreeLeaf l : leaves = TreeFolder.leaves(new TreeFolder(TreeFolder.name(sub), TreeFolder.path(sub), this.tree, data))) {
            if (name.length != 0 && !Token.eq(l.name, name)) continue;
            this.root.add(l);
        }
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.root);
    }

    void refreshNewFolder(String p) {
        byte[][] pathComp = Token.split(Token.token(p), 47);
        TreeNode n = this.root;
        block0: for (byte[] c : pathComp) {
            if (n instanceof TreeFolder) {
                ((TreeFolder)n).reload();
            }
            for (int i = 0; i < n.getChildCount(); ++i) {
                TreeNode ch = (TreeNode)n.getChildAt(i);
                if (!Token.eq(ch.name, c)) continue;
                n = ch;
                continue block0;
            }
        }
        this.refreshFolder((TreeFolder)(n instanceof TreeFolder ? n : (TreeFolder)n.getParent()));
    }

    final class RenameCmd
    extends BaseCmd {
        RenameCmd() {
        }

        @Override
        public void execute(GUI g) {
            TreeNode n = DialogResources.this.selection();
            if (n == null) {
                return;
            }
            DialogInput d = new DialogInput(n.path(), Text.RENAME, DialogResources.this.dialog, 0);
            if (!d.ok()) {
                return;
            }
            final String p = Token.string(TreeNode.preparePath(Token.token(d.input())));
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    DialogResources.this.refreshNewFolder(p);
                }
            };
            DialogProgress.execute(DialogResources.this.dialog, run, new Rename(n.path(), p));
        }

        @Override
        public String label() {
            return Text.RENAME + "...";
        }

        @Override
        public void refresh(GUI gui, AbstractButton button) {
            TreeNode n = DialogResources.this.selection();
            button.setEnabled(n != null && !n.equals(DialogResources.this.root));
        }
    }

    final class DeleteCmd
    extends BaseCmd {
        DeleteCmd() {
        }

        @Override
        public void execute(GUI g) {
            final TreeNode n = DialogResources.this.selection();
            if (n == null || !BaseXDialog.confirm(DialogResources.this.dialog.gui, Text.DELETE_NODES)) {
                return;
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    DialogResources.this.refreshNewFolder(n.path());
                }
            };
            DialogProgress.execute(DialogResources.this.dialog, run, new Delete(n.path()));
        }

        @Override
        public String label() {
            return Text.DELETE + "...";
        }

        @Override
        public void refresh(GUI gui, AbstractButton button) {
            TreeNode n = DialogResources.this.selection();
            button.setEnabled(n != null && !n.equals(DialogResources.this.root));
        }
    }

    static abstract class BaseCmd
    implements GUICommand {
        BaseCmd() {
        }

        @Override
        public boolean checked() {
            return false;
        }

        @Override
        public String help() {
            return null;
        }

        @Override
        public String key() {
            return null;
        }
    }

    private static final class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private final Icon xmlIcon;
        private final Icon rawIcon;

        TreeNodeRenderer(Icon xml, Icon raw) {
            this.xmlIcon = xml;
            this.rawIcon = raw;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object val, boolean sel, boolean exp, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, val, sel, exp, leaf, row, focus);
            if (leaf) {
                this.setIcon(((TreeLeaf)val).raw ? this.rawIcon : this.xmlIcon);
            }
            return this;
        }
    }
}

