/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;

public final class BaseXDSlider
extends BaseXPanel {
    private static final int ARROW = 17;
    public static final int LABELW = 300;
    public final double totMin;
    public final double totMax;
    public double min;
    public double max;
    public boolean itr;
    private final ActionListener listener;
    private double oldMin;
    private double oldMax;
    private int mouX;
    private boolean left;
    private boolean right;
    private boolean center;
    private final boolean log;

    public BaseXDSlider(double mn, double mx, Window main, ActionListener list) {
        super(main);
        this.listener = list;
        this.totMin = mn;
        this.totMax = mx;
        this.min = mn;
        this.max = mx;
        this.log = Math.log(this.totMax) - Math.log(this.totMin) > 5.0 && this.totMax - this.totMin > 100.0;
        this.mode(GUIConstants.Fill.NONE).setFocusable(true);
        BaseXLayout.setHeight(this, this.getFont().getSize() + 9);
        BaseXLayout.setWidth(this, 500);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseXDSlider.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BaseXDSlider.this.repaint();
            }
        });
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setToolTip();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouX = e.getX();
        Range r = new Range(this);
        this.left = this.mouX >= r.xs && this.mouX <= r.xs + 17;
        this.right = this.mouX >= r.xe && this.mouX <= r.xe + 17;
        this.center = this.mouX + 17 > r.xs && this.mouX < r.xe;
        this.oldMin = this.encode(this.min);
        this.oldMax = this.encode(this.max);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!(this.left || this.right || this.center)) {
            return;
        }
        Range r = new Range(this);
        double prop = r.dist * (double)(this.mouX - e.getX()) / (double)r.w;
        if (this.left) {
            this.min = BaseXDSlider.limit(this.totMin, this.max, this.decode(this.oldMin - prop) - 1.0);
        } else if (this.right) {
            this.max = BaseXDSlider.limit(this.min, this.totMax, this.decode(this.oldMax - prop) - 1.0);
        } else {
            this.min = BaseXDSlider.limit(this.totMin, this.totMax, this.decode(this.oldMin - prop) - 1.0);
            this.max = BaseXDSlider.limit(this.totMin, this.totMax, this.decode(this.oldMax - prop) - 1.0);
        }
        if (this.itr) {
            this.min = (long)this.min;
            this.max = (long)this.max;
        }
        this.listener.actionPerformed(null);
        this.setToolTip();
        this.repaint();
    }

    private void setToolTip() {
        double mn = (double)((long)(this.min * 100.0)) / 100.0;
        double mx = (double)((long)(this.max * 100.0)) / 100.0;
        this.setToolTipText(BaseXLayout.value(mn) + " - " + BaseXLayout.value(mx));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.left = false;
        this.right = false;
        this.center = false;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.oldMin = this.min;
        this.oldMax = this.min;
        double diffMin = 0.0;
        double diffMax = 0.0;
        if (BaseXKeys.PREV.is(e)) {
            diffMin = -1.0;
            diffMax = -1.0;
        } else if (BaseXKeys.NEXT.is(e)) {
            diffMin = 1.0;
            diffMax = 1.0;
        } else if (BaseXKeys.PREVLINE.is(e)) {
            diffMin = -1.0;
            diffMax = 1.0;
        } else if (BaseXKeys.NEXTLINE.is(e)) {
            diffMin = 1.0;
            diffMax = -1.0;
        } else if (BaseXKeys.LINESTART.is(e)) {
            this.min = this.totMin;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.max = this.totMax;
        }
        if (e.isShiftDown()) {
            diffMin /= 10.0;
            diffMax /= 10.0;
        }
        double dist = this.encode(this.totMax) - this.encode(this.totMin);
        diffMin = dist / 20.0 * diffMin;
        diffMax = dist / 20.0 * diffMax;
        if (diffMin != 0.0) {
            this.min = BaseXDSlider.limit(this.totMin, this.max, this.decode(Math.max(0.0, this.encode(this.min) + diffMin)));
        }
        if (diffMax != 0.0) {
            this.max = BaseXDSlider.limit(this.min, this.totMax, this.decode(Math.max(0.0, this.encode(this.max) + diffMax)));
        }
        if (this.min != this.oldMin || this.max != this.oldMax) {
            if (this.itr) {
                if (this.min != this.oldMin) {
                    double d = this.min = this.min > this.oldMin ? Math.max(this.oldMin + 1.0, (double)((long)this.min)) : Math.min(this.oldMin - 1.0, (double)((long)this.min));
                }
                if (this.max != this.oldMax) {
                    this.max = this.max > this.oldMax ? Math.max(this.oldMax + 1.0, (double)((long)this.max)) : Math.min(this.oldMax - 1.0, (double)((long)this.max));
                }
            }
            this.listener.actionPerformed(null);
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth() - 300;
        int h = this.getHeight();
        int hh = h / 2;
        boolean focus = this.hasFocus();
        g.setColor(focus ? Color.white : GUIConstants.WHITE);
        g.fillRect(0, hh - 4, w, 8);
        g.setColor(Color.black);
        g.drawLine(0, hh - 4, w - 1, hh - 4);
        g.drawLine(0, hh - 4, 0, hh + 4);
        g.setColor(GUIConstants.color2);
        g.drawLine(w - 1, hh - 4, w - 1, hh + 4);
        g.drawLine(0, hh + 4, w, hh + 4);
        Range r = new Range(this);
        BaseXLayout.drawCell(g, r.xs, r.xe + 17, 2, h - 2, false);
        if (r.xs + 17 < r.xe) {
            g.setColor(GUIConstants.color4);
            g.drawLine(r.xs + 17, 3, r.xs + 17, h - 4);
            g.drawLine(r.xe - 1, 3, r.xe - 1, h - 4);
            g.setColor(Color.white);
            if (r.xs + 17 + 2 < r.xe) {
                g.drawLine(r.xs + 17 + 1, 4, r.xs + 17 + 1, h - 5);
                g.drawLine(r.xe, 4, r.xe, h - 5);
            }
            g.drawLine(r.xs + 17 - 1, 4, r.xs + 17 - 1, h - 5);
            g.drawLine(r.xe - 2, 4, r.xe - 2, h - 5);
        }
        Polygon pol = new Polygon(new int[]{r.xs + 11, r.xs + 5, r.xs + 5, r.xs + 11}, new int[]{hh - 5, hh - 1, hh, hh + 5}, 4);
        g.setColor(focus ? GUIConstants.color4 : GUIConstants.GRAY);
        g.fillPolygon(pol);
        pol.xpoints = new int[]{r.xe + 5, r.xe + 12, r.xe + 12, r.xe + 5};
        g.fillPolygon(pol);
        g.setColor(focus ? Color.black : GUIConstants.DGRAY);
        g.drawLine(r.xs + 11, hh - 5, r.xs + 11, hh + 4);
        g.drawLine(r.xs + 11, hh - 5, r.xs + 6, hh - 1);
        g.drawLine(r.xe + 5, hh - 5, r.xe + 5, hh + 4);
        g.drawLine(r.xe + 5, hh - 5, r.xe + 11, hh - 1);
        g.setColor(Color.white);
        g.drawLine(r.xs + 10, hh + 4, r.xs + 6, hh + 1);
        g.drawLine(r.xe + 6, hh + 4, r.xe + 11, hh + 1);
        g.setColor(Color.black);
        double mn = (double)((long)(this.min * 100.0)) / 100.0;
        double mx = (double)((long)(this.max * 100.0)) / 100.0;
        g.drawString(BaseXLayout.value(mn) + " - " + BaseXLayout.value(mx), w + 15, h - (h - this.getFont().getSize()) / 2);
    }

    double encode(double v) {
        return this.log ? Math.log(v + 1.0) : v;
    }

    private double decode(double v) {
        return this.log ? Math.exp(v) - 1.0 : v;
    }

    private static double limit(double mn, double mx, double val) {
        return Math.max(mn, Math.min(mx, val));
    }

    private static class Range {
        final double dist;
        final int xs;
        final int xe;
        final int w;

        Range(BaseXDSlider s) {
            this.w = s.getWidth() - 300 - 34;
            this.dist = s.encode(s.totMax - s.totMin);
            this.xs = (int)(s.encode(s.min - s.totMin) * (double)this.w / this.dist);
            this.xe = (s.totMin == s.totMax ? this.w : (int)(s.encode(s.max - s.totMin) * (double)this.w / this.dist)) + 17;
        }
    }
}

