/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.basex.gui.GUI;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.util.Token;
import org.basex.util.Util;

public final class BaseXLayout {
    private static final HashMap<String, ImageIcon> IMAGES = new HashMap();

    private BaseXLayout() {
    }

    static void focus(Component cont) {
        GUI gui = BaseXLayout.gui(cont);
        if (gui == null) {
            return;
        }
        if (gui.gprop.is(GUIProp.MOUSEFOCUS) && cont.isEnabled()) {
            cont.requestFocusInWindow();
        }
    }

    private static GUI gui(Component cont) {
        Container c = cont.getParent();
        return c == null || c instanceof GUI ? (GUI)c : BaseXLayout.gui(c);
    }

    public static void setWidth(Component comp, int w) {
        comp.setPreferredSize(new Dimension(w, comp.getPreferredSize().height));
    }

    public static void setHeight(Component comp, int h) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, h));
    }

    static void setSize(Component comp, int w, int h) {
        comp.setPreferredSize(new Dimension(w, h));
    }

    public static void addDrop(final JComponent comp, final DropHandler dnd) {
        comp.setDropTarget(new DropTarget(comp, 3, null, true, null){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(3);
                Transferable tr = dtde.getTransferable();
                for (Object o : BaseXLayout.contents(tr)) {
                    dnd.drop(o);
                }
                comp.requestFocusInWindow();
            }
        });
    }

    public static ArrayList<Object> contents(Transferable tr) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                for (File fl : (List)tr.getTransferData(DataFlavor.javaFileListFlavor)) {
                    list.add(fl);
                }
            } else if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                list.add(tr.getTransferData(DataFlavor.stringFlavor));
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
        return list;
    }

    static void addInteraction(final Component comp, Window win) {
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseXLayout.focus(comp);
            }
        });
        if (win instanceof BaseXDialog) {
            final BaseXDialog d = (BaseXDialog)win;
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Object s = e.getSource();
                    if (s instanceof BaseXCombo && ((BaseXCombo)s).isPopupVisible()) {
                        return;
                    }
                    if (BaseXKeys.ENTER.is(e)) {
                        if (!(s instanceof BaseXButton)) {
                            d.close();
                        }
                    } else if (BaseXKeys.ESCAPE.is(e)) {
                        d.cancel();
                    }
                }
            });
            return;
        }
        if (!(win instanceof GUI)) {
            Util.notexpected("Reference to main window expected.");
            return;
        }
        final GUI gui = (GUI)win;
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int fs;
                if (gui.context.data() != null) {
                    if (BaseXKeys.GOBACK.is(e)) {
                        GUICommands.C_GOBACK.execute(gui);
                    } else if (BaseXKeys.GOFORWARD.is(e)) {
                        GUICommands.C_GOFORWARD.execute(gui);
                    } else if (BaseXKeys.GOUP.is(e)) {
                        GUICommands.C_GOUP.execute(gui);
                    } else if (BaseXKeys.GOHOME.is(e)) {
                        GUICommands.C_GOHOME.execute(gui);
                    }
                }
                if (BaseXKeys.INPUT1.is(e) || BaseXKeys.INPUT2.is(e)) {
                    gui.input.requestFocusInWindow();
                }
                int nfs = fs = gui.gprop.num(GUIProp.FONTSIZE);
                if (BaseXKeys.INCFONT1.is(e) || BaseXKeys.INCFONT2.is(e)) {
                    nfs = fs + 1;
                } else if (BaseXKeys.DECFONT.is(e)) {
                    nfs = Math.max(1, fs - 1);
                } else if (BaseXKeys.NORMFONT.is(e)) {
                    nfs = 12;
                }
                if (fs != nfs) {
                    gui.gprop.set(GUIProp.FONTSIZE, nfs);
                    gui.updateLayout();
                }
            }
        });
    }

    public static ImageIcon icon(String name) {
        ImageIcon img = IMAGES.get(name);
        if (img != null) {
            return img;
        }
        img = new ImageIcon(BaseXLayout.image(name));
        IMAGES.put(name, img);
        return img;
    }

    public static Image image(String name) {
        return Toolkit.getDefaultToolkit().getImage(BaseXLayout.imageURL(name));
    }

    private static URL imageURL(String name) {
        String path = "/img/" + name + ".png";
        URL url = GUI.class.getResource(path);
        if (url == null) {
            Util.errln("Not found: " + path, new Object[0]);
        }
        return url;
    }

    public static String value(double val) {
        return Token.string(Token.chopNumber(Token.token(val)));
    }

    public static void fill(Graphics gg, Color c1, Color c2, int xs, int ys, int xe, int ye) {
        int w = xe - xs;
        int h = ye - ys;
        int r = c1.getRed();
        int g = c1.getGreen();
        int b = c1.getBlue();
        float rf = (float)(c2.getRed() - r) / (float)h;
        float gf = (float)(c2.getGreen() - g) / (float)h;
        float bf = (float)(c2.getBlue() - b) / (float)h;
        int cr = 0;
        int cg = 0;
        int cb = 0;
        int hh = 0;
        for (int y = 0; y < h; ++y) {
            int nr = r + (int)(rf * (float)y);
            int ng = g + (int)(gf * (float)y);
            int nb = b + (int)(bf * (float)y);
            if (nr != cr || ng != cg || nb != cb) {
                gg.setColor(new Color(nr, ng, nb));
                gg.fillRect(xs, ys + y - hh, w, hh);
                hh = 0;
            }
            cr = nr;
            cg = ng;
            cb = nb;
            ++hh;
        }
        gg.fillRect(xs, ys + h - hh, w, hh);
    }

    public static void drawCell(Graphics g, int xs, int xe, int ys, int ye, boolean focus) {
        g.setColor(GUIConstants.GRAY);
        g.drawRect(xs, ys, xe - xs - 1, ye - ys - 1);
        g.setColor(Color.white);
        g.drawRect(xs + 1, ys + 1, xe - xs - 3, ye - ys - 3);
        BaseXLayout.fill(g, focus ? GUIConstants.LGRAY : Color.white, GUIConstants.LGRAY, xs + 2, ys + 2, xe - 1, ye - 1);
    }

    public static void drawCenter(Graphics g, String text, int w, int y) {
        g.drawString(text, (w - BaseXLayout.width(g, text)) / 2, y);
    }

    public static void drawTooltip(Graphics g, String tt, int x, int y, int w, int c) {
        int tw = BaseXLayout.width(g, tt);
        int th = g.getFontMetrics().getHeight();
        int xx = Math.min(w - tw - 8, x);
        g.setColor(GUIConstants.color(c));
        g.fillRect(xx - 1, y - th, tw + 4, th);
        g.setColor(GUIConstants.WHITE);
        g.drawString(tt, xx, y - 4);
    }

    public static int width(Graphics g, String s) {
        return g.getFontMetrics().stringWidth(s);
    }

    public static void chopString(Graphics g, byte[] s, int x, int y, int w, int fs) {
        if (w < 12) {
            return;
        }
        int[] cw = GUIConstants.fontWidths(g.getFont());
        int j = s.length;
        int fw = 0;
        int l = 0;
        try {
            for (int k = 0; k < j; k += l) {
                int ww = BaseXLayout.width(g, cw, Token.cp(s, k));
                if (fw + ww >= w - 4) {
                    j = Math.max(1, k - l);
                    if (k > 1) {
                        fw -= BaseXLayout.width(g, cw, Token.cp(s, k - 1));
                    }
                    g.drawString("..", x + fw, y + fs);
                    break;
                }
                fw += ww;
                l = Token.cl(s, k);
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        g.drawString(Token.string(s, 0, j), x, y + fs);
    }

    public static int width(Graphics g, byte[] s) {
        int[] cw = GUIConstants.fontWidths(g.getFont());
        int l = s.length;
        int fw = 0;
        try {
            for (int k = 0; k < l; k += Token.cl(s, k)) {
                fw += BaseXLayout.width(g, cw, Token.cp(s, k));
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        return fw;
    }

    public static int width(Graphics g, int[] cw, int c) {
        return c >= cw.length ? g.getFontMetrics().charWidth(c) : cw[c];
    }

    public static interface DropHandler {
        public void drop(Object var1);
    }
}

