/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXSplit;
import org.basex.gui.view.ViewLayout;
import org.basex.gui.view.ViewPanel;
import org.basex.util.Array;

final class ViewAlignment
implements ViewLayout {
    final boolean horiz;
    ViewLayout[] comp = new ViewLayout[0];

    ViewAlignment(boolean h) {
        this.horiz = h;
    }

    void add(ViewLayout obj) {
        this.add(obj, this.comp.length);
    }

    void add(ViewLayout obj, int o) {
        int n = this.comp.length;
        ViewLayout[] tmp = new ViewLayout[n + 1];
        System.arraycopy(this.comp, 0, tmp, 0, o);
        System.arraycopy(this.comp, o, tmp, o + 1, n - o);
        this.comp = tmp;
        this.comp[o] = obj;
    }

    private void remove(int o) {
        this.comp = Array.delete(this.comp, o);
    }

    @Override
    public boolean isVisible() {
        for (ViewLayout c : this.comp) {
            if (!c.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVisibility(boolean db) {
        for (ViewLayout c : this.comp) {
            c.setVisibility(db);
        }
    }

    @Override
    public boolean delete(ViewPanel panel) {
        for (int o = 0; o < this.comp.length; ++o) {
            if (!this.comp[o].delete(panel)) continue;
            if (this.comp[o] instanceof ViewPanel) {
                this.remove(o--);
                continue;
            }
            this.comp[o] = ((ViewAlignment)this.comp[o]).comp[0];
        }
        return this.comp.length < 2;
    }

    @Override
    public void createView(BaseXBack panel) {
        if (!this.isVisible()) {
            return;
        }
        BaseXSplit split = new BaseXSplit(this.horiz);
        for (ViewLayout c : this.comp) {
            c.createView(split);
        }
        panel.add(split);
    }

    @Override
    public String layoutString() {
        StringBuilder str = new StringBuilder(this.horiz ? "H " : "V ");
        for (ViewLayout c : this.comp) {
            str.append(c.layoutString());
        }
        str.append("- ");
        return str.toString();
    }

    public String toString() {
        return (this.horiz ? "Horizontal" : "Vertical") + " Layout";
    }
}

