/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.basex.core.Text;
import org.basex.data.Nodes;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.editor.EditorArea;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.BoolList;

public final class EditorView
extends View {
    private static final String ERRSTRING = Text.STOPPED_AT + ' ' + (Text.LINE_X + ", " + Text.COLUMN_X).replaceAll("%", "([0-9]+)");
    private static final Pattern FILEPATTERN = Pattern.compile(ERRSTRING + ' ' + Text.IN_FILE_X.replaceAll("%", "(.*)") + ":");
    final BaseXButton stop;
    final BaseXLabel info;
    final BaseXLabel pos;
    final BaseXTabs tabs;
    final BaseXTextField find;
    final BaseXButton go;
    int threadID;
    String errFile;
    int errPos;
    private final BaseXLabel header;
    private final BaseXButton filter;

    public EditorView(ViewNotifier man) {
        super("editor", man);
        this.border(6, 6, 6, 6).layout(new BorderLayout()).setFocusable(false);
        this.header = new BaseXLabel(Text.EDITOR, true, false);
        BaseXButton openB = BaseXButton.command(GUICommands.C_EDITOPEN, this.gui);
        final BaseXButton saveB = new BaseXButton(this.gui, "editsave", Token.token(Text.H_SAVE));
        final BaseXButton hist = new BaseXButton(this.gui, "hist", Token.token(Text.H_RECENTLY_OPEN));
        this.find = new BaseXTextField(this.gui);
        BaseXLayout.setHeight(this.find, (int)openB.getPreferredSize().getHeight());
        BaseXBack sp = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(1, 7));
        sp.add(this.find);
        sp.add(Box.createHorizontalStrut(5));
        sp.add(openB);
        sp.add(Box.createHorizontalStrut(1));
        sp.add(saveB);
        sp.add(Box.createHorizontalStrut(1));
        sp.add(hist);
        BaseXBack b = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        b.add((Component)this.header, "Center");
        b.add((Component)sp, "East");
        this.add((Component)b, "North");
        this.tabs = new BaseXTabs(this.gui);
        this.tabs.setFocusable(false);
        this.addCreateTab();
        this.addTab().setSearch(this.find);
        this.add((Component)this.tabs, "Center");
        BaseXBack south = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout(8, 0));
        this.info = new BaseXLabel(" ");
        this.info.setText("OK", GUIConstants.Msg.SUCCESS);
        this.pos = new BaseXLabel(" ");
        sp = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout(8, 0));
        sp.add((Component)this.info, "Center");
        sp.add((Component)this.pos, "East");
        south.add((Component)sp, "Center");
        this.stop = new BaseXButton(this.gui, "stop", Token.token(Text.H_STOP_PROCESS));
        this.stop.addKeyListener(this);
        this.stop.setEnabled(false);
        this.go = new BaseXButton(this.gui, "go", Token.token(Text.H_EXECUTE_QUERY));
        this.go.addKeyListener(this);
        this.filter = BaseXButton.command(GUICommands.C_FILTER, this.gui);
        this.filter.addKeyListener(this);
        sp = new BaseXBack(GUIConstants.Fill.NONE).border(4, 0, 0, 0).layout(new TableLayout(1, 5));
        sp.add(this.stop);
        sp.add(Box.createHorizontalStrut(1));
        sp.add(this.go);
        sp.add(Box.createHorizontalStrut(1));
        sp.add(this.filter);
        south.add((Component)sp, "East");
        this.add((Component)south, "South");
        this.refreshLayout();
        saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu pop = new JPopupMenu();
                StringBuilder mnem = new StringBuilder();
                JMenuItem sa = GUIMenu.newItem(GUICommands.C_EDITSAVE, EditorView.this.gui, mnem);
                JMenuItem sas = GUIMenu.newItem(GUICommands.C_EDITSAVEAS, EditorView.this.gui, mnem);
                GUICommands.C_EDITSAVE.refresh(EditorView.this.gui, sa);
                GUICommands.C_EDITSAVEAS.refresh(EditorView.this.gui, sas);
                pop.add(sa);
                pop.add(sas);
                pop.show(saveB, 0, saveB.getHeight());
            }
        });
        hist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = new JPopupMenu();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ac) {
                        EditorView.this.open(new IOFile(ac.getActionCommand()));
                    }
                };
                if (EditorView.this.gui.gprop.strings(GUIProp.QUERIES).length == 0) {
                    popup.add(new JMenuItem("- No recently opened files -"));
                }
                for (String en : EditorView.this.gui.gprop.strings(GUIProp.QUERIES)) {
                    JMenuItem jmi = new JMenuItem(en);
                    jmi.addActionListener(al);
                    popup.add(jmi);
                }
                popup.show(hist, 0, hist.getHeight());
            }
        });
        this.info.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EditorArea edit = EditorView.this.getEditor();
                if (EditorView.this.errFile != null) {
                    edit = EditorView.this.find(IO.get(EditorView.this.errFile), false);
                    if (edit == null) {
                        edit = EditorView.this.open(new IOFile(EditorView.this.errFile));
                    }
                    EditorView.this.tabs.setSelectedComponent(edit);
                }
                if (EditorView.this.errPos == -1) {
                    return;
                }
                edit.jumpError(EditorView.this.errPos);
                EditorView.this.pos.setText(edit.pos());
            }
        });
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.stop.setEnabled(false);
                EditorView.this.go.setEnabled(false);
                EditorView.this.info.setText("OK", GUIConstants.Msg.SUCCESS);
                EditorView.this.gui.stop();
            }
        });
        this.go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.getEditor().query();
            }
        });
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditorArea edit = EditorView.this.getEditor();
                if (edit == null) {
                    return;
                }
                edit.setSearch(EditorView.this.find);
                EditorView.this.gui.refreshControls();
                EditorView.this.refreshMark();
                EditorView.this.pos.setText(edit.pos());
                if (EditorView.this.gui.gprop.is(GUIProp.EXECRT)) {
                    edit.query();
                }
            }
        });
        BaseXLayout.addDrop(this, new BaseXLayout.DropHandler(){

            @Override
            public void drop(Object file) {
                if (file instanceof File) {
                    EditorView.this.open(new IOFile((File)file));
                }
            }
        });
    }

    @Override
    public void refreshInit() {
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        this.go.setEnabled(this.getEditor().executable && !this.gui.gprop.is(GUIProp.EXECRT));
        Nodes marked = this.gui.context.marked;
        this.filter.setEnabled(!this.gui.gprop.is(GUIProp.FILTERRT) && marked != null && marked.size() != 0L);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshLayout() {
        this.header.setFont(GUIConstants.lfont);
        for (EditorArea edit : this.editors()) {
            edit.setFont(GUIConstants.mfont);
        }
        this.refreshMark();
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public boolean visible() {
        return this.gui.gprop.is(GUIProp.SHOWEDITOR);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gprop.set(GUIProp.SHOWEDITOR, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    public void open() {
        BaseXFileChooser fc = new BaseXFileChooser(Text.OPEN, this.gui.gprop.get(GUIProp.XQPATH), this.gui);
        fc.addFilter("XQuery Files", IO.XQSUFFIXES);
        IOFile file = fc.select(BaseXFileChooser.Mode.FOPEN);
        if (file != null) {
            this.open(file);
        }
    }

    public boolean save() {
        EditorArea edit = this.getEditor();
        if (!edit.opened()) {
            return this.saveAs();
        }
        this.save(edit.file());
        return true;
    }

    public boolean saveAs() {
        EditorArea edit = this.getEditor();
        BaseXFileChooser fc = new BaseXFileChooser(Text.SAVE_AS, edit.file().path(), this.gui);
        fc.addFilter("XQuery Files", IO.XQSUFFIXES);
        IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
        if (file == null) {
            return false;
        }
        this.save(file);
        return true;
    }

    public void newFile() {
        this.addTab();
        this.refresh(false, true);
    }

    public EditorArea open(IOFile file) {
        if (!this.visible()) {
            GUICommands.C_SHOWEDITOR.execute(this.gui);
        }
        EditorArea edit = this.find(file, true);
        try {
            if (edit != null) {
                this.tabs.setSelectedComponent(edit);
                if (!this.confirm(edit)) {
                    return edit;
                }
            } else {
                edit = this.getEditor();
                if (edit.opened() || edit.modified) {
                    edit = this.addTab();
                }
                edit.file(file);
            }
            edit.setText(file.read());
            this.gui.gprop.recent(file);
            this.refresh(false, true);
            if (this.gui.gprop.is(GUIProp.EXECRT)) {
                edit.query();
            }
        }
        catch (IOException ex) {
            BaseXDialog.error(this.gui, Text.FILE_NOT_OPENED);
        }
        return edit;
    }

    public void close(EditorArea edit) {
        EditorArea ea;
        EditorArea editorArea = ea = edit != null ? edit : this.getEditor();
        if (!this.confirm(ea)) {
            return;
        }
        this.tabs.remove(ea);
        int t = this.tabs.getTabCount();
        int i = this.tabs.getSelectedIndex();
        if (t == 1) {
            this.addTab();
        } else if (i + 1 == t) {
            this.tabs.setSelectedIndex(i - 1);
        }
    }

    public void reset() {
        ++this.threadID;
        this.errFile = null;
        this.info.setToolTipText(null);
        this.info.setText("OK", GUIConstants.Msg.SUCCESS);
        this.stop.setEnabled(false);
    }

    public void start() {
        final int thread = this.threadID;
        new Thread(){

            @Override
            public void run() {
                Performance.sleep(200L);
                if (thread == EditorView.this.threadID) {
                    EditorView.this.info.setToolTipText(null);
                    EditorView.this.info.setText(Text.PLEASE_WAIT_D, GUIConstants.Msg.SUCCESS);
                    EditorView.this.stop.setEnabled(true);
                }
            }
        }.start();
    }

    public void info(String msg, boolean ok) {
        ++this.threadID;
        this.errPos = -1;
        this.errFile = null;
        this.info.setCursor(!ok && this.error(msg) ? GUIConstants.CURSORHAND : GUIConstants.CURSORARROW);
        this.info.setText(msg.replaceAll(Text.STOPPED_AT + ".*\\r?\\n\\[.*?\\] ", ""), ok ? GUIConstants.Msg.SUCCESS : GUIConstants.Msg.ERROR);
        this.info.setToolTipText(ok ? null : msg);
        this.stop.setEnabled(false);
        this.go.setEnabled(true);
    }

    private boolean error(String msg) {
        int ll;
        Matcher m = FILEPATTERN.matcher(msg.replaceAll("[\\r\\n].*", ""));
        if (!m.matches()) {
            return true;
        }
        this.errFile = m.group(3);
        EditorArea edit = this.find(IO.get(this.errFile), false);
        if (edit == null) {
            return true;
        }
        int el = Integer.parseInt(m.group(1));
        int ec = Integer.parseInt(m.group(2));
        this.errPos = ll = edit.last.length;
        int l = 1;
        int c = 1;
        for (int e = 0; e < ll; e += Token.cl(edit.last, e)) {
            if (l > el || l == el && c == ec) {
                this.errPos = e;
                break;
            }
            if (edit.last[e] == 10) {
                ++l;
                c = 0;
            }
            ++c;
        }
        edit.markError(this.errPos);
        return this.errPos != -1;
    }

    public boolean confirm() {
        for (EditorArea edit : this.editors()) {
            if (this.confirm(edit)) continue;
            return false;
        }
        return true;
    }

    public boolean saveable() {
        EditorArea area = this.getEditor();
        return !area.opened() || area.modified;
    }

    EditorArea getEditor() {
        Component c = this.tabs.getSelectedComponent();
        return c instanceof EditorArea ? (EditorArea)c : null;
    }

    void refresh(boolean mod, boolean force) {
        EditorArea edit = this.getEditor();
        this.refreshMark();
        if (edit.modified == mod && !force) {
            return;
        }
        String title = edit.file().name();
        if (mod) {
            title = title + "*";
        }
        edit.label.setText(title);
        edit.modified = mod;
        this.gui.refreshControls();
    }

    EditorArea find(IO file, boolean opened) {
        for (EditorArea edit : this.editors()) {
            if (!edit.file().eq(file) || opened && !edit.opened()) continue;
            return edit;
        }
        return null;
    }

    private void save(IOFile file) {
        try {
            EditorArea edit = this.getEditor();
            file.write(edit.getText());
            edit.file(file);
            edit.tstamp = file.timeStamp();
            this.gui.gprop.recent(file);
            this.refresh(false, true);
        }
        catch (IOException ex) {
            BaseXDialog.error(this.gui, Text.FILE_NOT_SAVED);
        }
    }

    private IOFile newTabFile() {
        BoolList bl = new BoolList();
        for (EditorArea edit : this.editors()) {
            if (edit.opened()) continue;
            String n = edit.file().name().substring(Text.FILE.length());
            bl.set(n.isEmpty() ? 1 : Integer.parseInt(n), true);
        }
        int c = 0;
        while (++c < bl.size() && bl.get(c)) {
        }
        String dir = this.gui.gprop.get(GUIProp.XQPATH);
        return new IOFile(dir, Text.FILE + (c == 1 ? "" : Integer.valueOf(c)));
    }

    EditorArea addTab() {
        final EditorArea edit = new EditorArea(this, this.newTabFile());
        edit.setFont(GUIConstants.mfont);
        BaseXBack tab = new BaseXBack(new BorderLayout(10, 0)).mode(GUIConstants.Fill.NONE);
        tab.add((Component)edit.label, "Center");
        BaseXButton close = this.tabButton("editclose");
        close.setRolloverIcon(BaseXLayout.icon("editclose2"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.close(edit);
            }
        });
        tab.add((Component)close, "East");
        this.tabs.add((Component)edit, tab, this.tabs.getComponentCount() - 2);
        return edit;
    }

    private void addCreateTab() {
        BaseXButton add = this.tabButton("editnew");
        add.setRolloverIcon(BaseXLayout.icon("editnew2"));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorView.this.addTab();
                EditorView.this.refresh(false, true);
            }
        });
        this.tabs.add((Component)new BaseXBack(), add, 0);
        this.tabs.setEnabledAt(0, false);
    }

    private BaseXButton tabButton(String icon) {
        BaseXButton b = new BaseXButton(this.gui, icon, null);
        b.border(2, 2, 2, 2).setContentAreaFilled(false);
        b.setFocusable(false);
        return b;
    }

    private boolean confirm(EditorArea edit) {
        Boolean ok;
        return !edit.modified || (ok = BaseXDialog.yesNoCancel(this.gui, Util.info(Text.CLOSE_FILE_X, edit.file().name()))) != null && (ok == false || this.save());
    }

    EditorArea[] editors() {
        ArrayList<EditorArea> edits = new ArrayList<EditorArea>();
        for (Component c : this.tabs.getComponents()) {
            if (!(c instanceof EditorArea)) continue;
            edits.add((EditorArea)c);
        }
        return edits.toArray(new EditorArea[edits.size()]);
    }
}

