/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.table;

import org.basex.core.Context;
import org.basex.core.cmd.Find;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUIProp;
import org.basex.gui.view.table.TableIterator;
import org.basex.index.name.Names;
import org.basex.index.stats.StatsType;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

final class TableData {
    private static final int MAXROWS = 1000;
    private static final byte[] MAXTOK = new byte[]{-1};
    private static final byte[] MAXNUM = Token.token(Double.MAX_VALUE);
    final Context context;
    TokenList roots;
    IntList rootRows;
    IntList rows;
    TableCol[] cols;
    int rowH;
    int sortCol = -1;
    boolean asc;
    int mouseX;
    int mouseY;
    int root;
    private final GUIProp gprop;
    private String last = "";

    TableData(Context ctx, GUIProp pr) {
        this.context = ctx;
        this.gprop = pr;
    }

    void init(Data data) {
        this.roots = new TokenList();
        for (byte[] k : data.paths.desc(Token.EMPTY, true, true)) {
            int c = 0;
            for (byte[] kk : data.paths.desc(k, true, false)) {
                Names nm = Token.startsWith(kk, 64) ? data.atnindex : data.tagindex;
                if (!nm.stat(nm.id(Token.delete(kk, 64))).isLeaf()) continue;
                ++c;
            }
            if (c <= 2) continue;
            this.roots.add(k);
        }
        this.init(data, -1);
    }

    void init(Data data, int r) {
        this.cols = new TableCol[0];
        this.root = r;
        this.sortCol = -1;
        this.last = "";
        this.rowH = 1;
        if (r == -1 && this.roots.isEmpty()) {
            return;
        }
        if (this.root == -1) {
            this.root = data.tagindex.id(this.roots.get(0));
        }
        for (byte[] k : data.paths.desc(data.tagindex.key(this.root), true, true)) {
            byte[] key;
            boolean elem = !Token.startsWith(k, 64);
            Names index = elem ? data.tagindex : data.atnindex;
            if (!index.stat(index.id(key = Token.delete(k, 64))).isLeaf()) continue;
            this.addCol(key, elem);
        }
        this.context(true);
    }

    void context(boolean create) {
        if (this.cols.length == 0) {
            return;
        }
        Nodes n = this.context.current();
        if (!create && n.root && this.rootRows != null) {
            this.rows = this.rootRows;
            this.sortCol = -1;
        } else {
            this.createRows();
            if (n.root) {
                this.rootRows = this.rows;
            }
        }
        if (this.cols[0].width == 0.0 && this.cols[0].hwidth == 0.0) {
            this.calcWidths();
        }
    }

    private void addCol(byte[] name, boolean elem) {
        Data data = this.context.data();
        int id = (elem ? data.tagindex : data.atnindex).id(name);
        if (id == 0) {
            return;
        }
        TableCol col = new TableCol();
        col.id = id;
        col.elem = elem;
        col.name = name;
        this.cols = Array.add(this.cols, col);
    }

    private void createRows() {
        Data data = this.context.data();
        int[] n = this.context.current().pres;
        this.rows = new IntList();
        for (int p : n) {
            if (p >= data.meta.size) break;
            int s = p + data.size(p, data.kind(p));
            while ((data.kind(p) != 1 || data.name(p) != this.root) && ++p < s) {
            }
            while (p < s) {
                int k = data.kind(p);
                if (k == 1 && data.name(p) == this.root) {
                    this.rows.add(p);
                }
                p += data.attSize(p, k);
            }
        }
        this.sort();
    }

    private void calcWidths() {
        if (this.cols.length == 0) {
            return;
        }
        Data data = this.context.data();
        int cs = this.cols.length;
        int nRows = this.rows.size();
        TableIterator ti = new TableIterator(data, this);
        int ll = Math.min(nRows, 1000);
        for (int l = 0; l < ll; ++l) {
            ti.init(this.rows.get(l));
            while (ti.more()) {
                this.cols[ti.col].width += (double)data.textLen(ti.pre, ti.text);
            }
        }
        double[] widths = new double[cs];
        for (int c = 0; c < cs; ++c) {
            widths[c] = this.cols[c].width;
        }
        int[] il = Array.createOrder(widths, false);
        TableCol[] cl = new TableCol[cs];
        for (int c = 0; c < cs; ++c) {
            cl[c] = this.cols[il[c]];
        }
        this.cols = cl;
        this.setWidths(false);
    }

    void setWidths(boolean force) {
        int c;
        double sum = 0.0;
        int cs = this.cols.length;
        for (int c2 = 0; c2 < cs; ++c2) {
            sum += this.cols[c2].width;
        }
        double min = force ? 0.0 : 0.5;
        for (c = 0; c < cs; ++c) {
            this.cols[c].width = Math.max(min / (double)cs, this.cols[c].width / sum);
        }
        sum = 0.0;
        for (c = 0; c < cs; ++c) {
            sum += this.cols[c].width;
        }
        for (c = 0; c < cs; ++c) {
            this.cols[c].width /= sum;
        }
    }

    void sort() {
        if (this.sortCol == -1) {
            return;
        }
        int c = this.cols[this.sortCol].id;
        boolean e = this.cols[this.sortCol].elem;
        Data data = this.context.data();
        Names index = e ? data.tagindex : data.atnindex;
        StatsType type = index.stat((int)c).type;
        boolean num = type == StatsType.INTEGER || type == StatsType.DOUBLE;
        byte[][] tokens = new byte[this.rows.size()][];
        int rs = this.rows.size();
        for (int r = 0; r < rs; ++r) {
            int k;
            int p;
            int s = p + data.size(p, data.kind(p));
            for (p = this.rows.get(r); p != s; p += e ? data.attSize(p, k) : 1) {
                k = data.kind(p);
                if ((!e || k != 1) && (e || k != 3) || data.name(p) != c) continue;
                tokens[r] = data.atom(p);
                break;
            }
            if (tokens[r] != null && tokens[r].length != 0) continue;
            tokens[r] = num ? MAXNUM : MAXTOK;
        }
        this.rows.sort(tokens, num, this.asc);
    }

    int getRoot(Data data, int pre) {
        if (pre == -1) {
            return -1;
        }
        int p = pre;
        int k = data.kind(p);
        while (p != -1 && (k != 1 || data.name(p) != this.root)) {
            k = (p = data.parent(p, k)) != -1 ? data.kind(p) : 0;
        }
        return p;
    }

    int column(int w, int mx) {
        double cs = 0.0;
        for (int i = 0; i < this.cols.length; ++i) {
            double cw = (double)w * this.cols[i].width;
            double ce = cs + cw;
            if ((double)mx > cs && (double)mx < ce) {
                return i;
            }
            cs = ce;
        }
        return -1;
    }

    void resetFilter() {
        for (TableCol col : this.cols) {
            col.filter = "";
        }
    }

    String find() {
        Data data = this.context.data();
        boolean r = this.rows == this.rootRows;
        StringList filters = new StringList();
        TokenList names = new TokenList();
        BoolList elems = new BoolList();
        for (TableCol col : this.cols) {
            filters.add(col.filter);
            names.add(col.name);
            elems.add(col.elem);
        }
        String query = Find.findTable(filters, names, elems, data.tagindex.key(this.root), this.gprop.is(GUIProp.FILTERRT) || r);
        if (query.equals(this.last)) {
            return null;
        }
        this.last = query;
        return query;
    }

    int rowH(double f) {
        this.rowH = Math.max(1, (int)(f * (double)this.gprop.num(GUIProp.FONTSIZE) * 7.0 / 4.0));
        return this.rowH;
    }

    static final class TableCol {
        byte[] name;
        int id;
        boolean elem;
        double width;
        double hwidth;
        String filter = "";

        TableCol() {
        }
    }
}

