/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBar;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.table.TableContent;
import org.basex.gui.view.table.TableData;
import org.basex.gui.view.table.TableHeader;
import org.basex.gui.view.table.TableIterator;
import org.basex.util.Performance;
import org.basex.util.list.IntList;

public final class TableView
extends View
implements Runnable {
    private static final double[] ZOOM = new double[]{1.0, 0.99, 0.98, 0.97, 1.0, 1.03, 1.05, 0.9, 0.8, 0.6, 0.35, 0.18, 0.13, 0.09, 0.05, 0.03};
    final TableData tdata;
    private final TableHeader header;
    private final TableContent content;
    private final BaseXBar scroll;

    public TableView(ViewNotifier man) {
        super("table", man);
        this.tdata = new TableData(this.gui.context, this.gui.gprop);
        this.layout(new BorderLayout());
        this.header = new TableHeader(this);
        this.add((Component)this.header, "North");
        this.scroll = new BaseXBar(this);
        this.content = new TableContent(this.tdata, this.scroll);
        this.add((Component)this.content, "Center");
        new BaseXPopup(this, GUIConstants.POPUP);
    }

    @Override
    public void refreshInit() {
        this.tdata.rootRows = null;
        this.tdata.rows = null;
        Data data = this.gui.context.data();
        if (!this.visible() || data == null) {
            return;
        }
        this.tdata.init(data);
        this.refreshContext(true, false);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        if (this.tdata.cols.length == 0) {
            return;
        }
        this.tdata.context(false);
        this.scroll.pos(0);
        if (this.tdata.rows == null) {
            return;
        }
        if (quick) {
            this.scroll.height(this.tdata.rows.size() * this.tdata.rowH(1.0));
            this.focus();
            this.repaint();
        } else {
            if (!more) {
                this.tdata.resetFilter();
            }
            this.gui.updating = true;
            new Thread(this).start();
        }
    }

    @Override
    public void refreshFocus() {
        if (!this.visible() || this.tdata.rows == null) {
            return;
        }
        this.repaint();
    }

    @Override
    public void refreshMark() {
        int p;
        if (!this.visible() || this.tdata.rows == null) {
            return;
        }
        Context context = this.gui.context;
        Nodes marked = context.marked;
        if (marked.size() != 0L && (p = this.tdata.getRoot(context.data(), marked.pres[0])) != -1) {
            this.setPos(p);
        }
        this.repaint();
    }

    @Override
    public void refreshLayout() {
        if (!this.visible() || this.tdata.rows == null) {
            return;
        }
        this.scroll.height(this.tdata.rows.size() * this.tdata.rowH(1.0));
        this.refreshContext(false, true);
    }

    @Override
    public void refreshUpdate() {
        this.tdata.rootRows = null;
        this.tdata.init(this.gui.context.data());
        this.refreshContext(false, true);
    }

    @Override
    public boolean visible() {
        return this.gui.gprop.is(GUIProp.SHOWTABLE);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gprop.set(GUIProp.SHOWTABLE, v);
    }

    @Override
    protected boolean db() {
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.tdata.rows == null && this.visible()) {
            this.refreshInit();
        }
    }

    @Override
    public void run() {
        int zoomstep = ZOOM.length;
        while (--zoomstep >= 0) {
            this.scroll.height(this.tdata.rows.size() * this.tdata.rowH(ZOOM[zoomstep]));
            this.repaint();
            Performance.sleep(25L);
        }
        this.gui.updating = false;
        this.focus();
    }

    private void setPos(int pre) {
        int off = this.getOff(pre);
        if (off == -1) {
            return;
        }
        int h = this.getHeight() - this.header.getHeight() - 2 * this.tdata.rowH;
        int y = (off - 1) * this.tdata.rowH;
        int s = this.scroll.pos();
        if (y < s || y > s + h) {
            this.scroll.pos(y);
        }
    }

    private int getOff(int pre) {
        int ns = this.tdata.rows.size();
        for (int n = 0; n < ns; ++n) {
            if (this.tdata.rows.get(n) != pre) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (!this.visible() || this.tdata.rows == null) {
            return;
        }
        this.tdata.mouseX = e.getX();
        this.tdata.mouseY = e.getY();
        this.focus();
    }

    private void focus() {
        int y = this.tdata.mouseY - this.header.getHeight() + this.scroll.pos();
        int l = y / this.tdata.rowH;
        boolean valid = y >= 0 && l < this.tdata.rows.size();
        Data data = this.gui.context.data();
        int focused = -1;
        if (valid) {
            int pre = this.tdata.rows.get(l);
            TableIterator it = new TableIterator(data, this.tdata);
            int c = this.tdata.column(this.getWidth() - 16, this.tdata.mouseX);
            it.init(pre);
            while (it.more()) {
                if (it.col != c) continue;
                focused = it.pre;
                break;
            }
        }
        this.gui.notify.focus(focused, this);
        this.content.repaint();
        String str = this.content.focusedString;
        this.gui.cursor(valid && str != null && str.length() <= data.meta.maxlen ? GUIConstants.CURSORHAND : GUIConstants.CURSORARROW);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.gui.cursor(GUIConstants.CURSORARROW);
        this.gui.notify.focus(-1, null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int pre = this.gui.context.focused;
        if (pre == -1) {
            return;
        }
        super.mousePressed(e);
        Context context = this.gui.context;
        Data data = this.gui.context.data();
        if (this.tdata.rows == null) {
            return;
        }
        if (e.getY() < this.header.getHeight()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getClickCount() == 1) {
                int c = this.tdata.column(this.getWidth() - 16, e.getX());
                String str = this.content.focusedString;
                if (str == null || str.length() > data.meta.maxlen) {
                    return;
                }
                if (!e.isShiftDown()) {
                    this.tdata.resetFilter();
                }
                this.tdata.cols[c].filter = str;
                this.query();
            } else {
                Nodes nodes = context.marked;
                if (this.getCursor() == GUIConstants.CURSORARROW) {
                    nodes = new Nodes(this.tdata.getRoot(nodes.data, pre), nodes.data);
                }
                this.gui.notify.context(nodes, false, null);
            }
        } else if (pre != -1) {
            TableIterator it = new TableIterator(data, this.tdata);
            int c = this.tdata.column(this.getWidth() - 16, e.getX());
            it.init(pre);
            while (it.more()) {
                if (it.col != c) continue;
                this.gui.notify.mark(new Nodes(it.pre, data), null);
                return;
            }
        }
    }

    void query() {
        String query = this.tdata.find();
        if (query != null) {
            this.gui.xquery(query, false);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.tdata.rows == null) {
            return;
        }
        this.scroll.pos(this.scroll.pos() + e.getUnitsToScroll() * this.tdata.rowH);
        this.mouseMoved(e);
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int oldPre;
        super.keyPressed(e);
        if (this.tdata.rows == null) {
            return;
        }
        int lines = (this.getHeight() - this.header.getHeight()) / this.tdata.rowH;
        int pre = oldPre = this.tdata.getRoot(this.gui.context.data(), this.gui.context.focused);
        IntList rows = this.tdata.rows;
        if (BaseXKeys.LINESTART.is(e)) {
            pre = rows.get(0);
        } else if (BaseXKeys.LINEEND.is(e)) {
            pre = rows.get(rows.size() - 1);
        } else if (BaseXKeys.PREVLINE.is(e)) {
            pre = rows.get(Math.max(0, this.getOff(pre) - 1));
        } else if (BaseXKeys.NEXTLINE.is(e)) {
            pre = rows.get(Math.min(rows.size() - 1, this.getOff(pre) + 1));
        } else if (BaseXKeys.PREVPAGE.is(e)) {
            pre = rows.get(Math.max(0, this.getOff(pre) - lines));
        } else if (BaseXKeys.NEXTPAGE.is(e)) {
            pre = rows.get(Math.min(rows.size() - 1, this.getOff(pre) + lines));
        }
        if (pre != oldPre) {
            this.setPos(pre);
            this.gui.notify.focus(pre, null);
        }
    }
}

