/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import org.basex.core.Command;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.layout.XMLSyntax;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.util.Token;
import org.basex.util.Util;

public final class TextView
extends View
implements ActionListener {
    private final BaseXLabel header;
    private final BaseXButton home;
    private final BaseXEditor area;
    private Command cmd;
    private Nodes ns;

    public TextView(ViewNotifier man) {
        super("text", man);
        this.border(6, 6, 6, 6).layout(new BorderLayout(0, 4)).setFocusable(false);
        BaseXBack b = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        this.home = BaseXButton.command(GUICommands.C_HOME, this.gui);
        this.home.setEnabled(false);
        BaseXBack sp = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(1, 2));
        sp.add(this.home);
        sp.add(Box.createHorizontalStrut(8));
        b.add((Component)sp, "West");
        this.header = new BaseXLabel(Text.TEXT, true, false);
        b.add((Component)this.header, "Center");
        BaseXButton save = new BaseXButton(this.gui, "save", Token.token(Text.H_SAVE_RESULT));
        save.addActionListener(this);
        BaseXTextField find = new BaseXTextField(this.gui);
        BaseXLayout.setHeight(find, (int)save.getPreferredSize().getHeight());
        sp = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(1, 3));
        sp.add(find);
        sp.add(Box.createHorizontalStrut(5));
        sp.add(save);
        b.add((Component)sp, "East");
        this.add((Component)b, "North");
        this.area = new BaseXEditor(false, this.gui);
        this.area.setSyntax(new XMLSyntax());
        this.area.setSearch(find);
        this.add((Component)this.area, "Center");
        this.refreshLayout();
    }

    @Override
    public void refreshInit() {
        this.refreshContext(true, true);
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        this.setText(this.gui.context.marked);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        this.setText(this.gui.context.current());
    }

    @Override
    public void refreshLayout() {
        this.header.setFont(GUIConstants.lfont);
        this.area.setFont(GUIConstants.mfont);
    }

    @Override
    public void refreshUpdate() {
        this.refreshContext(true, true);
    }

    @Override
    public boolean visible() {
        return this.gui.gprop.is(GUIProp.SHOWTEXT);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gprop.set(GUIProp.SHOWTEXT, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    private void setText(Nodes n) {
        if (this.visible()) {
            try {
                ArrayOutput ao = new ArrayOutput().max(this.gui.gprop.num(GUIProp.MAXTEXT));
                if (n != null) {
                    n.serialize(Serializer.get(ao));
                }
                this.setText(ao);
                this.cmd = null;
                this.ns = ao.finished() ? n : null;
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        } else {
            this.home.setEnabled(this.gui.context.data() != null);
        }
    }

    public void cacheText(ArrayOutput out, Command c, Result r) {
        this.cmd = null;
        this.ns = null;
        int mh = this.gui.context.prop.num(Prop.MAXHITS);
        if (mh >= 0 && r != null && r.size() >= (long)mh) {
            this.cmd = c;
        } else if (out.finished()) {
            if (r instanceof Nodes) {
                this.ns = (Nodes)r;
            } else {
                this.cmd = c;
            }
        }
    }

    public void setText(ArrayOutput out) {
        byte[] buf = out.buffer();
        int size = (int)out.size();
        byte[] chop = Token.token("...");
        if (out.finished() && size >= chop.length) {
            System.arraycopy(chop, 0, buf, size - chop.length, chop.length);
        }
        this.area.setText(buf, size);
        this.header.setText(Text.TEXT + (out.finished() ? Text.CHOPPED : ""));
        this.home.setEnabled(this.gui.context.data() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        BaseXFileChooser fc = new BaseXFileChooser(Text.SAVE_AS, this.gui.gprop.get(GUIProp.SAVEPATH), this.gui);
        IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
        if (file == null) {
            return;
        }
        this.gui.gprop.set(GUIProp.SAVEPATH, file.path());
        PrintOutput out = null;
        this.gui.cursor(GUIConstants.CURSORWAIT, true);
        Prop prop = this.gui.context.prop;
        int mh = prop.num(Prop.MAXHITS);
        prop.set(Prop.MAXHITS, -1);
        prop.set(Prop.CACHEQUERY, false);
        try {
            out = new PrintOutput(file.toString());
            if (this.cmd != null) {
                this.cmd.execute(this.gui.context, out);
            } else if (this.ns != null) {
                this.ns.serialize(Serializer.get(out));
            } else {
                byte[] txt;
                for (byte t : txt = this.area.getText()) {
                    if (t >= 0 && t <= 32 && !Token.ws(t)) continue;
                    out.write(t);
                }
            }
        }
        catch (IOException ex) {
            BaseXDialog.error(this.gui, Text.FILE_NOT_SAVED);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
            prop.set(Prop.MAXHITS, mh);
            prop.set(Prop.CACHEQUERY, true);
            this.gui.cursor(GUIConstants.CURSORARROW, true);
        }
    }
}

