/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.tree;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.gui.view.tree.TreeBorder;
import org.basex.gui.view.tree.TreeConstants;
import org.basex.util.list.IntList;

final class TreeNodeCache
implements TreeConstants {
    private final int maxLevel;
    private final IntList[] nodes;

    TreeNodeCache(Data data, boolean atts) {
        ArrayList<IntList> alil = new ArrayList<IntList>();
        int ts = data.meta.size;
        IntList roots = data.resources.docs();
        alil.add(new IntList());
        int rs = roots.size();
        for (int i = 0; i < rs; ++i) {
            int root = roots.get(i);
            ((IntList)alil.get(0)).add(root);
            int sh = i + 1 == roots.size() ? ts : roots.get(i + 1);
            for (int p = root + 1; p < sh; ++p) {
                int k = data.kind(p);
                if (!atts && k == 3) continue;
                int par = data.parent(p, k);
                int lv = -1;
                int is = alil.size();
                while (++lv < is && par != ((IntList)alil.get(lv)).peek()) {
                }
                for (int j = is; j <= lv + 1; ++j) {
                    alil.add(new IntList());
                }
                ((IntList)alil.get(lv + 1)).add(p);
            }
        }
        this.maxLevel = alil.size();
        this.nodes = alil.toArray(new IntList[alil.size()]);
    }

    private int getMinIndex(int lv, int lp, int rp) {
        boolean l = false;
        int r = this.nodes[lv].size() - 1;
        int min = this.searchPreIndex(lv, lp, rp, 0, r);
        if (min == -1) {
            return min;
        }
        int[] n = this.nodes[lv].toArray();
        while (min-- > 0 && n[min] > lp) {
        }
        return min + 1;
    }

    TreeBorder[] subtree(Data d, int pre) {
        int min;
        TreeBorder[] bo = new TreeBorder[this.maxLevel];
        if (pre == 0 && d.resources.docs().size() == 1) {
            for (int i = 0; i < this.maxLevel; ++i) {
                bo[i] = new TreeBorder(i, 0, this.nodes[i].size());
            }
            return bo;
        }
        int[] rlp = this.findPre(pre);
        int rl = rlp[0];
        int ri = rlp[1];
        bo[rl] = new TreeBorder(rl, ri, 1);
        int np = pre + d.size(pre, d.kind(pre));
        int h = 1;
        for (int i = rl + 1; i < this.maxLevel && (min = this.getMinIndex(i, pre, np)) != -1; ++i) {
            int c = 0;
            for (int j = min; j < this.nodes[i].size() && this.nodes[i].get(j) < np; ++j) {
                ++c;
            }
            bo[i] = new TreeBorder(i, min, c);
            ++h;
        }
        TreeBorder[] bon = new TreeBorder[h];
        System.arraycopy(bo, rl, bon, 0, h);
        return bon;
    }

    private int[] findPre(int pre) {
        int[] nArray;
        int l;
        int pos = -1;
        for (l = 0; l < this.maxLevel && (pos = this.searchPreArrayPos(l, 0, this.nodes[l].size() - 1, pre)) <= -1; ++l) {
        }
        if (pos > -1) {
            int[] nArray2 = new int[2];
            nArray2[0] = l;
            nArray = nArray2;
            nArray2[1] = pos;
        } else {
            nArray = null;
        }
        return nArray;
    }

    int searchPreArrayPos(int lv, int l, int r, int pre) {
        return this.searchPreIndex(lv, pre, pre, l, r);
    }

    int searchPreIndex(int lv, int lb, int rb, int l, int r) {
        int index = -1;
        int ll = l;
        int rr = r;
        while (rr >= ll && index == -1) {
            int m = ll + (rr - ll) / 2;
            if (this.nodes[lv].get(m) < lb) {
                ll = m + 1;
                continue;
            }
            if (this.nodes[lv].get(m) > rb) {
                rr = m - 1;
                continue;
            }
            index = m;
        }
        return index;
    }

    int getPrePerLevelAndIndex(int lv, int i) {
        return this.nodes[lv].get(i);
    }
}

