/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.util.Arrays;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.Index;
import org.basex.index.IndexType;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.stats.IndexStats;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenSet;

public class MemValues
extends TokenSet
implements Index {
    int[][] ids = new int[8][];
    int[] len = new int[8];
    final Data data;

    public MemValues(Data d) {
        this.data = d;
    }

    @Override
    public synchronized void init() {
    }

    @Override
    public IndexIterator iter(IndexToken tok) {
        final byte k = tok.type() == IndexType.TEXT ? (byte)2 : 3;
        int i = this.id(tok.get());
        if (i > 0) {
            final int[] pres = this.ids[i];
            final int s = this.len[i];
            if (s > 0) {
                return new IndexIterator(){
                    int p;

                    @Override
                    public boolean more() {
                        return this.p < s;
                    }

                    @Override
                    public int next() {
                        while (this.more() && MemValues.this.data.kind(pres[this.p++]) != k) {
                        }
                        return pres[this.p - 1];
                    }
                };
            }
        }
        return IndexIterator.EMPTY;
    }

    @Override
    public int count(IndexToken it) {
        int i = this.id(it.get());
        return i == 0 ? 0 : this.len[i];
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        final byte[] prefix = entries.get();
        return new EntryIterator(){
            int c;

            @Override
            public byte[] next() {
                while (++this.c < MemValues.this.size) {
                    if (!Token.startsWith(MemValues.this.keys[this.c], prefix)) continue;
                    return MemValues.this.keys[this.c];
                }
                return null;
            }

            @Override
            public int count() {
                return MemValues.this.len[this.c];
            }
        };
    }

    @Override
    public byte[] info() {
        TokenBuilder tb = new TokenBuilder("- Structure: ").add("Sorted List").add(Text.NL);
        IndexStats stats = new IndexStats(this.data);
        for (int m = 1; m < this.size; ++m) {
            int oc = this.len[m];
            if (!stats.adding(oc)) continue;
            stats.add(this.key(m));
        }
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public void close() {
    }

    @Override
    public void rehash() {
        super.rehash();
        int s = this.size << 1;
        this.ids = Array.copyOf(this.ids, s);
        this.len = Arrays.copyOf(this.len, s);
    }

    public int index(byte[] key, int id) {
        int i = this.add(key);
        if (i > 0) {
            this.ids[i] = new int[]{id};
        } else {
            int l = this.len[i = -i];
            if (l == this.ids[i].length) {
                this.ids[i] = Arrays.copyOf(this.ids[i], l << 1);
            }
            this.ids[i][l] = id;
        }
        int n = i;
        this.len[n] = this.len[n] + 1;
        return i;
    }

    public void delete(byte[] key, int id) {
    }
}

