/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.util.Token;
import org.basex.util.Util;

public final class MimeTypes {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHARSET = "; charset=";
    public static final String APP_HTML_XML = "application/html+xml";
    public static final String APP_JSON = "application/json";
    public static final String APP_JSONML = "application/jsonml+json";
    public static final String APP_OCTET = "application/octet-stream";
    public static final String APP_XML = "application/xml";
    public static final String APP_EXT_XML = "application/xml-external-parsed-entity";
    public static final String APP_FORM = "application/x-www-form-urlencoded";
    public static final String TEXT_CSV = "text/comma-separated-values";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String MIME_XML_SUFFIX = "+xml";
    public static final String MIME_TEXT_PREFIX = "text/";
    public static final String TEXT_XML_EXT = "text/xml-external-parsed-entity";
    private static final HashMap<String, String> TYPES;

    private MimeTypes() {
    }

    public static String get(String path) {
        String ct = TYPES.get(IO.suffix(path));
        return ct != null ? ct : APP_OCTET;
    }

    public static boolean isXML(String type) {
        return Token.eq(type, TEXT_XML, TEXT_XML_EXT, APP_XML, APP_EXT_XML) || type.endsWith(MIME_XML_SUFFIX);
    }

    public static boolean isText(String type) {
        return type.startsWith(MIME_TEXT_PREFIX);
    }

    public static boolean matches(String type, String pattern) {
        String[] t = type.split("/", 2);
        String[] p = pattern.split("/", 2);
        return !(t.length != 2 || p.length != 2 || !p[0].equals("*") && !p[0].equals(t[0]) || !p[1].equals("*") && !p[1].equals(t[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block7: {
            TYPES = new HashMap();
            try {
                String file = "/mime.properties";
                InputStream is = MimeTypes.class.getResourceAsStream("/mime.properties");
                if (is == null) {
                    Util.errln("/mime.properties not found.", new Object[0]);
                    break block7;
                }
                NewlineInput nli = new NewlineInput(is);
                try {
                    String line;
                    while ((line = nli.readLine()) != null) {
                        int i = line.indexOf(61);
                        if (i == -1 || line.startsWith("#")) continue;
                        TYPES.put(line.substring(0, i), line.substring(i + 1));
                    }
                }
                finally {
                    nli.close();
                }
            }
            catch (IOException ex) {
                Util.errln(ex, new Object[0]);
            }
        }
    }
}

