/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.basex.core.Progress;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.list.ByteList;
import org.basex.util.list.StringList;

public final class Zip
extends Progress {
    private final IO archive;
    private int total;
    private int curr;

    public Zip(IO file) {
        this.archive = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size() throws IOException {
        int c = 0;
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(this.archive.inputStream());
            while (in.getNextEntry() != null) {
                ++c;
            }
            int n = c;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(String path) throws IOException {
        ZipInputStream in = new ZipInputStream(this.archive.inputStream());
        try {
            byte[] cont = Zip.getEntry(in, path);
            if (cont == null) {
                throw new FileNotFoundException(path);
            }
            byte[] byArray = cont;
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unzip(IOFile target) throws IOException {
        byte[] data = new byte[4096];
        ZipInputStream in = new ZipInputStream(this.archive.inputStream());
        this.total = this.size();
        this.curr = 0;
        try {
            ZipEntry ze;
            while ((ze = in.getNextEntry()) != null) {
                ++this.curr;
                IOFile trg = new IOFile(target, ze.getName());
                if (ze.isDirectory()) {
                    trg.md();
                    continue;
                }
                new IOFile(trg.dir()).md();
                FileOutputStream out = null;
                try {
                    int c;
                    out = new FileOutputStream(trg.path());
                    while ((c = in.read(data)) != -1) {
                        ((OutputStream)out).write(data, 0, c);
                    }
                    if (out == null) continue;
                }
                catch (Throwable throwable) {
                    if (out == null) throw throwable;
                    try {
                        ((OutputStream)out).close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                }
            }
            return;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(IOFile source, Pattern pattern) throws IOException {
        if (!(this.archive instanceof IOFile)) {
            throw new FileNotFoundException(this.archive.path());
        }
        byte[] data = new byte[4096];
        ZipOutputStream out = null;
        this.curr = 0;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.archive.path())));
            out.setLevel(1);
            out.putNextEntry(new ZipEntry(source.name() + '/'));
            out.closeEntry();
            StringList files = source.descendants();
            this.total = files.size();
            for (String io : files) {
                ++this.curr;
                if (pattern != null && !pattern.matcher(io).matches()) continue;
                FileInputStream in = null;
                try {
                    int c;
                    in = new FileInputStream(new File(source.file(), io));
                    out.putNextEntry(new ZipEntry(source.name() + '/' + io));
                    while ((c = in.read(data)) != -1) {
                        out.write(data, 0, c);
                    }
                    out.closeEntry();
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    protected double prog() {
        return (double)this.curr / (double)this.total;
    }

    public static byte[] getEntry(ZipInputStream in, String entry) throws IOException {
        ZipEntry ze;
        while ((ze = in.getNextEntry()) != null) {
            int c;
            if (!entry.equals(ze.getName())) continue;
            int s = (int)ze.getSize();
            if (s >= 0) {
                int c2;
                byte[] data = new byte[s];
                int o = 0;
                while (s - o != 0 && (c2 = in.read(data, o, s - o)) != -1) {
                    o += c2;
                }
                return data;
            }
            byte[] data = new byte[4096];
            ByteList bl = new ByteList();
            while ((c = in.read(data)) != -1) {
                bl.add(data, 0, c);
            }
            return bl.toArray();
        }
        return null;
    }
}

