/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.util.Arrays;
import org.basex.io.out.PrintOutput;
import org.basex.util.Token;

public final class ArrayOutput
extends PrintOutput {
    private byte[] buf = new byte[8];

    public ArrayOutput max(int m) {
        this.max = m;
        return this;
    }

    @Override
    public void write(int b) {
        int s = (int)this.size;
        if ((long)s == this.max) {
            return;
        }
        if (s == this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, s << 1);
        }
        this.buf[s] = (byte)b;
        this.size = s + 1;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.buf, (int)this.size);
    }

    @Override
    public boolean finished() {
        return this.size == this.max;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public void reset() {
        this.size = 0L;
    }

    public String toString() {
        return Token.string(this.buf, 0, (int)this.size);
    }
}

