/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.io.serial.Serializer;
import org.basex.query.value.item.Item;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.Util;

public class BuilderSerializer
extends Serializer {
    private final Atts att = new Atts();
    private final Builder build;

    public BuilderSerializer(Builder b) {
        this.build = b;
    }

    @Override
    public final void finishText(byte[] b) throws IOException {
        this.build.text(b);
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
    }

    @Override
    public final void finishPi(byte[] n, byte[] v) throws IOException {
        this.build.pi(Token.concat(n, Token.SPACE, v));
    }

    @Override
    public final void atomic(Item b) throws IOException {
        Util.notexpected(new Object[0]);
    }

    @Override
    protected final void finishOpen() throws IOException {
        this.build.startElem(this.elem, this.att);
        this.att.reset();
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.build.emptyElem(this.elem, this.att);
        this.att.reset();
    }

    @Override
    protected void finishClose() throws IOException {
        this.build.endElem();
    }

    @Override
    public final void finishComment(byte[] b) throws IOException {
        this.build.comment(b);
    }

    @Override
    public final void attribute(byte[] n, byte[] v) throws IOException {
        if (Token.startsWith(n, Token.XMLNS)) {
            if (n.length == 5) {
                this.build.startNS(Token.EMPTY, v);
            } else if (n[5] == 58) {
                this.build.startNS(Token.substring(n, 6), v);
            } else {
                this.att.add(n, v);
            }
        } else {
            this.att.add(n, v);
        }
    }

    @Override
    public void openDoc(byte[] name) throws IOException {
        this.build.startDoc(name);
    }

    @Override
    public final void closeDoc() throws IOException {
        this.build.endDoc();
    }
}

